/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.info.display.field;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.dynamic.data.mapping.info.display.field.DDMFormValuesInfoDisplayFieldProvider;
import com.liferay.dynamic.data.mapping.kernel.DDMForm;
import com.liferay.dynamic.data.mapping.kernel.DDMFormField;
import com.liferay.dynamic.data.mapping.kernel.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.Value;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDMFormValuesInfoDisplayFieldProvider.class})
public class DDMFormValuesInfoDisplayFieldProviderImpl<T extends GroupedModel>
implements DDMFormValuesInfoDisplayFieldProvider<T> {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormValuesInfoDisplayFieldProviderImpl.class);
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private JSONFactory _jsonFactory;

    public Map<String, Object> getInfoDisplayFieldsValues(T t, DDMFormValues ddmFormValues, Locale locale) throws PortalException {
        HashMap<String, Object> infoDisplayFieldValues = new HashMap<String, Object>();
        Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
        if (MapUtil.isEmpty((Map)ddmFormFieldValuesMap)) {
            return infoDisplayFieldValues;
        }
        DDMForm ddmForm = ddmFormValues.getDDMForm();
        Map ddmFormFields = ddmForm.getDDMFormFieldsMap(true);
        for (Map.Entry entry : ddmFormFieldValuesMap.entrySet()) {
            DDMFormField ddmFormField = (DDMFormField)ddmFormFields.get(entry.getKey());
            List<DDMFormFieldValue> ddmFormFieldsValues = (List<DDMFormFieldValue>)entry.getValue();
            if ((Objects.equals(ddmFormField.getType(), "ddm-image") || Objects.equals(ddmFormField.getType(), "image")) && ddmFormFieldsValues.size() > 1) {
                ddmFormFieldsValues = Collections.singletonList(ddmFormFieldsValues.get(0));
            }
            this._addDDMFormFieldValues(t, (String)entry.getKey(), ddmFormFieldsValues, infoDisplayFieldValues, locale);
        }
        return infoDisplayFieldValues;
    }

    private void _addDDMFormFieldValues(T t, String key, List<DDMFormFieldValue> ddmFormFieldValues, Map<String, Object> classTypeValues, Locale locale) throws PortalException {
        Object fieldValue = null;
        if (ddmFormFieldValues.size() == 1) {
            DDMFormFieldValue ddmFormFieldValue2 = ddmFormFieldValues.get(0);
            this._addNestedFields(t, ddmFormFieldValue2, classTypeValues, locale);
            fieldValue = this._sanitizeFieldValue(t, ddmFormFieldValue2, locale);
        } else {
            Stream stream = ddmFormFieldValues.stream();
            fieldValue = stream.map(ddmFormFieldValue -> {
                try {
                    this._addNestedFields(t, (DDMFormFieldValue)ddmFormFieldValue, classTypeValues, locale);
                    return this._sanitizeFieldValue(t, (DDMFormFieldValue)ddmFormFieldValue, locale);
                }
                catch (PortalException portalException) {
                    _log.error((Object)("Unable to sanitize field " + ddmFormFieldValue.getName()), (Throwable)portalException);
                    return null;
                }
            }).filter(value -> value != null).collect(Collectors.toList());
        }
        if (classTypeValues.containsKey(key)) {
            ArrayList<Object> fieldValues = new ArrayList<Object>();
            Object classTypeValue = classTypeValues.get(key);
            if (classTypeValue instanceof Collection) {
                fieldValues.addAll((Collection)classTypeValue);
            } else {
                fieldValues.add(classTypeValue);
            }
            if (fieldValue instanceof Collection) {
                fieldValues.addAll((Collection)fieldValue);
            } else {
                fieldValues.add(fieldValue);
            }
            classTypeValues.put(key, fieldValues);
        } else {
            classTypeValues.put(key, fieldValue);
        }
    }

    private void _addNestedFields(T t, DDMFormFieldValue ddmFormFieldValue, Map<String, Object> classTypeValues, Locale locale) throws PortalException {
        Map nestedDDMFormFieldValuesMap = ddmFormFieldValue.getNestedDDMFormFieldValuesMap();
        for (Map.Entry entry : nestedDDMFormFieldValuesMap.entrySet()) {
            List ddmFormFieldValues = (List)entry.getValue();
            this._addDDMFormFieldValues(t, (String)entry.getKey(), ddmFormFieldValues, classTypeValues, locale);
        }
    }

    private Object _sanitizeFieldValue(T t, DDMFormFieldValue ddmFormFieldValue, Locale locale) throws PortalException {
        Value value = ddmFormFieldValue.getValue();
        if (value == null) {
            return "";
        }
        String valueString = value.getString(locale);
        if (Objects.equals(ddmFormFieldValue.getType(), "date") || Objects.equals(ddmFormFieldValue.getType(), "ddm-date")) {
            try {
                DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
                Date date = DateUtil.parseDate((String)"yyyy-MM-dd", (String)valueString, (Locale)locale);
                return dateFormat.format(date);
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                return valueString;
            }
        }
        if (Objects.equals(ddmFormFieldValue.getType(), "ddm-decimal") || Objects.equals(ddmFormFieldValue.getType(), "numeric")) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
            return numberFormat.format(GetterUtil.getDouble((String)valueString));
        }
        if (Objects.equals(ddmFormFieldValue.getType(), "ddm-image") || Objects.equals(ddmFormFieldValue.getType(), "image")) {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(valueString);
            jsonObject.put("url", this._transformFileEntryURL(valueString));
            return jsonObject;
        }
        return SanitizerUtil.sanitize((long)t.getCompanyId(), (long)t.getGroupId(), (long)t.getUserId(), (String)t.getModelClassName(), (long)((Long)t.getPrimaryKeyObj()), (String)"text/html", (String)"ALL", (String)valueString, null);
    }

    private String _transformFileEntryURL(String data) {
        try {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(data);
            String uuid = jsonObject.getString("uuid");
            long groupId = jsonObject.getLong("groupId");
            if (Validator.isNull((String)uuid) && groupId == 0L) {
                return "";
            }
            FileEntry fileEntry = this._dlAppService.getFileEntryByUuidAndGroupId(uuid, groupId);
            return this._dlURLHelper.getDownloadURL(fileEntry, fileEntry.getFileVersion(), null, "");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return "";
        }
    }
}

