/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v5_1_5;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Objects;

public class DDMStructureLayoutUpgradeProcess
extends UpgradeProcess {
    private final JSONFactory _jsonFactory;

    public DDMStructureLayoutUpgradeProcess(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMStructureLayout.structureLayoutId, ", "DDMStructureLayout.definition from DDMStructureLayout ", "inner join DDMStructureVersion on ", "DDMStructureLayout.structureVersionId = ", "DDMStructureVersion.structureVersionId inner join ", "DDMStructure on DDMStructure.structureId = ", "DDMStructureVersion.structureId where ", "DDMStructure.classNameId = ?"}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureLayout set definition = ? where structureLayoutId = ?");){
            preparedStatement1.setLong(1, PortalUtil.getClassNameId((String)DDMFormInstance.class.getName()));
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    JSONObject jsonObject = this._jsonFactory.createJSONObject(resultSet.getString("definition"));
                    if (!Objects.equals(jsonObject.getString("paginationMode"), "paginated")) continue;
                    jsonObject.put("paginationMode", "multi-pages");
                    preparedStatement2.setString(1, jsonObject.toString());
                    preparedStatement2.setLong(2, resultSet.getLong("structureLayoutId"));
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
        }
    }
}

