/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.security.permission.support;

import com.liferay.dynamic.data.mapping.internal.security.permission.support.DDMPermissionSupportTracker;
import com.liferay.dynamic.data.mapping.internal.security.permission.support.helper.DDMPermissionSupportHelper;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.security.permission.DDMPermissionSupport;
import com.liferay.dynamic.data.mapping.util.DDMStructurePermissionSupport;
import com.liferay.dynamic.data.mapping.util.DDMTemplatePermissionSupport;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDMPermissionSupport.class})
public class DDMPermissionSupportImpl
implements DDMPermissionSupport {
    @Reference
    private DDMPermissionSupportHelper _ddmPermissionSupportHelper;
    @Reference
    private DDMPermissionSupportTracker _ddmPermissionSupportTracker;
    @Reference
    private Portal _portal;

    public void checkAddStructurePermission(PermissionChecker permissionChecker, long groupId, long classNameId) throws PortalException {
        if (!this.containsAddStructurePermission(permissionChecker, groupId, classNameId)) {
            ServiceTrackerCustomizerFactory.ServiceWrapper<DDMStructurePermissionSupport> structurePermissionSupportServiceWrapper = this._ddmPermissionSupportTracker.getDDMStructurePermissionSupportServiceWrapper(classNameId);
            throw new PrincipalException.MustHavePermission(permissionChecker, this.getResourceName(structurePermissionSupportServiceWrapper), groupId, new String[]{this._getAddStructureActionId(structurePermissionSupportServiceWrapper)});
        }
    }

    public void checkAddTemplatePermission(PermissionChecker permissionChecker, long groupId, long classNameId, long resourceClassNameId) throws PortalException {
        ServiceTrackerCustomizerFactory.ServiceWrapper<DDMTemplatePermissionSupport> templatePermissionSupportServiceWrapper = this._ddmPermissionSupportTracker.getDDMTemplatePermissionSupportServiceWrapper(resourceClassNameId);
        this._checkAddTemplatePermission(permissionChecker, groupId, classNameId, templatePermissionSupportServiceWrapper);
    }

    public void checkAddTemplatePermission(PermissionChecker permissionChecker, long groupId, long classNameId, String resourceClassName) throws PortalException {
        ServiceTrackerCustomizerFactory.ServiceWrapper<DDMTemplatePermissionSupport> templatePermissionSupportServiceWrapper = this._ddmPermissionSupportTracker.getDDMTemplatePermissionSupportServiceWrapper(resourceClassName);
        this._checkAddTemplatePermission(permissionChecker, groupId, classNameId, templatePermissionSupportServiceWrapper);
    }

    public boolean containsAddStructurePermission(PermissionChecker permissionChecker, long groupId, long classNameId) throws PortalException {
        ServiceTrackerCustomizerFactory.ServiceWrapper<DDMStructurePermissionSupport> structurePermissionSupportServiceWrapper = this._ddmPermissionSupportTracker.getDDMStructurePermissionSupportServiceWrapper(classNameId);
        return this._ddmPermissionSupportHelper.contains(permissionChecker, this.getResourceName(structurePermissionSupportServiceWrapper), groupId, this._getAddStructureActionId(structurePermissionSupportServiceWrapper));
    }

    public boolean containsAddTemplatePermission(PermissionChecker permissionChecker, long groupId, long classNameId, long resourceClassNameId) throws PortalException {
        ServiceTrackerCustomizerFactory.ServiceWrapper<DDMTemplatePermissionSupport> templatePermissionSupportServiceWrapper = this._ddmPermissionSupportTracker.getDDMTemplatePermissionSupportServiceWrapper(resourceClassNameId);
        return this._containsAddTemplatePermission(permissionChecker, groupId, classNameId, templatePermissionSupportServiceWrapper);
    }

    public boolean containsAddTemplatePermission(PermissionChecker permissionChecker, long groupId, long classNameId, String resourceClassName) throws PortalException {
        ServiceTrackerCustomizerFactory.ServiceWrapper<DDMTemplatePermissionSupport> templatePermissionSupportServiceWrapper = this._ddmPermissionSupportTracker.getDDMTemplatePermissionSupportServiceWrapper(resourceClassName);
        return this._containsAddTemplatePermission(permissionChecker, groupId, classNameId, templatePermissionSupportServiceWrapper);
    }

    public String getStructureModelResourceName(long classNameId) throws PortalException {
        return this.getStructureModelResourceName(this._portal.getClassName(classNameId));
    }

    public String getStructureModelResourceName(String className) throws PortalException {
        ServiceTrackerCustomizerFactory.ServiceWrapper<DDMStructurePermissionSupport> structurePermissionSupportServiceWrapper = this._ddmPermissionSupportTracker.getDDMStructurePermissionSupportServiceWrapper(className);
        if (structurePermissionSupportServiceWrapper == null) {
            return ResourceActionsUtil.getCompositeModelName((String[])new String[]{className, DDMStructure.class.getName()});
        }
        boolean defaultModelResourceName = MapUtil.getBoolean((Map)structurePermissionSupportServiceWrapper.getProperties(), (String)"default.model.resource.name");
        if (defaultModelResourceName) {
            return DDMStructure.class.getName();
        }
        return ResourceActionsUtil.getCompositeModelName((String[])new String[]{className, DDMStructure.class.getName()});
    }

    public String getTemplateModelResourceName(long resourceClassNameId) throws PortalException {
        String resourceClassName = this._portal.getClassName(resourceClassNameId);
        return this.getTemplateModelResourceName(resourceClassName);
    }

    public String getTemplateModelResourceName(String resourceClassName) throws PortalException {
        ServiceTrackerCustomizerFactory.ServiceWrapper<DDMTemplatePermissionSupport> templatePermissionSupportServiceWrapper = this._ddmPermissionSupportTracker.getDDMTemplatePermissionSupportServiceWrapper(resourceClassName);
        return this._getTemplateModelResourceName(resourceClassName, templatePermissionSupportServiceWrapper);
    }

    protected String getResourceName(ServiceTrackerCustomizerFactory.ServiceWrapper<DDMStructurePermissionSupport> structurePermissionSupportServiceWrapper) {
        DDMStructurePermissionSupport structurePermissionSupport = (DDMStructurePermissionSupport)structurePermissionSupportServiceWrapper.getService();
        return structurePermissionSupport.getResourceName();
    }

    protected String getResourceName(ServiceTrackerCustomizerFactory.ServiceWrapper<DDMTemplatePermissionSupport> templatePermissionSupportServiceWrapper, long classNameId) {
        DDMTemplatePermissionSupport templatePermissionSupport = (DDMTemplatePermissionSupport)templatePermissionSupportServiceWrapper.getService();
        return templatePermissionSupport.getResourceName(classNameId);
    }

    private void _checkAddTemplatePermission(PermissionChecker permissionChecker, long groupId, long classNameId, ServiceTrackerCustomizerFactory.ServiceWrapper<DDMTemplatePermissionSupport> templatePermissionSupportServiceWrapper) throws PortalException {
        if (!this._containsAddTemplatePermission(permissionChecker, groupId, classNameId, templatePermissionSupportServiceWrapper)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, this.getResourceName(templatePermissionSupportServiceWrapper, classNameId), groupId, new String[]{this._getAddTemplateActionId(templatePermissionSupportServiceWrapper)});
        }
    }

    private boolean _containsAddTemplatePermission(PermissionChecker permissionChecker, long groupId, long classNameId, ServiceTrackerCustomizerFactory.ServiceWrapper<DDMTemplatePermissionSupport> templatePermissionSupportServiceWrapper) throws PortalException {
        String resourceName = this.getResourceName(templatePermissionSupportServiceWrapper, classNameId);
        List portletNames = ResourceActionsUtil.getPortletNames();
        if (portletNames.contains(resourceName)) {
            return PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, null, (String)resourceName, (String)this._getAddTemplateActionId(templatePermissionSupportServiceWrapper));
        }
        return this._ddmPermissionSupportHelper.contains(permissionChecker, resourceName, groupId, this._getAddTemplateActionId(templatePermissionSupportServiceWrapper));
    }

    private String _getAddStructureActionId(ServiceTrackerCustomizerFactory.ServiceWrapper<DDMStructurePermissionSupport> structurePermissionSupportServiceWrapper) {
        return MapUtil.getString((Map)structurePermissionSupportServiceWrapper.getProperties(), (String)"add.structure.action.id", (String)"ADD_STRUCTURE");
    }

    private String _getAddTemplateActionId(ServiceTrackerCustomizerFactory.ServiceWrapper<DDMTemplatePermissionSupport> templatePermissionSupportServiceWrapper) {
        return MapUtil.getString((Map)templatePermissionSupportServiceWrapper.getProperties(), (String)"add.template.action.id", (String)"ADD_TEMPLATE");
    }

    private String _getTemplateModelResourceName(String resourceClassName, ServiceTrackerCustomizerFactory.ServiceWrapper<DDMTemplatePermissionSupport> templatePermissionSupportServiceWrapper) throws PortalException {
        boolean defaultModelResourceName = MapUtil.getBoolean((Map)templatePermissionSupportServiceWrapper.getProperties(), (String)"default.model.resource.name");
        if (defaultModelResourceName) {
            return DDMTemplate.class.getName();
        }
        return ResourceActionsUtil.getCompositeModelName((String[])new String[]{resourceClassName, DDMTemplate.class.getName()});
    }
}

