/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.notification;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueRenderer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceSettings;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HtmlParser;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PrefsPropsUtil;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Function;
import javax.mail.internet.InternetAddress;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDMFormEmailNotificationSender.class})
public class DDMFormEmailNotificationSender {
    private static final String _TEMPLATE_PATH = "/META-INF/resources/notification/form_entry_add_body.ftl";
    private static final Log _log = LogFactoryUtil.getLog(DDMFormEmailNotificationSender.class);
    @Reference
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private HtmlParser _htmlParser;
    @Reference
    private Language _language;
    @Reference
    private MailService _mailService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public void sendEmailNotification(DDMFormInstanceRecord ddmFormInstanceRecord, ServiceContext serviceContext) {
        try {
            MailMessage mailMessage = this._createMailMessage(ddmFormInstanceRecord, serviceContext);
            this._mailService.sendEmail(mailMessage);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to send form email", (Throwable)exception);
        }
    }

    protected Map<String, List<DDMFormFieldValue>> getDDMFormFieldValuesMap(DDMFormInstanceRecord ddmFormInstanceRecord) throws PortalException {
        DDMFormValues ddmFormValues = ddmFormInstanceRecord.getDDMFormValues();
        return ddmFormValues.getDDMFormFieldValuesMap(true);
    }

    protected Map<String, Object> getFieldProperties(List<DDMFormFieldValue> ddmFormFieldValues, final Locale locale) {
        DDMFormField ddmFormField = this._getDDMFormField(ddmFormFieldValues);
        if (Objects.equals(ddmFormField.getType(), "fieldset")) {
            return null;
        }
        if (Objects.equals(ddmFormField.getType(), "paragraph")) {
            return HashMapBuilder.put((Object)"label", (Object)this._getLabel(ddmFormField, locale)).put((Object)"value", (Object)this._getParagraphText(ddmFormField, locale)).build();
        }
        List renderedDDMFormFieldValues = ListUtil.toList(ddmFormFieldValues, (Function)new Function<DDMFormFieldValue, String>(){

            @Override
            public String apply(DDMFormFieldValue ddmFormFieldValue) {
                return DDMFormEmailNotificationSender.this._renderDDMFormFieldValue(ddmFormFieldValue, locale);
            }
        });
        return HashMapBuilder.put((Object)"label", (Object)this._getLabel(ddmFormField, locale)).put((Object)"value", (Object)StringUtil.merge((Collection)renderedDDMFormFieldValues, (String)", ")).build();
    }

    protected List<Object> getFields(List<String> fieldNames, Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap, Locale locale) {
        ArrayList<Object> fields = new ArrayList<Object>();
        for (String fieldName : fieldNames) {
            List<DDMFormFieldValue> ddmFormFieldValues = ddmFormFieldValuesMap.get(fieldName);
            if (ddmFormFieldValues == null) continue;
            fields.add(this.getFieldProperties(ddmFormFieldValues, locale));
            fields.addAll(this._getNestedFields(ddmFormFieldValues, ddmFormFieldValuesMap, locale));
        }
        return fields;
    }

    private MailMessage _createMailMessage(DDMFormInstanceRecord ddmFormInstanceRecord, ServiceContext serviceContext) throws Exception {
        DDMFormInstance ddmFormInstance = ddmFormInstanceRecord.getFormInstance();
        InternetAddress fromInternetAddress = new InternetAddress(this._getEmailFromAddress(ddmFormInstance), this._getEmailFromName(ddmFormInstance));
        String subject = this._getEmailSubject(ddmFormInstance);
        String body = this._getEmailBody(serviceContext, ddmFormInstance, ddmFormInstanceRecord);
        MailMessage mailMessage = new MailMessage(fromInternetAddress, subject, body, true);
        InternetAddress[] toAddresses = InternetAddress.parse((String)this._getEmailToAddress(ddmFormInstance));
        mailMessage.setTo(toAddresses);
        return mailMessage;
    }

    private Template _createTemplate(ServiceContext serviceContext, DDMFormInstance ddmFormInstance, DDMFormInstanceRecord ddmFormInstanceRecord) throws Exception {
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)this._getTemplateResource(_TEMPLATE_PATH), (boolean)false);
        this._populateParameters(template, serviceContext, ddmFormInstance, ddmFormInstanceRecord);
        return template;
    }

    private DDMFormField _getDDMFormField(List<DDMFormFieldValue> ddmFormFieldValues) {
        DDMFormFieldValue ddmFormFieldValue = ddmFormFieldValues.get(0);
        return ddmFormFieldValue.getDDMFormField();
    }

    private DDMFormLayout _getDDMFormLayout(DDMFormInstance ddmFormInstance) throws Exception {
        DDMStructure ddmStructure = ddmFormInstance.getStructure();
        return ddmStructure.getDDMFormLayout();
    }

    private String _getEmailBody(ServiceContext serviceContext, DDMFormInstance ddmFormInstance, DDMFormInstanceRecord ddmFormInstanceRecord) throws Exception {
        Template template = this._createTemplate(serviceContext, ddmFormInstance, ddmFormInstanceRecord);
        return this._render(template);
    }

    private String _getEmailFromAddress(DDMFormInstance ddmFormInstance) throws Exception {
        DDMFormInstanceSettings formInstancetings = ddmFormInstance.getSettingsModel();
        String defaultEmailFromAddress = PrefsPropsUtil.getString((long)ddmFormInstance.getCompanyId(), (String)"admin.email.from.address");
        return GetterUtil.getString((String)formInstancetings.emailFromAddress(), (String)defaultEmailFromAddress);
    }

    private String _getEmailFromName(DDMFormInstance ddmFormInstance) throws Exception {
        DDMFormInstanceSettings formInstancetings = ddmFormInstance.getSettingsModel();
        String defaultEmailFromName = PrefsPropsUtil.getString((long)ddmFormInstance.getCompanyId(), (String)"admin.email.from.name");
        return GetterUtil.getString((String)formInstancetings.emailFromName(), (String)defaultEmailFromName);
    }

    private String _getEmailSubject(DDMFormInstance ddmFormInstance) throws Exception {
        DDMFormInstanceSettings formInstancetings = ddmFormInstance.getSettingsModel();
        DDMStructure ddmStructure = ddmFormInstance.getStructure();
        DDMForm ddmForm = ddmStructure.getDDMForm();
        Locale locale = ddmForm.getDefaultLocale();
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        String defaultEmailSubject = this._language.format(resourceBundle, "new-x-form-submitted", (Object)ddmFormInstance.getName(locale), false);
        return GetterUtil.getString((String)formInstancetings.emailSubject(), (String)defaultEmailSubject);
    }

    private String _getEmailToAddress(DDMFormInstance ddmFormInstance) throws Exception {
        String defaultEmailToAddress = "";
        DDMFormInstanceSettings formInstancetings = ddmFormInstance.getSettingsModel();
        User user = this._userLocalService.fetchUser(ddmFormInstance.getUserId());
        if (user != null) {
            defaultEmailToAddress = user.getEmailAddress();
        }
        return GetterUtil.getString((String)formInstancetings.emailToAddress(), (String)defaultEmailToAddress);
    }

    private List<String> _getFieldNames(DDMFormLayoutPage ddmFormLayoutPage) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (DDMFormLayoutRow ddmFormLayoutRow : ddmFormLayoutPage.getDDMFormLayoutRows()) {
            for (DDMFormLayoutColumn ddmFormLayoutColumn : ddmFormLayoutRow.getDDMFormLayoutColumns()) {
                fieldNames.addAll(ddmFormLayoutColumn.getDDMFormFieldNames());
            }
        }
        return fieldNames;
    }

    private String _getLabel(DDMFormField ddmFormField, Locale locale) {
        LocalizedValue label = ddmFormField.getLabel();
        if (ddmFormField.isRequired()) {
            return label.getString(locale) + "*";
        }
        return label.getString(locale);
    }

    private Locale _getLocale(DDMFormInstance ddmFormInstance, ServiceContext serviceContext) throws Exception {
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        String languageId = GetterUtil.getString((String)httpServletRequest.getParameter("languageId"), (String)ddmFormInstance.getDefaultLanguageId());
        return LocaleUtil.fromLanguageId((String)languageId);
    }

    private List<Map<String, Object>> _getNestedFields(List<DDMFormFieldValue> ddmFormFieldValues, Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap, Locale locale) {
        ArrayList<Map<String, Object>> nestedFields = new ArrayList<Map<String, Object>>();
        DDMFormField ddmFormField = this._getDDMFormField(ddmFormFieldValues);
        Map nestedDDMFormFieldsMap = ddmFormField.getNestedDDMFormFieldsMap();
        for (String key : nestedDDMFormFieldsMap.keySet()) {
            nestedFields.add(this.getFieldProperties(ddmFormFieldValuesMap.get(key), locale));
        }
        return nestedFields;
    }

    private Map<String, Object> _getPage(DDMFormLayoutPage ddmFormLayoutPage, Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap, Locale locale) {
        return HashMapBuilder.put((Object)"fields", this.getFields(this._getFieldNames(ddmFormLayoutPage), ddmFormFieldValuesMap, locale)).put((Object)"title", () -> {
            LocalizedValue title = ddmFormLayoutPage.getTitle();
            return title.getString(locale);
        }).build();
    }

    private List<Object> _getPages(DDMFormInstance ddmFormInstance, DDMFormInstanceRecord ddmFormInstanceRecord, Locale locale) throws Exception {
        ArrayList<Object> pages = new ArrayList<Object>();
        DDMFormLayout ddmFormLayout = this._getDDMFormLayout(ddmFormInstance);
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayout.getDDMFormLayoutPages()) {
            pages.add(this._getPage(ddmFormLayoutPage, this.getDDMFormFieldValuesMap(ddmFormInstanceRecord), locale));
        }
        return pages;
    }

    private String _getParagraphText(DDMFormField ddmFormField, Locale locale) {
        LocalizedValue text = (LocalizedValue)ddmFormField.getProperty("text");
        if (text == null) {
            return "";
        }
        return this._htmlParser.extractText(text.getString(locale));
    }

    private ResourceBundle _getResourceBundle(Locale locale) {
        return ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
    }

    private String _getSiteName(long groupId, Locale locale) throws Exception {
        Group siteGroup = this._groupLocalService.fetchGroup(groupId);
        if (siteGroup != null) {
            return siteGroup.getDescriptiveName(locale);
        }
        return "";
    }

    private TemplateResource _getTemplateResource(String templatePath) {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        URL templateURL = classLoader.getResource(templatePath);
        return new URLTemplateResource(templateURL.getPath(), templateURL);
    }

    private String _getUserName(DDMFormInstanceRecord ddmFormInstanceRecord, Locale locale) {
        String userName = ddmFormInstanceRecord.getUserName();
        if (Validator.isNotNull((String)userName)) {
            return userName;
        }
        return this._language.get(this._getResourceBundle(locale), "someone");
    }

    private String _getViewFormEntriesURL(ServiceContext serviceContext, DDMFormInstance ddmFormInstance) throws Exception {
        String portletNamespace = this._portal.getPortletNamespace("com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormAdminPortlet");
        return this._portal.getSiteAdminURL(serviceContext.getPortalURL(), this._groupLocalService.getGroup(ddmFormInstance.getGroupId()), "com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormAdminPortlet", (Map)HashMapBuilder.put((Object)portletNamespace.concat("mvcPath"), (Object)new String[]{"/admin/view_form_instance_records.jsp"}).put((Object)portletNamespace.concat("formInstanceId"), (Object)new String[]{String.valueOf(ddmFormInstance.getFormInstanceId())}).build());
    }

    private String _getViewFormURL(ServiceContext serviceContext, DDMFormInstance ddmFormInstance, DDMFormInstanceRecord ddmFormInstanceRecord) throws Exception {
        String portletNamespace = this._portal.getPortletNamespace("com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormAdminPortlet");
        return this._portal.getSiteAdminURL(serviceContext.getPortalURL(), this._groupLocalService.getGroup(ddmFormInstance.getGroupId()), "com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormAdminPortlet", (Map)HashMapBuilder.put((Object)portletNamespace.concat("mvcPath"), (Object)new String[]{"/admin/view_form_instance_record.jsp"}).put((Object)portletNamespace.concat("formInstanceRecordId"), (Object)new String[]{String.valueOf(ddmFormInstanceRecord.getFormInstanceRecordId())}).put((Object)portletNamespace.concat("formInstanceId"), (Object)new String[]{String.valueOf(ddmFormInstance.getFormInstanceId())}).build());
    }

    private void _populateParameters(Template template, ServiceContext serviceContext, DDMFormInstance ddmFormInstance, DDMFormInstanceRecord ddmFormInstanceRecord) throws Exception {
        Locale locale = this._getLocale(ddmFormInstance, serviceContext);
        template.put((Object)"formName", (Object)ddmFormInstance.getName(locale));
        template.put((Object)"pages", this._getPages(ddmFormInstance, ddmFormInstanceRecord, locale));
        template.put((Object)"siteName", (Object)this._getSiteName(ddmFormInstance.getGroupId(), locale));
        template.put((Object)"userName", (Object)this._getUserName(ddmFormInstanceRecord, locale));
        template.put((Object)"viewFormEntriesURL", (Object)this._getViewFormEntriesURL(serviceContext, ddmFormInstance));
        template.put((Object)"viewFormURL", (Object)this._getViewFormURL(serviceContext, ddmFormInstance, ddmFormInstanceRecord));
    }

    private String _render(Template template) throws Exception {
        UnsyncStringWriter writer = new UnsyncStringWriter();
        template.processTemplate((Writer)writer);
        return writer.toString();
    }

    private String _renderDDMFormFieldValue(DDMFormFieldValue ddmFormFieldValue, Locale locale) {
        if (ddmFormFieldValue.getValue() == null) {
            return "";
        }
        DDMFormFieldValueRenderer ddmFormFieldValueRenderer = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldValueRenderer(ddmFormFieldValue.getType());
        return ddmFormFieldValueRenderer.render(ddmFormFieldValue, locale);
    }
}

