/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.messaging;

import com.liferay.dynamic.data.mapping.internal.background.task.DDMStructureIndexerTracker;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.search.DDMStructureIndexer;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"destination.name=liferay/ddm_structure_reindex"}, service={MessageListener.class})
public class DDMStructureReindexMessageListener
extends BaseMessageListener {
    @Reference
    private DDMStructureIndexerTracker _ddmStructureIndexerTracker;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;

    protected void doReceive(Message message) throws Exception {
        long structureId = message.getLong("structureId");
        DDMStructure structure = this._ddmStructureLocalService.getStructure(structureId);
        DDMStructureIndexer structureIndexer = this._ddmStructureIndexerTracker.getDDMStructureIndexer(structure.getClassName());
        ArrayList<Long> ddmStructureIds = new ArrayList<Long>();
        ddmStructureIds.add(structureId);
        this._collectChildrenStructureIds(ddmStructureIds, structureId);
        structureIndexer.reindexDDMStructures(ddmStructureIds);
    }

    private void _collectChildrenStructureIds(List<Long> structureIds, long parentStructureId) {
        List structures = this._ddmStructureLocalService.getChildrenStructures(parentStructureId);
        for (DDMStructure structure : structures) {
            structureIds.add(structure.getStructureId());
            this._collectChildrenStructureIds(structureIds, structure.getStructureId());
        }
    }
}

