/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.storage.constants.FieldConstants;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesConverterUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={DDMFormValuesToFieldsConverter.class})
public class DDMFormValuesToFieldsConverterImpl
implements DDMFormValuesToFieldsConverter {
    public Fields convert(DDMStructure ddmStructure, DDMFormValues ddmFormValues) throws PortalException {
        DDMForm ddmForm = ddmStructure.getDDMForm();
        ddmFormValues.setDDMFormFieldValues(DDMFormValuesConverterUtil.addMissingDDMFormFieldValues((Collection)ddmForm.getDDMFormFields(), (Map)ddmFormValues.getDDMFormFieldValuesMap(true)));
        Map ddmFormFieldsMap = ddmStructure.getFullHierarchyDDMFormFieldsMap(true);
        Fields ddmFields = this._createDDMFields(ddmStructure);
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormValues.getDDMFormFieldValues()) {
            this._addDDMFields(ddmStructure.getStructureId(), ddmFormFieldsMap, ddmFormFieldValue, ddmFields, ddmFormValues.getDefaultLocale());
        }
        return ddmFields;
    }

    private void _addDDMField(long ddmStructureId, DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue, Fields ddmFields, Locale defaultLocale) throws PortalException {
        if (ddmFormField == null || ddmFormField.isTransient() || ddmFormFieldValue.getValue() == null) {
            return;
        }
        Field ddmField = this._createDDMField(ddmStructureId, ddmFormField, ddmFormFieldValue, defaultLocale);
        Field existingDDMField = ddmFields.get(ddmField.getName());
        if (existingDDMField == null) {
            ddmFields.put(ddmField);
        } else {
            this._addDDMFieldValues(existingDDMField, ddmField);
        }
    }

    private void _addDDMFields(long ddmStructureId, Map<String, DDMFormField> ddmFormFieldsMap, DDMFormFieldValue ddmFormFieldValue, Fields ddmFields, Locale defaultLocale) throws PortalException {
        DDMFormField ddmFormField = ddmFormFieldsMap.get(ddmFormFieldValue.getName());
        this._addDDMField(ddmStructureId, ddmFormField, ddmFormFieldValue, ddmFields, defaultLocale);
        this._addFieldDisplayValue(ddmFields.get("_fieldsDisplay"), this._getFieldDisplayValue(ddmFormFieldValue));
        for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
            this._addDDMFields(ddmStructureId, ddmFormFieldsMap, nestedDDMFormFieldValue, ddmFields, defaultLocale);
        }
    }

    private void _addDDMFieldValues(Field existingDDMField, Field newDDMField) {
        for (Locale availableLocale : newDDMField.getAvailableLocales()) {
            existingDDMField.addValues(availableLocale, newDDMField.getValues(availableLocale));
        }
    }

    private void _addFieldDisplayValue(Field ddmFieldsDisplayField, String fieldDisplayValue) {
        Object[] fieldsDisplayValues = StringUtil.split((String)((String)((Object)ddmFieldsDisplayField.getValue())));
        fieldsDisplayValues = (String[])ArrayUtil.append((Object[])fieldsDisplayValues, (Object)fieldDisplayValue);
        ddmFieldsDisplayField.setValue((Serializable)((Object)StringUtil.merge((Object[])fieldsDisplayValues)));
    }

    private Field _createDDMField(long ddmStructureId, DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue, Locale defaultLocale) throws PortalException {
        Field ddmField = new Field();
        ddmField.setDDMStructureId(ddmStructureId);
        ddmField.setDefaultLocale(defaultLocale);
        ddmField.setName(ddmFormFieldValue.getName());
        String type = ddmFormField.getDataType();
        this._setDDMFieldValue(ddmField, type, ddmFormFieldValue.getValue(), defaultLocale);
        return ddmField;
    }

    private Fields _createDDMFields(DDMStructure ddmStructure) {
        Fields ddmFields = new Fields();
        Field fieldsDisplayField = new Field(ddmStructure.getStructureId(), "_fieldsDisplay", (Serializable)((Object)""));
        ddmFields.put(fieldsDisplayField);
        return ddmFields;
    }

    private String _getFieldDisplayValue(DDMFormFieldValue ddmFormFieldValue) {
        String fieldName = ddmFormFieldValue.getName();
        return StringBundler.concat((String[])new String[]{fieldName, "_INSTANCE_", ddmFormFieldValue.getInstanceId()});
    }

    private void _setDDMFieldLocalizedValue(Field ddmField, String type, Value value) {
        for (Locale availableLocale : value.getAvailableLocales()) {
            Serializable serializable = FieldConstants.getSerializable((Locale)availableLocale, (Locale)availableLocale, (String)type, (String)value.getString(availableLocale));
            ddmField.addValue(availableLocale, serializable);
        }
    }

    private void _setDDMFieldUnlocalizedValue(Field ddmField, String type, Value value, Locale defaultLocale) {
        Serializable serializable = FieldConstants.getSerializable((Locale)defaultLocale, (Locale)LocaleUtil.ROOT, (String)type, (String)value.getString(LocaleUtil.ROOT));
        ddmField.addValue(defaultLocale, serializable);
    }

    private void _setDDMFieldValue(Field ddmField, String type, Value value, Locale defaultLocale) {
        if (value.isLocalized()) {
            this._setDDMFieldLocalizedValue(ddmField, type, value);
        } else {
            this._setDDMFieldUnlocalizedValue(ddmField, type, value, defaultLocale);
        }
    }
}

