/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.portal.kernel.editor.Editor;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={DDMFormFieldFreeMarkerRendererUtil.class})
public class DDMFormFieldFreeMarkerRendererUtil {
    private static final String _EDITOR_WYSIWYG_DEFAULT = PropsUtil.get((String)"editor.wysiwyg.default");
    private static final String _TEXT_HTML_EDITOR_WYSIWYG_DEFAULT = PropsUtil.get((String)"editor.wysiwyg.portal-impl.portlet.ddm.text_html.ftl");
    private static final Map<String, Editor> _editors = new ConcurrentHashMap<String, Editor>();

    public static Editor getEditor(HttpServletRequest httpServletRequest) {
        if (Validator.isNull((String)_TEXT_HTML_EDITOR_WYSIWYG_DEFAULT) || !_editors.containsKey(_TEXT_HTML_EDITOR_WYSIWYG_DEFAULT)) {
            return _editors.get(_EDITOR_WYSIWYG_DEFAULT);
        }
        return _editors.get(_TEXT_HTML_EDITOR_WYSIWYG_DEFAULT);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addEditor(Editor editor) {
        _editors.put(editor.getName(), editor);
    }

    protected void removeEditor(Editor editor) {
        _editors.remove(editor.getName());
    }
}

