/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.template;

import com.liferay.dynamic.data.mapping.internal.util.ResourceBundleLoaderProvider;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.resource.bundle.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ClassResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.template.TemplateHandlerRegistry;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.language.LanguageResources;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={TemplateHandlerRegistry.class})
public class TemplateHandlerRegistryImpl
implements TemplateHandlerRegistry {
    @Reference
    protected ResourceBundleLoaderProvider resourceBundleLoaderProvider;
    private static final ThreadLocal<Map<Long, Map<String, DDMTemplate>>> _ddmTemplateMapsThreadLocal = new CentralizedThreadLocal(TemplateHandlerRegistryImpl.class.getName() + "._ddmTemplateMapsThreadLocal");
    private BundleContext _bundleContext;
    private ServiceTrackerMap<Long, TemplateHandler> _classNameIdTemplateHandlersServiceTrackerMap;
    private ServiceTrackerMap<String, TemplateHandler> _classNameTemplateHandlersServiceTrackerMap;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    private Portal _portal;
    private final Map<TemplateHandler, ServiceRegistration<?>> _serviceRegistrations = new ConcurrentHashMap();
    private UserLocalService _userLocalService;

    public long[] getClassNameIds() {
        return ArrayUtil.toLongArray((Collection)this._classNameIdTemplateHandlersServiceTrackerMap.keySet());
    }

    public TemplateHandler getTemplateHandler(long classNameId) {
        return (TemplateHandler)this._classNameIdTemplateHandlersServiceTrackerMap.getService((Object)classNameId);
    }

    public TemplateHandler getTemplateHandler(String className) {
        return (TemplateHandler)this._classNameTemplateHandlersServiceTrackerMap.getService((Object)className);
    }

    public List<TemplateHandler> getTemplateHandlers() {
        return new ArrayList<TemplateHandler>(this._classNameTemplateHandlersServiceTrackerMap.values());
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._classNameIdTemplateHandlersServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, TemplateHandler.class, null, (serviceReference, emitter) -> {
            TemplateHandler templateHandler = (TemplateHandler)bundleContext.getService(serviceReference);
            emitter.emit((Object)this._portal.getClassNameId(templateHandler.getClassName()));
            bundleContext.ungetService(serviceReference);
        });
        _ddmTemplateMapsThreadLocal.set(new HashMap());
        this._classNameTemplateHandlersServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, TemplateHandler.class, null, (serviceReference, emitter) -> {
            TemplateHandler templateHandler = (TemplateHandler)bundleContext.getService(serviceReference);
            emitter.emit((Object)templateHandler.getClassName());
            bundleContext.ungetService(serviceReference);
        }, (ServiceTrackerCustomizer)new TemplateHandlerServiceTrackerCustomizer());
        _ddmTemplateMapsThreadLocal.remove();
    }

    @Deactivate
    protected void deactivate() {
        this._classNameTemplateHandlersServiceTrackerMap.close();
        this._classNameIdTemplateHandlersServiceTrackerMap.close();
        this._bundleContext = null;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.model.DDMTemplate)", unbind="-")
    protected void setModelResourcePermission(ModelResourcePermission<DDMTemplate> modelResourcePermission) {
    }

    @Reference(unbind="-")
    protected void setPortal(Portal portal) {
        this._portal = portal;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    private class TemplateHandlerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<TemplateHandler, TemplateHandler> {
        private TemplateHandlerServiceTrackerCustomizer() {
        }

        public TemplateHandler addingService(ServiceReference<TemplateHandler> serviceReference) {
            TemplateHandler templateHandler = (TemplateHandler)TemplateHandlerRegistryImpl.this._bundleContext.getService(serviceReference);
            int serviceRanking = GetterUtil.getInteger((Object)serviceReference.getProperty("service.ranking"));
            ServiceRegistration serviceRegistration = TemplateHandlerRegistryImpl.this._serviceRegistrations.put(templateHandler, TemplateHandlerRegistryImpl.this._bundleContext.registerService(PortalInstanceLifecycleListener.class, (Object)new TemplateHandlerPortalInstanceLifecycleListener(templateHandler), MapUtil.singletonDictionary((Object)"service.ranking", (Object)serviceRanking)));
            if (serviceRegistration != null) {
                serviceRegistration.unregister();
            }
            return templateHandler;
        }

        public void modifiedService(ServiceReference<TemplateHandler> serviceReference, TemplateHandler templateHandler) {
        }

        public void removedService(ServiceReference<TemplateHandler> serviceReference, TemplateHandler templateHandler) {
            ServiceRegistration serviceRegistration = (ServiceRegistration)TemplateHandlerRegistryImpl.this._serviceRegistrations.remove(templateHandler);
            if (serviceRegistration != null) {
                serviceRegistration.unregister();
            }
            TemplateHandlerRegistryImpl.this._bundleContext.ungetService(serviceReference);
        }
    }

    private class TemplateHandlerPortalInstanceLifecycleListener
    extends BasePortalInstanceLifecycleListener {
        private static final String _CLASS_NAME_PORTLET_DISPLAY_TEMPLATE = "com.liferay.portlet.display.template.PortletDisplayTemplate";
        private final TemplateHandler _templateHandler;

        public void portalInstanceRegistered(Company company) throws Exception {
            long classNameId = TemplateHandlerRegistryImpl.this._portal.getClassNameId(this._templateHandler.getClassName());
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGuestPermissions(true);
            Group group = TemplateHandlerRegistryImpl.this._groupLocalService.getCompanyGroup(company.getCompanyId());
            serviceContext.setScopeGroupId(group.getGroupId());
            long userId = TemplateHandlerRegistryImpl.this._userLocalService.getDefaultUserId(company.getCompanyId());
            serviceContext.setUserId(userId);
            List templateElements = this._templateHandler.getDefaultTemplateElements();
            Map ddmTemplateMaps = (Map)_ddmTemplateMapsThreadLocal.get();
            Map ddmTemplateMap = null;
            if (ddmTemplateMaps != null) {
                ddmTemplateMap = ddmTemplateMaps.computeIfAbsent(group.getGroupId(), groupId -> {
                    HashMap<String, DDMTemplate> ddmTemplates = new HashMap<String, DDMTemplate>();
                    for (DDMTemplate ddmTemplate : TemplateHandlerRegistryImpl.this._ddmTemplateLocalService.getTemplatesByGroupId(groupId.longValue())) {
                        ddmTemplates.put(StringBundler.concat((Object[])new Object[]{ddmTemplate.getClassNameId(), "#", StringUtil.toUpperCase((String)ddmTemplate.getTemplateKey())}), ddmTemplate);
                    }
                    return ddmTemplates;
                });
            }
            for (Element templateElement : templateElements) {
                String templateKey = templateElement.elementText("template-key");
                DDMTemplate ddmTemplate = null;
                if (ddmTemplateMap != null) {
                    ddmTemplate = (DDMTemplate)ddmTemplateMap.get(StringBundler.concat((Object[])new Object[]{classNameId, "#", StringUtil.toUpperCase((String)templateKey)}));
                }
                if (ddmTemplate == null) {
                    ddmTemplate = TemplateHandlerRegistryImpl.this._ddmTemplateLocalService.fetchTemplate(group.getGroupId(), classNameId, templateKey);
                }
                if (ddmTemplate != null && (ddmTemplate.getUserId() != userId || ddmTemplate.getVersionUserId() != userId)) continue;
                Class<?> clazz = this._templateHandler.getClass();
                String scriptFileName = templateElement.elementText("script-file");
                String script = StringUtil.read((ClassLoader)clazz.getClassLoader(), (String)scriptFileName);
                if (ddmTemplate != null && StringUtil.equals((String)script, (String)ddmTemplate.getScript())) continue;
                Object resourceBundleLoader = null;
                Bundle bundle = FrameworkUtil.getBundle(clazz);
                resourceBundleLoader = bundle != null ? TemplateHandlerRegistryImpl.this.resourceBundleLoaderProvider.getResourceBundleLoader(bundle.getSymbolicName()) : new AggregateResourceBundleLoader(new ResourceBundleLoader[]{new ClassResourceBundleLoader("content.Language", clazz.getClassLoader()), LanguageResources.PORTAL_RESOURCE_BUNDLE_LOADER});
                Map<Locale, String> nameMap = this.getLocalizationMap((ResourceBundleLoader)resourceBundleLoader, group.getGroupId(), templateElement.elementText("name"));
                Map<Locale, String> descriptionMap = this.getLocalizationMap((ResourceBundleLoader)resourceBundleLoader, group.getGroupId(), templateElement.elementText("description"));
                String type = templateElement.elementText("type");
                if (type == null) {
                    type = "display";
                }
                String language = templateElement.elementText("language");
                boolean cacheable = GetterUtil.getBoolean((String)templateElement.elementText("cacheable"));
                if (ddmTemplate == null) {
                    TemplateHandlerRegistryImpl.this._ddmTemplateLocalService.addTemplate(userId, group.getGroupId(), classNameId, 0L, TemplateHandlerRegistryImpl.this._portal.getClassNameId(_CLASS_NAME_PORTLET_DISPLAY_TEMPLATE), templateKey, nameMap, descriptionMap, type, null, language, script, cacheable, false, null, null, serviceContext);
                    continue;
                }
                TemplateHandlerRegistryImpl.this._ddmTemplateLocalService.updateTemplate(userId, ddmTemplate.getTemplateId(), 0L, nameMap, descriptionMap, type, null, language, script, cacheable, false, null, null, serviceContext);
            }
        }

        public void portalInstanceUnregistered(Company company) throws Exception {
        }

        protected Map<Locale, String> getLocalizationMap(ResourceBundleLoader resourceBundleLoader, long groupId, String key) {
            HashMap<Locale, String> map = new HashMap<Locale, String>();
            for (Locale locale : TemplateHandlerRegistryImpl.this._language.getAvailableLocales(groupId)) {
                ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(locale);
                map.put(locale, TemplateHandlerRegistryImpl.this._language.get(resourceBundle, key));
            }
            return map;
        }

        private TemplateHandlerPortalInstanceLifecycleListener(TemplateHandler templateHandler) {
            this._templateHandler = templateHandler;
        }
    }
}

