/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.render;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.internal.render.DDMFormFieldFreeMarkerRenderer;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldRenderer;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldRendererRegistry;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldRendererRegistryUtil;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMFormFieldRendererRegistry.class})
public class DDMFormFieldRendererRegistryImpl
implements DDMFormFieldRendererRegistry {
    private BundleContext _bundleContext;
    private final DDMFormFieldRendererRegistryUtil _ddmFormFieldRendererRegistryUtil = new DDMFormFieldRendererRegistryUtil();
    @Reference
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    private ServiceRegistration<DDMFormFieldRenderer> _serviceRegistration;
    private ServiceTrackerMap<String, DDMFormFieldRenderer> _serviceTrackerMap;

    public DDMFormFieldRenderer getDDMFormFieldRenderer(String ddmFormFieldType) {
        DDMFormFieldRenderer ddmFormFieldRenderer = (DDMFormFieldRenderer)this._serviceTrackerMap.getService((Object)ddmFormFieldType);
        if (ddmFormFieldRenderer != null) {
            return ddmFormFieldRenderer;
        }
        Set ddmFormFieldTypeNames = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldTypeNames();
        if (ddmFormFieldTypeNames.contains(ddmFormFieldType)) {
            return (DDMFormFieldRenderer)this._bundleContext.getService(this._serviceRegistration.getReference());
        }
        return null;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._serviceRegistration = this._bundleContext.registerService(DDMFormFieldRenderer.class, (Object)new DDMFormFieldFreeMarkerRenderer(), null);
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)this._bundleContext, DDMFormFieldRenderer.class, null, (serviceReference, emitter) -> {
            DDMFormFieldRenderer ddmFormFieldRenderer = (DDMFormFieldRenderer)this._bundleContext.getService(serviceReference);
            try {
                for (String supportedDDMFormFieldType : ddmFormFieldRenderer.getSupportedDDMFormFieldTypes()) {
                    emitter.emit((Object)supportedDDMFormFieldType);
                }
            }
            finally {
                this._bundleContext.ungetService(serviceReference);
            }
        });
        DDMFormFieldRendererRegistryUtil ddmFormFieldRendererRegistryUtil = new DDMFormFieldRendererRegistryUtil();
        ddmFormFieldRendererRegistryUtil.setDDMFormFieldRendererRegistry((DDMFormFieldRendererRegistry)this);
    }

    @Deactivate
    protected void deactivate() {
        this._ddmFormFieldRendererRegistryUtil.setDDMFormFieldRendererRegistry(null);
        this._serviceTrackerMap.close();
        this._serviceRegistration.unregister();
    }
}

