/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.model.impl;

/**
 * @author Preson Crary
 */
public class DDMFieldAttributeImpl extends DDMFieldAttributeBaseImpl {

	public static final int SMALL_ATTRIBUTE_VALUE_MAX_LENGTH = 255;

	@Override
	public String getAttributeValue() {
		String value = getLargeAttributeValue();

		if (value.isEmpty()) {
			value = getSmallAttributeValue();
		}

		return value;
	}

	@Override
	public void setAttributeValue(String value) {
		String largeAttributeValue = null;
		String smallAttributeValue = null;

		if (value != null) {
			if (value.length() > SMALL_ATTRIBUTE_VALUE_MAX_LENGTH) {
				largeAttributeValue = value;
			}
			else {
				smallAttributeValue = value;
			}
		}

		setLargeAttributeValue(largeAttributeValue);
		setSmallAttributeValue(smallAttributeValue);
	}

}