/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal.upgrade.v3_10_2.util;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

/**
 * @author Carolina Barbosa
 */
public class DDMFormFieldUpgradeProcessUtil {

	public static JSONArray getNormalizedJSONArray(JSONArray jsonArray) {
		JSONArray normalizedJSONArray = JSONFactoryUtil.createJSONArray();

		for (int i = 0; i < jsonArray.length(); i++) {
			normalizedJSONArray.put(getNormalizedName(jsonArray.getString(i)));
		}

		return normalizedJSONArray;
	}

	public static String getNormalizedName(String name) {
		if (_startsWithDigit(name)) {
			return StringPool.UNDERLINE + name;
		}

		return name;
	}

	public static boolean isDDMFormFieldWithOptions(String type) {
		if (StringUtil.equals(type, "checkbox_multiple") ||
			StringUtil.equals(type, "radio") ||
			StringUtil.equals(type, "select")) {

			return true;
		}

		return false;
	}

	private static boolean _startsWithDigit(String name) {
		if (Validator.isNull(name)) {
			return false;
		}

		return Character.isDigit(name.charAt(0));
	}

}