/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal.upgrade.v1_0_1;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

import java.sql.PreparedStatement;

/**
 * @author Rafael Praxedes
 */
public class ResourcePermissionUpgradeProcess extends UpgradeProcess {

	public ResourcePermissionUpgradeProcess(ResourceActions resourceActions) {
		_resourceActions = resourceActions;
	}

	@Override
	protected void doUpgrade() throws Exception {
		_updateResourcePermissions(DDMStructure.class.getName());

		_updateResourcePermissions(DDMTemplate.class.getName());
	}

	private String _getNewCompositeModelName(String ddmModelClassName) {
		return _resourceActions.getCompositeModelName(
			ddmModelClassName, _CLASS_NAME);
	}

	private String _getOldCompositeModelName(String ddmModelClassName) {
		return _CLASS_NAME + StringPool.DASH + ddmModelClassName;
	}

	private void _updateResourcePermissions(String ddmModelClassName)
		throws Exception {

		String newCompositeModelName = _getNewCompositeModelName(
			ddmModelClassName);
		String oldCompositeModelName = _getOldCompositeModelName(
			ddmModelClassName);

		try (PreparedStatement preparedStatement1 = connection.prepareStatement(
				"update ResourcePermission set name = ? where name = ?");
			PreparedStatement preparedStatement2 = connection.prepareStatement(
				"update ResourcePermission set primKey = ? where primKey = " +
					"?")) {

			preparedStatement1.setString(1, newCompositeModelName);
			preparedStatement1.setString(2, oldCompositeModelName);

			preparedStatement1.executeUpdate();

			preparedStatement2.setString(1, newCompositeModelName);
			preparedStatement2.setString(2, oldCompositeModelName);

			preparedStatement2.executeUpdate();
		}
	}

	private static final String _CLASS_NAME =
		"com.liferay.journal.model.JournalArticle";

	private final ResourceActions _resourceActions;

}