/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal.storage;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.dynamic.data.mapping.exception.StorageException;
import com.liferay.dynamic.data.mapping.service.DDMFieldLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapter;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterDeleteRequest;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterDeleteResponse;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterGetRequest;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterGetResponse;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterSaveRequest;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterSaveResponse;
import com.liferay.portal.kernel.exception.PortalException;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Preston Crary
 */
@Component(
	immediate = true,
	property = {
		"ddm.storage.adapter.type=default", "service.ranking:Integer=100"
	},
	service = DDMStorageAdapter.class
)
public class DefaultDDMStorageAdapter implements DDMStorageAdapter {

	@Override
	public DDMStorageAdapterDeleteResponse delete(
		DDMStorageAdapterDeleteRequest ddmStorageAdapterDeleteRequest) {

		_ddmFieldLocalService.deleteDDMFormValues(
			ddmStorageAdapterDeleteRequest.getPrimaryKey());

		return DDMStorageAdapterDeleteResponse.Builder.newBuilder(
		).build();
	}

	@Override
	public DDMStorageAdapterGetResponse get(
		DDMStorageAdapterGetRequest ddmStorageAdapterGetRequest) {

		return DDMStorageAdapterGetResponse.Builder.newBuilder(
			_ddmFieldLocalService.getDDMFormValues(
				ddmStorageAdapterGetRequest.getDDMForm(),
				ddmStorageAdapterGetRequest.getPrimaryKey())
		).build();
	}

	@Override
	public DDMStorageAdapterSaveResponse save(
			DDMStorageAdapterSaveRequest ddmStorageAdapterSaveRequest)
		throws StorageException {

		long primaryKey = ddmStorageAdapterSaveRequest.getPrimaryKey();

		if (ddmStorageAdapterSaveRequest.isInsert()) {
			primaryKey = _counterLocalService.increment();
		}

		try {
			_ddmFieldLocalService.updateDDMFormValues(
				ddmStorageAdapterSaveRequest.getStructureId(), primaryKey,
				ddmStorageAdapterSaveRequest.getDDMFormValues());
		}
		catch (PortalException portalException) {
			throw new StorageException(portalException);
		}

		return DDMStorageAdapterSaveResponse.Builder.newBuilder(
			primaryKey
		).build();
	}

	@Reference
	private CounterLocalService _counterLocalService;

	@Reference
	private DDMFieldLocalService _ddmFieldLocalService;

}