/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal.search.spi.model.query.contributor;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;

import java.io.Serializable;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Marcelo Mello
 */
@Component(
	immediate = true,
	property = "indexer.class.name=com.liferay.dynamic.data.mapping.model.DDMStructureLayout",
	service = ModelPreFilterContributor.class
)
public class DDMStructureLayoutModelPreFilterContributor
	implements ModelPreFilterContributor {

	@Override
	public void contribute(
		BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings,
		SearchContext searchContext) {

		long structureVersionId = GetterUtil.getLong(
			searchContext.getAttribute("structureVersionId"));

		if (structureVersionId > 0) {
			booleanFilter.addRequiredTerm(
				"structureVersionId", structureVersionId);
		}

		addWorkflowStatusFilter(
			booleanFilter, modelSearchSettings, searchContext);
	}

	protected void addRequiredTerm(
		BooleanFilter booleanFilter, SearchContext searchContext,
		String fieldName) {

		Serializable fieldValue = searchContext.getAttribute(fieldName);

		if (Validator.isNotNull(fieldValue)) {
			booleanFilter.addRequiredTerm(
				fieldName, String.valueOf(fieldValue));
		}
	}

	protected void addRequiredTerms(
		BooleanFilter booleanFilter, SearchContext searchContext,
		String fieldName, String contextFieldName) {

		long[] longValues = GetterUtil.getLongValues(
			searchContext.getAttribute(contextFieldName), null);

		if (ArrayUtil.isNotEmpty(longValues)) {
			TermsFilter termsFilter = new TermsFilter(fieldName);

			termsFilter.addValues(ArrayUtil.toStringArray(longValues));

			booleanFilter.add(termsFilter, BooleanClauseOccur.MUST);
		}
	}

	protected void addWorkflowStatusFilter(
		BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings,
		SearchContext searchContext) {

		Serializable fieldValue = searchContext.getAttribute(Field.STATUS);

		if (Validator.isNull(fieldValue)) {
			return;
		}

		workflowStatusModelPreFilterContributor.contribute(
			booleanFilter, modelSearchSettings, searchContext);
	}

	@Reference(target = "(model.pre.filter.contributor.id=WorkflowStatus)")
	protected ModelPreFilterContributor workflowStatusModelPreFilterContributor;

}