/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal.io.exporter;

import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordWriter;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordWriterTracker;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

/**
 * @author Leonardo Barros
 */
@Component(immediate = true, service = DDMFormInstanceRecordWriterTracker.class)
public class DDMFormInstanceRecordWriterTrackerImpl
	implements DDMFormInstanceRecordWriterTracker {

	@Override
	public DDMFormInstanceRecordWriter getDDMFormInstanceRecordWriter(
		String type) {

		return _ddmFormInstanceRecordWriters.get(type);
	}

	@Override
	public Map<String, String> getDDMFormInstanceRecordWriterExtensions() {
		return Collections.unmodifiableMap(
			_ddmFormInstanceRecordWriterExtensions);
	}

	@Reference(
		cardinality = ReferenceCardinality.MULTIPLE,
		policy = ReferencePolicy.DYNAMIC,
		policyOption = ReferencePolicyOption.GREEDY
	)
	protected void addDDMFormInstanceRecordWriter(
		DDMFormInstanceRecordWriter ddmFormInstanceRecordWriter,
		Map<String, Object> properties) {

		String type = MapUtil.getString(
			properties, "ddm.form.instance.record.writer.type");

		String extension = MapUtil.getString(
			properties, "ddm.form.instance.record.writer.extension");

		if (Validator.isNull(extension)) {
			extension = StringUtil.toUpperCase(type);
		}

		_ddmFormInstanceRecordWriterExtensions.put(type, extension);

		_ddmFormInstanceRecordWriters.put(type, ddmFormInstanceRecordWriter);
	}

	@Deactivate
	protected void deactivate() {
		_ddmFormInstanceRecordWriterExtensions.clear();
		_ddmFormInstanceRecordWriters.clear();
	}

	protected void removeDDMFormInstanceRecordWriter(
		DDMFormInstanceRecordWriter ddmFormInstanceRecordWriter,
		Map<String, Object> properties) {

		String type = MapUtil.getString(
			properties, "ddm.form.instance.record.writer.type");

		_ddmFormInstanceRecordWriterExtensions.remove(type);
		_ddmFormInstanceRecordWriters.remove(type);
	}

	private final Map<String, String> _ddmFormInstanceRecordWriterExtensions =
		new TreeMap<>();
	private final Map<String, DDMFormInstanceRecordWriter>
		_ddmFormInstanceRecordWriters = new TreeMap<>();

}