/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal.io;

import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.util.LocalizedValueUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;

import java.util.List;

/**
 * @author Gabriel Albuquerque
 */
public class DDMFormRuleJSONSerializer {

	public static JSONArray serialize(List<DDMFormRule> ddmFormRules) {
		JSONArray jsonArray = JSONFactoryUtil.createJSONArray();

		for (DDMFormRule ddmFormRule : ddmFormRules) {
			jsonArray.put(_toJSONObject(ddmFormRule));
		}

		return jsonArray;
	}

	private static JSONArray _ruleActionsToJSONArray(List<String> ruleActions) {
		JSONArray jsonArray = JSONFactoryUtil.createJSONArray();

		for (String ruleAction : ruleActions) {
			jsonArray.put(ruleAction);
		}

		return jsonArray;
	}

	private static JSONObject _toJSONObject(DDMFormRule ddmFormRule) {
		return JSONUtil.put(
			"actions", _ruleActionsToJSONArray(ddmFormRule.getActions())
		).put(
			"condition", ddmFormRule.getCondition()
		).put(
			"enabled", ddmFormRule.isEnabled()
		).put(
			"name", LocalizedValueUtil.toJSONObject(ddmFormRule.getName())
		);
	}

}