/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal.form.page.change;

import com.liferay.dynamic.data.mapping.form.page.change.DDMFormPageChange;
import com.liferay.dynamic.data.mapping.form.page.change.DDMFormPageChangeTracker;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

/**
 * @author Bruno Oliveira
 * @author Carolina Barbosa
 */
@Component(immediate = true, service = DDMFormPageChangeTracker.class)
public class DDMFormPageChangeTrackerImpl implements DDMFormPageChangeTracker {

	@Override
	public DDMFormPageChange getDDMFormPageChangeByDDMFormInstanceId(
		String ddmFormInstanceId) {

		return _ddmFormPageChangeIdTrackerMap.getService(ddmFormInstanceId);
	}

	@Activate
	protected void activate(BundleContext bundleContext) {
		_ddmFormPageChangeIdTrackerMap =
			ServiceTrackerMapFactory.openSingleValueMap(
				bundleContext, DDMFormPageChange.class, "ddm.form.instance.id");
	}

	@Deactivate
	protected void deactivate() {
		_ddmFormPageChangeIdTrackerMap.close();
	}

	private ServiceTrackerMap<String, DDMFormPageChange>
		_ddmFormPageChangeIdTrackerMap;

}