/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.render;

import com.liferay.dynamic.data.mapping.constants.DDMConstants;
import com.liferay.dynamic.data.mapping.internal.util.DDMFormFieldFreeMarkerRendererUtil;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldRenderer;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldRenderingContext;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.DDMFieldsCounter;
import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.editor.Editor;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DDMFormFieldFreeMarkerRenderer
implements DDMFormFieldRenderer {
    private static final String _DEFAULT_NAMESPACE = "alloy";
    private static final String _DEFAULT_READ_ONLY_NAMESPACE = "readonly";
    private static final String _TPL_EXT = ".ftl";
    private static final String _TPL_PATH = "com/liferay/dynamic/data/mapping/service/dependencies/";
    private static final Log _log = LogFactoryUtil.getLog(DDMFormFieldFreeMarkerRenderer.class);

    public String[] getSupportedDDMFormFieldTypes() {
        return DDMConstants.SUPPORTED_DDM_FORM_FIELD_TYPES;
    }

    public String render(DDMFormField ddmFormField, DDMFormFieldRenderingContext ddmFormFieldRenderingContext) throws PortalException {
        try {
            return this._getFieldHTML(ddmFormFieldRenderingContext.getHttpServletRequest(), ddmFormFieldRenderingContext.getHttpServletResponse(), ddmFormField, (Set)ddmFormFieldRenderingContext.getProperty("fieldNamespaces"), ddmFormFieldRenderingContext.getFields(), null, ddmFormFieldRenderingContext.getPortletNamespace(), ddmFormFieldRenderingContext.getNamespace(), ddmFormFieldRenderingContext.getMode(), ddmFormFieldRenderingContext.isReadOnly(), ddmFormFieldRenderingContext.isShowEmptyFieldLabel(), ddmFormFieldRenderingContext.getLocale());
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
    }

    private void _addDDMFormFieldOptionHTML(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, DDMFormField ddmFormField, String mode, boolean readOnly, Map<String, Object> freeMarkerContext, StringBundler sb, String label, String value) throws Exception {
        freeMarkerContext.put("fieldStructure", HashMapBuilder.put((Object)"children", (Object)"").put((Object)"fieldNamespace", (Object)StringUtil.randomId()).put((Object)"label", (Object)label).put((Object)"name", (Object)StringUtil.randomId()).put((Object)"value", (Object)value).build());
        sb.append(this._processFTL(httpServletRequest, httpServletResponse, ddmFormField.getFieldNamespace(), "option", mode, readOnly, freeMarkerContext));
    }

    private void _addLayoutProperties(DDMFormField ddmFormField, Map<String, Object> fieldContext, Locale locale) {
        LocalizedValue label = ddmFormField.getLabel();
        fieldContext.put("label", label.getString(locale));
        LocalizedValue predefinedValue = ddmFormField.getPredefinedValue();
        fieldContext.put("predefinedValue", predefinedValue.getString(locale));
        LocalizedValue style = ddmFormField.getStyle();
        fieldContext.put("style", style.getString(locale));
        LocalizedValue tip = ddmFormField.getTip();
        fieldContext.put("tip", tip.getString(locale));
    }

    private void _addStructureProperties(DDMFormField ddmFormField, Map<String, Object> fieldContext) {
        fieldContext.put("dataType", ddmFormField.getDataType());
        fieldContext.put("indexType", ddmFormField.getIndexType());
        fieldContext.put("localizable", Boolean.toString(ddmFormField.isLocalizable()));
        fieldContext.put("multiple", Boolean.toString(ddmFormField.isMultiple()));
        fieldContext.put("name", ddmFormField.getName());
        fieldContext.put("readOnly", Boolean.toString(ddmFormField.isReadOnly()));
        fieldContext.put("repeatable", Boolean.toString(ddmFormField.isRepeatable()));
        fieldContext.put("required", Boolean.toString(ddmFormField.isRequired()));
        if (Objects.equals(ddmFormField.getType(), "ddm-image") || Objects.equals(ddmFormField.getType(), "image")) {
            if (ddmFormField.isRequired()) {
                fieldContext.put("requiredDescription", GetterUtil.getBoolean((Object)ddmFormField.getProperty("requiredDescription"), (boolean)true));
            } else {
                fieldContext.put("requiredDescription", false);
            }
        }
        fieldContext.put("showLabel", Boolean.toString(ddmFormField.isShowLabel()));
        fieldContext.put("type", ddmFormField.getType());
    }

    private int _countFieldRepetition(String[] fieldsDisplayValues, String parentFieldName, int offset) {
        int total = 0;
        String fieldName = fieldsDisplayValues[offset];
        while (offset < fieldsDisplayValues.length) {
            String fieldNameValue = fieldsDisplayValues[offset];
            if (fieldNameValue.equals(fieldName)) {
                ++total;
            }
            if (fieldNameValue.equals(parentFieldName)) break;
            ++offset;
        }
        return total;
    }

    private String _getDDMFormFieldOptionHTML(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, DDMFormField ddmFormField, String mode, boolean readOnly, Locale locale, Map<String, Object> freeMarkerContext) throws Exception {
        StringBundler sb = new StringBundler();
        if (Objects.equals(ddmFormField.getType(), "select")) {
            this._addDDMFormFieldOptionHTML(httpServletRequest, httpServletResponse, ddmFormField, mode, readOnly, freeMarkerContext, sb, "", "");
        }
        DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
        for (String value : ddmFormFieldOptions.getOptionsValues()) {
            if (value.equals("")) continue;
            LocalizedValue label = ddmFormFieldOptions.getOptionLabels(value);
            this._addDDMFormFieldOptionHTML(httpServletRequest, httpServletResponse, ddmFormField, mode, readOnly, freeMarkerContext, sb, label.getString(this._getPreferredLocale(httpServletRequest, ddmFormField, locale)), value);
        }
        return sb.toString();
    }

    private Map<String, Object> _getFieldContext(HttpServletRequest httpServletRequest, String portletNamespace, String namespace, DDMFormField ddmFormField, Locale locale) {
        String name;
        Map<String, Map<String, Object>> fieldsContext = this._getFieldsContext(httpServletRequest, portletNamespace, namespace);
        Map<String, Object> fieldContext = fieldsContext.get(name = ddmFormField.getName());
        if (fieldContext != null) {
            return fieldContext;
        }
        fieldContext = new HashMap<String, Object>();
        this._addLayoutProperties(ddmFormField, fieldContext, this._getPreferredLocale(httpServletRequest, ddmFormField, locale));
        this._addStructureProperties(ddmFormField, fieldContext);
        boolean checkRequired = GetterUtil.getBoolean((Object)httpServletRequest.getAttribute("checkRequired"), (boolean)true);
        if (!checkRequired) {
            fieldContext.put("required", Boolean.FALSE.toString());
        }
        fieldsContext.put(name, fieldContext);
        return fieldContext;
    }

    private String _getFieldHTML(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, DDMFormField ddmFormField, Set<String> fieldNamespaces, Fields fields, DDMFormField parentDDMFormField, String portletNamespace, String namespace, String mode, boolean readOnly, boolean showEmptyFieldLabel, Locale locale) throws Exception {
        Map<String, Object> freeMarkerContext = this._getFreeMarkerContext(httpServletRequest, portletNamespace, namespace, ddmFormField, parentDDMFormField, showEmptyFieldLabel, locale);
        if (fields != null) {
            freeMarkerContext.put("fields", fields);
        }
        Map fieldStructure = (Map)freeMarkerContext.get("fieldStructure");
        int fieldRepetition = 1;
        int offset = 0;
        DDMFieldsCounter ddmFieldsCounter = this._getFieldsCounter(httpServletRequest, portletNamespace, namespace);
        String name = ddmFormField.getName();
        String fieldsDisplayValue = this._getFieldsDisplayValue(httpServletRequest, fields);
        Object[] fieldsDisplayValues = this._getFieldsDisplayValues(fieldsDisplayValue);
        boolean fieldDisplayable = ArrayUtil.contains((Object[])fieldsDisplayValues, (Object)name);
        if (fieldDisplayable) {
            offset = this._getFieldOffset((String[])fieldsDisplayValues, name, ddmFieldsCounter.get((Object)name));
            if (offset == fieldsDisplayValues.length) {
                return "";
            }
            Map parentFieldStructure = (Map)freeMarkerContext.get("parentFieldStructure");
            String parentFieldName = (String)parentFieldStructure.get("name");
            fieldRepetition = this._countFieldRepetition((String[])fieldsDisplayValues, parentFieldName, offset);
        }
        StringBundler sb = new StringBundler(fieldRepetition);
        while (fieldRepetition > 0) {
            offset = this._getFieldOffset((String[])fieldsDisplayValues, name, ddmFieldsCounter.get((Object)name));
            String fieldNamespace = StringUtil.randomId((int)8);
            if (fieldNamespaces != null) {
                while (fieldNamespaces.contains(fieldNamespace)) {
                    fieldNamespace = StringUtil.randomId((int)8);
                }
                fieldNamespaces.add(fieldNamespace);
            }
            if (fieldDisplayable) {
                fieldNamespace = this._getFieldNamespace(fieldsDisplayValue, offset);
            }
            fieldStructure.put("fieldNamespace", fieldNamespace);
            fieldStructure.put("valueIndex", ddmFieldsCounter.get((Object)name));
            if (fieldDisplayable) {
                ddmFieldsCounter.incrementKey((Object)name);
            }
            StringBundler childrenHTMLSB = new StringBundler(2);
            childrenHTMLSB.append(this._getHTML(httpServletRequest, httpServletResponse, ddmFormField.getNestedDDMFormFields(), fieldNamespaces, fields, ddmFormField, portletNamespace, namespace, mode, readOnly, showEmptyFieldLabel, locale));
            if (Objects.equals(ddmFormField.getType(), "select") || Objects.equals(ddmFormField.getType(), "radio")) {
                childrenHTMLSB.append(this._getDDMFormFieldOptionHTML(httpServletRequest, httpServletResponse, ddmFormField, mode, readOnly, locale, HashMapBuilder.create(freeMarkerContext).put((Object)"parentFieldStructure", (Object)fieldStructure).build()));
            }
            fieldStructure.put("children", childrenHTMLSB.toString());
            sb.append(this._processFTL(httpServletRequest, httpServletResponse, ddmFormField.getFieldNamespace(), this._toType(ddmFormField), mode, readOnly, freeMarkerContext));
            --fieldRepetition;
        }
        return sb.toString();
    }

    private String _getFieldNamespace(String fieldDisplayValue, int offset) {
        String[] fieldsDisplayValues = StringUtil.split((String)fieldDisplayValue);
        String fieldsDisplayValue = fieldsDisplayValues[offset];
        return StringUtil.extractLast((String)fieldsDisplayValue, (String)"_INSTANCE_");
    }

    private int _getFieldOffset(String[] fieldsDisplayValues, String name, int index) {
        int offset;
        for (offset = 0; !(offset >= fieldsDisplayValues.length || name.equals(fieldsDisplayValues[offset]) && --index < 0); ++offset) {
        }
        return offset;
    }

    private Map<String, Map<String, Object>> _getFieldsContext(HttpServletRequest httpServletRequest, String portletNamespace, String namespace) {
        String fieldsContextKey = portletNamespace + namespace + "fieldsContext";
        HashMap fieldsContext = (HashMap)httpServletRequest.getAttribute(fieldsContextKey);
        if (fieldsContext == null) {
            fieldsContext = new HashMap();
            httpServletRequest.setAttribute(fieldsContextKey, fieldsContext);
        }
        return fieldsContext;
    }

    private DDMFieldsCounter _getFieldsCounter(HttpServletRequest httpServletRequest, String portletNamespace, String namespace) {
        String fieldsCounterKey = portletNamespace + namespace + "fieldsCount";
        DDMFieldsCounter ddmFieldsCounter = (DDMFieldsCounter)httpServletRequest.getAttribute(fieldsCounterKey);
        if (ddmFieldsCounter == null) {
            ddmFieldsCounter = new DDMFieldsCounter();
            httpServletRequest.setAttribute(fieldsCounterKey, (Object)ddmFieldsCounter);
        }
        return ddmFieldsCounter;
    }

    private String _getFieldsDisplayValue(HttpServletRequest httpServletRequest, Fields fields) {
        Field fieldsDisplayField;
        String defaultFieldsDisplayValue = null;
        if (fields != null && (fieldsDisplayField = fields.get("_fieldsDisplay")) != null) {
            defaultFieldsDisplayValue = (String)((Object)fieldsDisplayField.getValue());
        }
        return ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"_fieldsDisplay", defaultFieldsDisplayValue);
    }

    private String[] _getFieldsDisplayValues(String fieldDisplayValue) {
        ArrayList<String> fieldsDisplayValues = new ArrayList<String>();
        for (String value : StringUtil.split((String)fieldDisplayValue)) {
            String fieldName = StringUtil.extractFirst((String)value, (String)"_INSTANCE_");
            fieldsDisplayValues.add(fieldName);
        }
        return fieldsDisplayValues.toArray(new String[0]);
    }

    private Map<String, Object> _getFreeMarkerContext(HttpServletRequest httpServletRequest, String portletNamespace, String namespace, DDMFormField ddmFormField, DDMFormField parentDDMFormField, boolean showEmptyFieldLabel, Locale locale) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        HashMap freeMarkerContext = HashMapBuilder.put((Object)"assetBrowserAuthToken", (Object)AuthTokenUtil.getToken((HttpServletRequest)httpServletRequest, (long)themeDisplay.getPlid(), (String)"com_liferay_asset_browser_web_portlet_AssetBrowserPortlet")).put((Object)"ddmAuthToken", (Object)AuthTokenUtil.getToken((HttpServletRequest)httpServletRequest, (long)themeDisplay.getPlid(), (String)"com_liferay_dynamic_data_mapping_web_portlet_DDMPortlet")).put((Object)"editorName", () -> {
            Editor editor = DDMFormFieldFreeMarkerRendererUtil.getEditor(httpServletRequest);
            return editor.getName();
        }).put((Object)"fieldStructure", this._getFieldContext(httpServletRequest, portletNamespace, namespace, ddmFormField, locale)).build();
        try {
            String itemSelectorAuthToken = AuthTokenUtil.getToken((HttpServletRequest)httpServletRequest, (long)PortalUtil.getControlPanelPlid((long)themeDisplay.getCompanyId()), (String)"com_liferay_item_selector_web_portlet_ItemSelectorPortlet");
            freeMarkerContext.put("itemSelectorAuthToken", itemSelectorAuthToken);
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to generate item selector auth token ", (Throwable)portalException);
        }
        freeMarkerContext.put("namespace", namespace);
        Map<Object, Object> parentFieldContext = new HashMap();
        if (parentDDMFormField != null) {
            parentFieldContext = this._getFieldContext(httpServletRequest, portletNamespace, namespace, parentDDMFormField, locale);
        }
        freeMarkerContext.put("parentFieldStructure", parentFieldContext);
        freeMarkerContext.put("portletNamespace", portletNamespace);
        freeMarkerContext.put("requestedLanguageDir", LanguageUtil.get((Locale)locale, (String)"lang.dir"));
        freeMarkerContext.put("requestedLocale", locale);
        freeMarkerContext.put("showEmptyFieldLabel", showEmptyFieldLabel);
        return freeMarkerContext;
    }

    private String _getHTML(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, List<DDMFormField> ddmFormFields, Set<String> fieldNamespaces, Fields fields, DDMFormField parentDDMFormField, String portletNamespace, String namespace, String mode, boolean readOnly, boolean showEmptyFieldLabel, Locale locale) throws Exception {
        StringBundler sb = new StringBundler(ddmFormFields.size());
        for (DDMFormField ddmFormField : ddmFormFields) {
            sb.append(this._getFieldHTML(httpServletRequest, httpServletResponse, ddmFormField, fieldNamespaces, fields, parentDDMFormField, portletNamespace, namespace, mode, readOnly, showEmptyFieldLabel, locale));
        }
        return sb.toString();
    }

    private Locale _getPreferredLocale(HttpServletRequest httpServletRequest, DDMFormField ddmFormField, Locale locale) {
        DDMForm ddmForm = ddmFormField.getDDMForm();
        Set availableLocales = ddmForm.getAvailableLocales();
        if (availableLocales.contains(locale)) {
            return locale;
        }
        if (availableLocales.contains(ddmForm.getDefaultLocale())) {
            return ddmForm.getDefaultLocale();
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (availableLocales.contains(themeDisplay.getSiteDefaultLocale())) {
            return themeDisplay.getSiteDefaultLocale();
        }
        Iterator iterator = availableLocales.iterator();
        return (Locale)iterator.next();
    }

    private URL _getResource(String name) {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        return classLoader.getResource(name);
    }

    private TemplateResource _getTemplateResource(String resource) throws Exception {
        Class<?> clazz = this.getClass();
        try {
            return TemplateResourceLoaderUtil.getTemplateResource((String)"ftl", (String)StringBundler.concat((String[])new String[]{ClassLoaderPool.getContextName((ClassLoader)clazz.getClassLoader()), "_CLASS_LOADER_CONTEXT_", resource}));
        }
        catch (TemplateException templateException) {
            _log.error((Object)("Unable to find template resource " + resource), (Throwable)templateException);
            throw new Exception("Unable to load template resource " + resource);
        }
    }

    private String _processFTL(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String fieldNamespace, String type, String mode, boolean readOnly, Map<String, Object> freeMarkerContext) throws Exception {
        if (Validator.isNull((String)fieldNamespace)) {
            fieldNamespace = _DEFAULT_NAMESPACE;
        }
        TemplateResource templateResource = this._getTemplateResource("com/liferay/dynamic/data/mapping/service/dependencies/alloy/text.ftl");
        Map fieldStructure = (Map)freeMarkerContext.get("fieldStructure");
        boolean fieldReadOnly = GetterUtil.getBoolean(fieldStructure.get("readOnly"));
        if (fieldReadOnly && Validator.isNotNull((String)mode) && StringUtil.equalsIgnoreCase((String)mode, (String)"edit") || readOnly) {
            fieldNamespace = _DEFAULT_READ_ONLY_NAMESPACE;
            templateResource = this._getTemplateResource("com/liferay/dynamic/data/mapping/service/dependencies/readonly/default.ftl");
        }
        String templateName = StringUtil.replaceFirst((String)type, (String)fieldNamespace.concat("-"), (String)"");
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)this._updateTemplateResource(fieldNamespace, templateName, templateResource), (boolean)false);
        for (Map.Entry<String, Object> entry : freeMarkerContext.entrySet()) {
            template.put((Object)entry.getKey(), entry.getValue());
        }
        template.prepareTaglib(httpServletRequest, httpServletResponse);
        return this._processFTL(httpServletRequest, template);
    }

    private String _processFTL(HttpServletRequest httpServletRequest, Template template) throws Exception {
        template.prepare(httpServletRequest);
        UnsyncStringWriter writer = new UnsyncStringWriter();
        template.processTemplate((Writer)writer);
        return writer.toString();
    }

    private String _toType(DDMFormField ddmFormField) {
        if (Objects.equals(ddmFormField.getProperty("dataType"), "double")) {
            return "decimal";
        }
        if (Objects.equals(ddmFormField.getProperty("dataType"), "integer")) {
            return "integer";
        }
        if (Objects.equals(ddmFormField.getProperty("displayStyle"), "multiline")) {
            return "textarea";
        }
        return ddmFormField.getType();
    }

    private TemplateResource _updateTemplateResource(String fieldNamespace, String templateName, TemplateResource templateResource) throws Exception {
        String resource = StringBundler.concat((Object[])new Object[]{_TPL_PATH, StringUtil.toLowerCase((String)fieldNamespace), Character.valueOf('/'), templateName, _TPL_EXT});
        URL url = this._getResource(resource);
        if (url != null) {
            return this._getTemplateResource(resource);
        }
        if (!Objects.equals(fieldNamespace, "ddm")) {
            return this._updateTemplateResource("ddm", templateName, templateResource);
        }
        return templateResource;
    }
}

