/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.exception.NoSuchFormInstanceRecordVersionException;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.service.base.DDMFormInstanceRecordVersionLocalServiceBaseImpl;
import com.liferay.dynamic.data.mapping.util.comparator.FormInstanceRecordVersionVersionComparator;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion"}, service={AopService.class})
public class DDMFormInstanceRecordVersionLocalServiceImpl
extends DDMFormInstanceRecordVersionLocalServiceBaseImpl {
    public DDMFormInstanceRecordVersion fetchLatestFormInstanceRecordVersion(long userId, long formInstanceId, String formInstanceVersion, int status) {
        return this.ddmFormInstanceRecordVersionPersistence.fetchByU_F_F_S_Last(userId, formInstanceId, formInstanceVersion, status, null);
    }

    public DDMFormInstanceRecordVersion getFormInstanceRecordVersion(long ddmFormInstanceRecordVersionId) throws PortalException {
        return this.ddmFormInstanceRecordVersionPersistence.findByPrimaryKey(ddmFormInstanceRecordVersionId);
    }

    public DDMFormInstanceRecordVersion getFormInstanceRecordVersion(long ddmFormInstanceId, String version) throws PortalException {
        return this.ddmFormInstanceRecordVersionPersistence.findByF_V(ddmFormInstanceId, version);
    }

    public List<DDMFormInstanceRecordVersion> getFormInstanceRecordVersions(long ddmFormInstanceRecordId, int start, int end, OrderByComparator<DDMFormInstanceRecordVersion> orderByComparator) {
        return this.ddmFormInstanceRecordVersionPersistence.findByFormInstanceRecordId(ddmFormInstanceRecordId, start, end, orderByComparator);
    }

    public List<DDMFormInstanceRecordVersion> getFormInstanceRecordVersions(long userId, long formInstanceId) {
        return this.ddmFormInstanceRecordVersionPersistence.findByU_F(userId, formInstanceId);
    }

    public int getFormInstanceRecordVersionsCount(long ddmFormInstanceRecordId) {
        return this.ddmFormInstanceRecordVersionPersistence.countByFormInstanceRecordId(ddmFormInstanceRecordId);
    }

    public DDMFormInstanceRecordVersion getLatestFormInstanceRecordVersion(long ddmFormInstanceId) throws PortalException {
        List ddmFormInstanceRecordVersions = this.ddmFormInstanceRecordVersionPersistence.findByFormInstanceRecordId(ddmFormInstanceId);
        if (ddmFormInstanceRecordVersions.isEmpty()) {
            throw new NoSuchFormInstanceRecordVersionException("No form instance record versions found for form instance ID " + ddmFormInstanceId);
        }
        ddmFormInstanceRecordVersions = ListUtil.copy((List)ddmFormInstanceRecordVersions);
        Collections.sort(ddmFormInstanceRecordVersions, new FormInstanceRecordVersionVersionComparator());
        return (DDMFormInstanceRecordVersion)ddmFormInstanceRecordVersions.get(0);
    }

    public DDMFormInstanceRecordVersion getLatestFormInstanceRecordVersion(long ddmFormInstanceRecordId, int status) throws PortalException {
        List ddmFormInstanceRecordVersions = this.ddmFormInstanceRecordVersionPersistence.findByF_S(ddmFormInstanceRecordId, status);
        if (ddmFormInstanceRecordVersions.isEmpty()) {
            throw new NoSuchFormInstanceRecordVersionException("No dynamic data mapping form instance record versions found for dynamic data mapping form instance ID " + ddmFormInstanceRecordId);
        }
        ddmFormInstanceRecordVersions = ListUtil.copy((List)ddmFormInstanceRecordVersions);
        Collections.sort(ddmFormInstanceRecordVersions, new FormInstanceRecordVersionVersionComparator());
        return (DDMFormInstanceRecordVersion)ddmFormInstanceRecordVersions.get(0);
    }
}

