/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.dynamic.data.mapping.exception.StructureDefinitionException;
import com.liferay.dynamic.data.mapping.exception.StructureDuplicateElementException;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.storage.constants.FieldConstants;
import com.liferay.dynamic.data.mapping.util.DDMXML;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReader;
import com.liferay.portal.kernel.xml.XMLSchema;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.xml.XMLSchemaImpl;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMXML.class})
public class DDMXMLImpl
implements DDMXML {
    private static final Log _log = LogFactoryUtil.getLog(DDMXMLImpl.class);
    private SAXReader _saxReader;
    private XMLSchema _xmlSchema;

    public Fields getFields(DDMStructure structure, String xml) throws PortalException {
        return this.getFields(structure, null, xml, null);
    }

    public Fields getFields(DDMStructure structure, XPath xPath, String xml, List<String> fieldNames) throws PortalException {
        Document document = null;
        try {
            document = this._saxReader.read(xml);
        }
        catch (DocumentException documentException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)documentException);
            }
            return null;
        }
        if (xPath != null && !xPath.booleanValueOf((Object)document)) {
            return null;
        }
        Fields fields = new Fields();
        Element rootElement = document.getRootElement();
        List dynamicElementElements = rootElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            String fieldName = dynamicElementElement.attributeValue("name");
            if (!structure.hasField(fieldName) || fieldNames != null && !fieldNames.contains(fieldName)) continue;
            String fieldDataType = structure.getFieldDataType(fieldName);
            List dynamicContentElements = dynamicElementElement.elements("dynamic-content");
            for (Element dynamicContentElement : dynamicContentElements) {
                String fieldValue = dynamicContentElement.getText();
                String languageId = dynamicContentElement.attributeValue("language-id");
                Locale locale = LocaleUtil.fromLanguageId((String)languageId);
                Serializable fieldValueSerializable = FieldConstants.getSerializable((String)fieldDataType, (String)fieldValue);
                Field field = fields.get(fieldName);
                if (field == null) {
                    field = new Field();
                    String defaultLanguageId = dynamicElementElement.attributeValue("default-language-id");
                    if (Validator.isNull((String)defaultLanguageId)) {
                        defaultLanguageId = rootElement.attributeValue("default-locale");
                    }
                    field.setDefaultLocale(LocaleUtil.fromLanguageId((String)defaultLanguageId));
                    field.setDDMStructureId(structure.getStructureId());
                    field.setName(fieldName);
                    field.setValue(locale, fieldValueSerializable);
                    fields.put(field);
                    continue;
                }
                field.addValue(locale, fieldValueSerializable);
            }
        }
        return fields;
    }

    public String getXML(Document document, Fields fields) {
        Element rootElement = null;
        try {
            if (document != null) {
                rootElement = document.getRootElement();
            } else {
                document = this._saxReader.createDocument();
                rootElement = document.addElement("root");
            }
            Iterator iterator = fields.iterator(true);
            while (iterator.hasNext()) {
                Field field = (Field)iterator.next();
                List<Node> nodes = this._getElementsByName(document, field.getName());
                for (Node node : nodes) {
                    document.remove(node);
                }
                this._appendField(rootElement, field);
            }
            return document.formattedString();
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public String getXML(Fields fields) {
        return this.getXML(null, fields);
    }

    public XMLSchema getXMLSchema() {
        if (this._xmlSchema == null) {
            XMLSchemaImpl xmlSchemaImpl = new XMLSchemaImpl();
            xmlSchemaImpl.setSchemaLanguage("http://www.w3.org/2001/XMLSchema");
            xmlSchemaImpl.setSystemId("http://www.liferay.com/dtd/liferay-ddm-structure_6_2_0.xsd");
            this._xmlSchema = xmlSchemaImpl;
        }
        return this._xmlSchema;
    }

    public String validateXML(String xml) throws PortalException {
        try {
            Document document = this._saxReader.read(xml, this.getXMLSchema());
            this._validate(document);
            return document.asXML();
        }
        catch (StructureDefinitionException structureDefinitionException) {
            throw structureDefinitionException;
        }
        catch (StructureDuplicateElementException structureDuplicateElementException) {
            throw structureDuplicateElementException;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Invalid XML content " + exception.getMessage()), (Throwable)exception);
            }
            throw new StructureDefinitionException((Throwable)exception);
        }
    }

    @Reference(unbind="-")
    protected void setSAXReader(SAXReader saxReader) {
        this._saxReader = saxReader;
    }

    private void _appendField(Element element, Field field) {
        Element dynamicElementElement = element.addElement("dynamic-element");
        dynamicElementElement.addAttribute("default-language-id", LocaleUtil.toLanguageId((Locale)field.getDefaultLocale()));
        dynamicElementElement.addAttribute("name", field.getName());
        for (Locale locale : field.getAvailableLocales()) {
            List values = field.getValues(locale);
            for (Serializable value : values) {
                Element dynamicContentElement = dynamicElementElement.addElement("dynamic-content");
                dynamicContentElement.addAttribute("language-id", LocaleUtil.toLanguageId((Locale)locale));
                this._updateField(dynamicContentElement, value);
            }
        }
    }

    private List<Node> _getElementsByName(Document document, String name) {
        name = HtmlUtil.escapeXPathAttribute((String)name);
        XPath xPathSelector = this._saxReader.createXPath(StringBundler.concat((String[])new String[]{"//dynamic-element[@name=", name, "]"}));
        return xPathSelector.selectNodes((Object)document);
    }

    private void _updateField(Element dynamicContentElement, Serializable fieldValue) {
        dynamicContentElement.clearContent();
        if (fieldValue instanceof Date) {
            Date valueDate = (Date)fieldValue;
            fieldValue = Long.valueOf(valueDate.getTime());
        }
        String valueString = String.valueOf(fieldValue);
        dynamicContentElement.addCDATA(valueString.trim());
    }

    private void _validate(Document document) throws Exception {
        XPath xPathSelector = this._saxReader.createXPath("//dynamic-element");
        List nodes = xPathSelector.selectNodes((Object)document);
        HashSet<String> elementNames = new HashSet<String>();
        for (Node node : nodes) {
            Element element = (Element)node;
            String name = StringUtil.toLowerCase((String)element.attributeValue("name"));
            if (Validator.isNull((String)name)) {
                throw new StructureDefinitionException("Element must have a name attribute " + element.formattedString());
            }
            if (name.startsWith("reserved")) {
                throw new StructureDefinitionException("Element name " + name + " is reserved");
            }
            if (elementNames.contains(name)) {
                throw new StructureDuplicateElementException("Element with name " + name + " already exists");
            }
            elementNames.add(name);
        }
    }
}

