/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.report;

import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.report.DDMFormFieldTypeReportProcessor;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import java.util.Iterator;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"ddm.form.field.type.name=grid"}, service={DDMFormFieldTypeReportProcessor.class})
public class GridDDMFormFieldTypeReportProcessor
implements DDMFormFieldTypeReportProcessor {
    @Reference
    protected DDMFormInstanceRecordLocalService ddmFormInstanceRecordLocalService;

    public JSONObject process(DDMFormFieldValue ddmFormFieldValue, JSONObject fieldJSONObject, long formInstanceRecordId, String ddmFormInstanceReportEvent) throws Exception {
        JSONObject valuesJSONObject = fieldJSONObject.getJSONObject("values");
        Value value = ddmFormFieldValue.getValue();
        JSONObject valueJSONObject = JSONFactoryUtil.createJSONObject((String)value.getString(value.getDefaultLocale()));
        Iterator iterator = valueJSONObject.keys();
        while (iterator.hasNext()) {
            String rowName = (String)iterator.next();
            JSONObject rowJSONObject = valuesJSONObject.getJSONObject(rowName);
            if (rowJSONObject == null) {
                rowJSONObject = JSONFactoryUtil.createJSONObject();
            }
            String columnName = valueJSONObject.getString(rowName);
            this.updateData(ddmFormInstanceReportEvent, rowJSONObject, columnName);
            valuesJSONObject.put(rowName, rowJSONObject);
        }
        DDMFormInstanceRecord ddmFormInstanceRecord = this.ddmFormInstanceRecordLocalService.getDDMFormInstanceRecord(formInstanceRecordId);
        DDMFormInstance ddmFormInstance = ddmFormInstanceRecord.getFormInstance();
        DDMStructure ddmStructure = ddmFormInstance.getStructure();
        DDMFormField ddmFormField = ddmStructure.getDDMFormField(ddmFormFieldValue.getName());
        if (valueJSONObject.length() != 0) {
            this.updateData(ddmFormInstanceReportEvent, fieldJSONObject, "totalEntries");
        } else {
            fieldJSONObject.put("totalEntries", fieldJSONObject.getInt("totalEntries"));
        }
        fieldJSONObject.put("structure", JSONUtil.put((String)"columns", (Object)this._getOptionValuesJSONArray(ddmFormField, "columns")).put("rows", this._getOptionValuesJSONArray(ddmFormField, "rows")));
        return fieldJSONObject;
    }

    private JSONArray _getOptionValuesJSONArray(DDMFormField ddmFormField, String propertyName) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        DDMFormFieldOptions ddmFormFieldOptions = (DDMFormFieldOptions)ddmFormField.getProperty(propertyName);
        if (ddmFormFieldOptions != null) {
            Set optionsValues = ddmFormFieldOptions.getOptionsValues();
            optionsValues.forEach(optionValue -> jsonArray.put(optionValue));
        }
        return jsonArray;
    }
}

