/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesMerger;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={DDMFormValuesMerger.class})
public class DDMFormValuesMergerImpl
implements DDMFormValuesMerger {
    public DDMFormValues merge(DDMForm ddmForm, DDMFormValues newDDMFormValues, DDMFormValues existingDDMFormValues) {
        ArrayList<DDMFormFieldValue> newDDMFormFieldValues = new ArrayList<DDMFormFieldValue>(newDDMFormValues.getDDMFormFieldValues());
        for (DDMFormFieldValue ddmFormFieldValue : newDDMFormValues.getDDMFormFieldValues()) {
            newDDMFormFieldValues.addAll(ddmFormFieldValue.getNestedDDMFormFieldValues());
        }
        List<DDMFormFieldValue> mergedDDMFormFieldValues = this._mergeDDMFormFieldValues(ddmForm, newDDMFormFieldValues, existingDDMFormValues.getDDMFormFieldValues());
        existingDDMFormValues.setDDMFormFieldValues(mergedDDMFormFieldValues);
        return existingDDMFormValues;
    }

    public DDMFormValues merge(DDMFormValues newDDMFormValues, DDMFormValues existingDDMFormValues) {
        return this.merge(null, newDDMFormValues, existingDDMFormValues);
    }

    private DDMFormFieldValue _getDDMFormFieldValueByName(List<DDMFormFieldValue> ddmFormFieldValues, String name) {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            if (!name.equals(ddmFormFieldValue.getName())) continue;
            return ddmFormFieldValue;
        }
        return null;
    }

    private List<DDMFormFieldValue> _mergeDDMFormFieldValues(DDMForm ddmForm, List<DDMFormFieldValue> newDDMFormFieldValues, List<DDMFormFieldValue> existingDDMFormFieldValues) {
        ArrayList<DDMFormFieldValue> mergedDDMFormFieldValues = new ArrayList<DDMFormFieldValue>(existingDDMFormFieldValues);
        for (DDMFormFieldValue newDDMFormFieldValue : newDDMFormFieldValues) {
            DDMFormValues ddmFormValues = newDDMFormFieldValue.getDDMFormValues();
            DDMFormFieldValue actualDDMFormFieldValue = this._getDDMFormFieldValueByName(existingDDMFormFieldValues, newDDMFormFieldValue.getName());
            if (actualDDMFormFieldValue != null) {
                if (ddmForm == null) {
                    ddmForm = ddmFormValues.getDDMForm();
                }
                this._mergeValue(newDDMFormFieldValue.getValue(), actualDDMFormFieldValue.getValue());
                List<DDMFormFieldValue> mergedNestedDDMFormFieldValues = this._mergeDDMFormFieldValues(null, newDDMFormFieldValue.getNestedDDMFormFieldValues(), actualDDMFormFieldValue.getNestedDDMFormFieldValues());
                newDDMFormFieldValue.setNestedDDMFormFields(mergedNestedDDMFormFieldValues);
                existingDDMFormFieldValues.remove(actualDDMFormFieldValue);
                mergedDDMFormFieldValues.remove(actualDDMFormFieldValue);
            }
            mergedDDMFormFieldValues.add(newDDMFormFieldValue);
        }
        return mergedDDMFormFieldValues;
    }

    private void _mergeValue(Value newValue, Value existingValue) {
        if (newValue == null || existingValue == null) {
            return;
        }
        for (Locale locale : existingValue.getAvailableLocales()) {
            String value = newValue.getString(locale);
            if (value != null) continue;
            newValue.addString(locale, existingValue.getString(locale));
        }
    }
}

