/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.liferay.data.engine.model.DEDataDefinitionFieldLink;
import com.liferay.data.engine.service.DEDataDefinitionFieldLinkLocalService;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidationExpression;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.util.DDMDataDefinitionConverter;
import com.liferay.dynamic.data.mapping.util.DDMFormDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormLayoutDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormSerializeUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMDataDefinitionConverter.class})
public class DDMDataDefinitionConverterImpl
implements DDMDataDefinitionConverter {
    @Reference(target="(ddm.form.deserializer.type=json)")
    private DDMFormDeserializer _ddmFormDeserializer;
    @Reference
    private DDMFormLayoutDeserializer _ddmFormLayoutDeserializer;
    @Reference(target="(ddm.form.layout.serializer.type=json)")
    private DDMFormLayoutSerializer _ddmFormLayoutSerializer;
    @Reference
    private DDMFormSerializer _ddmFormSerializer;
    @Reference
    private DEDataDefinitionFieldLinkLocalService _deDataDefinitionFieldLinkLocalService;
    @Reference
    private Portal _portal;

    public DDMForm convertDDMFormDataDefinition(DDMForm ddmForm, long parentStructureId, long parentStructureLayoutId) {
        if (Objects.equals(ddmForm.getDefinitionSchemaVersion(), "2.0")) {
            return ddmForm;
        }
        ddmForm.setDefinitionSchemaVersion("2.0");
        this._upgradeParentStructure(ddmForm, parentStructureId, parentStructureLayoutId);
        this._upgradeFields(ddmForm.getDDMFormFields(), ddmForm.getDefaultLocale());
        return this._upgradeNestedFields(ddmForm);
    }

    public String convertDDMFormDataDefinition(String dataDefinition, long parentStructureId, long parentStructureLayoutId) throws Exception {
        DDMForm ddmForm = DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._ddmFormDeserializer, (String)dataDefinition);
        ddmForm = this.convertDDMFormDataDefinition(ddmForm, parentStructureId, parentStructureLayoutId);
        return DDMFormSerializeUtil.serialize((DDMForm)ddmForm, (DDMFormSerializer)this._ddmFormSerializer);
    }

    public String convertDDMFormDataDefinition(String dataDefinition, long groupId, long parentStructureId, long parentStructureLayoutId, long structureId) throws Exception {
        DDMForm ddmForm = DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._ddmFormDeserializer, (String)dataDefinition);
        ddmForm = this.convertDDMFormDataDefinition(ddmForm, parentStructureId, parentStructureLayoutId);
        this._addDataDefinitionFieldLinks(this._portal.getClassNameId(DDMStructure.class), structureId, ddmForm.getDDMFormFields(), groupId);
        return DDMFormSerializeUtil.serialize((DDMForm)ddmForm, (DDMFormSerializer)this._ddmFormSerializer);
    }

    public DDMFormLayout convertDDMFormLayoutDataDefinition(DDMForm ddmForm, DDMFormLayout ddmFormLayout) {
        ddmFormLayout.setDefinitionSchemaVersion("2.0");
        ddmFormLayout.setPaginationMode("single-page");
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayout.getDDMFormLayoutPages()) {
            ArrayList<DDMFormLayoutRow> ddmFormLayoutRows = new ArrayList<DDMFormLayoutRow>();
            for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
                DDMFormLayoutRow ddmFormLayoutRow = new DDMFormLayoutRow();
                ddmFormLayoutRow.addDDMFormLayoutColumn(new DDMFormLayoutColumn(12, new String[]{ddmFormField.getName()}));
                ddmFormLayoutRows.add(ddmFormLayoutRow);
            }
            ddmFormLayoutPage.setDDMFormLayoutRows(ddmFormLayoutRows);
            LocalizedValue localizedValue = this._upgradeLocalizedValue(ddmFormLayout.getAvailableLocales(), ddmFormLayout.getDefaultLocale(), "page", ddmFormLayoutPage.getTitle());
            ddmFormLayoutPage.setTitle(localizedValue);
            localizedValue = this._upgradeLocalizedValue(ddmFormLayout.getAvailableLocales(), ddmFormLayout.getDefaultLocale(), "description", ddmFormLayoutPage.getDescription());
            ddmFormLayoutPage.setDescription(localizedValue);
        }
        return ddmFormLayout;
    }

    public String convertDDMFormLayoutDataDefinition(long groupId, long structureId, String structureLayoutDataDefinition, long structureLayoutId, String structureVersionDataDefinition) throws Exception {
        DDMFormLayout ddmFormLayout = DDMFormLayoutDeserializeUtil.deserialize((DDMFormLayoutDeserializer)this._ddmFormLayoutDeserializer, (String)structureLayoutDataDefinition);
        DDMForm ddmForm = DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._ddmFormDeserializer, (String)structureVersionDataDefinition);
        ddmFormLayout = this.convertDDMFormLayoutDataDefinition(ddmForm, ddmFormLayout);
        DDMFormLayoutSerializerSerializeResponse ddmFormLayoutSerializerSerializeResponse = this._ddmFormLayoutSerializer.serialize(DDMFormLayoutSerializerSerializeRequest.Builder.newBuilder((DDMFormLayout)ddmFormLayout).build());
        String content = ddmFormLayoutSerializerSerializeResponse.getContent();
        this._addDataDefinitionFieldLinks(structureId, structureLayoutId, ddmForm, this._getFieldNames(content), groupId);
        return content;
    }

    private void _addDataDefinitionFieldLinks(long dataDefinitionId, long dataLayoutId, DDMForm ddmForm, List<String> fieldNames, long groupId) throws Exception {
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        for (String fieldName : fieldNames) {
            DDMFormField ddmFormField;
            long classNameId = this._portal.getClassNameId(DDMStructureLayout.class);
            DEDataDefinitionFieldLink deDataDefinitionFieldLink = this._deDataDefinitionFieldLinkLocalService.fetchDEDataDefinitionFieldLinks(classNameId, dataLayoutId, dataDefinitionId, fieldName);
            if (deDataDefinitionFieldLink == null) {
                this._deDataDefinitionFieldLinkLocalService.addDEDataDefinitionFieldLink(groupId, classNameId, dataLayoutId, dataDefinitionId, fieldName);
            }
            if ((ddmFormField = (DDMFormField)ddmFormFieldsMap.get(fieldName)) == null) continue;
            this._addDataDefinitionFieldLinks(classNameId, dataLayoutId, Collections.singletonList(ddmFormField), groupId);
        }
    }

    private void _addDataDefinitionFieldLinks(long classNameId, long dataDefinitionId, List<DDMFormField> ddmFormFields, long groupId) throws Exception {
        for (DDMFormField ddmFormField : ddmFormFields) {
            long fieldSetDDMStructureId = GetterUtil.getLong((Object)ddmFormField.getProperty("ddmStructureId"));
            if (fieldSetDDMStructureId == 0L) continue;
            this._deDataDefinitionFieldLinkLocalService.addDEDataDefinitionFieldLink(groupId, classNameId, dataDefinitionId, fieldSetDDMStructureId, ddmFormField.getName());
            this._addDataDefinitionFieldLinks(classNameId, dataDefinitionId, ddmFormField.getNestedDDMFormFields(), groupId);
        }
    }

    private DDMFormField _createFieldSetDDMFormField(Locale defaultLocale, String name, List<DDMFormField> nestedDDMFormFields, boolean repeatable) {
        return this._createFieldSetDDMFormField("", "", defaultLocale, name, nestedDDMFormFields, repeatable, false);
    }

    private DDMFormField _createFieldSetDDMFormField(final String ddmStructureId, final String ddmStructureLayoutId, final Locale defaultLocale, String name, final List<DDMFormField> nestedDDMFormFields, final boolean repeatable, final boolean upgradedStructure) {
        return new DDMFormField(name, "fieldset"){
            {
                super(x0, x1);
                this.setLabel(new LocalizedValue(){
                    {
                        this.addString(defaultLocale, "");
                    }
                });
                this.setLocalizable(false);
                this.setNestedDDMFormFields(nestedDDMFormFields);
                this.setProperty("collapsible", false);
                this.setProperty("ddmStructureId", ddmStructureId);
                this.setProperty("ddmStructureLayoutId", ddmStructureLayoutId);
                this.setProperty("upgradedStructure", upgradedStructure);
                this.setReadOnly(false);
                this.setRepeatable(repeatable);
                this.setRequired(false);
                this.setShowLabel(false);
            }
        };
    }

    private String _getDDMFormFieldsRows(DDMFormField fieldSetDDMFormField) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (DDMFormField ddmFormField : fieldSetDDMFormField.getNestedDDMFormFields()) {
            jsonArray.put(JSONUtil.put((String)"columns", (Object)JSONUtil.putAll((Object[])new Object[]{JSONUtil.put((String)"fields", (Object)JSONUtil.putAll((Object[])new Object[]{ddmFormField.getName()})).put("size", 12)})));
        }
        return jsonArray.toString();
    }

    private LocalizedValue _getEmptyLocalizedValue(Locale defaultLocale) {
        LocalizedValue localizedValue = new LocalizedValue(defaultLocale);
        localizedValue.addString(defaultLocale, "");
        return localizedValue;
    }

    private List<String> _getFieldNames(String content) {
        DocumentContext documentContext = JsonPath.parse((String)content);
        return (List)documentContext.read("$[\"pages\"][*][\"rows\"][*][\"columns\"][*][\"fieldNames\"][*]", new Predicate[0]);
    }

    private boolean _hasNestedFields(DDMForm ddmForm) {
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            if (!ListUtil.isNotEmpty((List)ddmFormField.getNestedDDMFormFields())) continue;
            return true;
        }
        return false;
    }

    private void _upgradeColorField(DDMFormField ddmFormField) {
        ddmFormField.setDataType("string");
        ddmFormField.setFieldNamespace("");
        ddmFormField.setType("color");
        ddmFormField.setVisibilityExpression("");
    }

    private void _upgradeDateField(DDMFormField ddmFormField) {
        ddmFormField.setDataType("date");
        ddmFormField.setFieldNamespace("");
        ddmFormField.setType("date");
        ddmFormField.setVisibilityExpression("");
    }

    private void _upgradeDDMFormFieldOptionsReferences(DDMFormFieldOptions ddmFormFieldOptions) {
        if (ddmFormFieldOptions == null) {
            return;
        }
        Set ddmFormFieldOptionsValues = ddmFormFieldOptions.getOptionsValues();
        ddmFormFieldOptionsValues.forEach(ddmFormFieldOptionsValue -> ddmFormFieldOptions.addOptionReference(ddmFormFieldOptionsValue, ddmFormFieldOptionsValue.replaceAll("([\\p{Punct}|\\p{Space}$]|_)+", "")));
    }

    private void _upgradeDecimalField(DDMFormField ddmFormField) {
        ddmFormField.setDataType("double");
        ddmFormField.setFieldNamespace("");
        ddmFormField.setType("numeric");
        ddmFormField.setVisibilityExpression("");
    }

    private void _upgradeDocumentLibraryField(DDMFormField ddmFormField) {
        ddmFormField.setDataType("document-library");
        ddmFormField.setFieldNamespace("");
        ddmFormField.setType("document_library");
        ddmFormField.setVisibilityExpression("");
    }

    private void _upgradeField(DDMFormField ddmFormField, Locale defaultLocale) {
        if (ddmFormField.hasProperty("validation")) {
            Object object = ddmFormField.getProperty("validation");
            if (!(object instanceof DDMFormFieldValidation)) {
                ddmFormField.removeProperty("validation");
            } else {
                DDMFormFieldValidation ddmFormFieldValidation = (DDMFormFieldValidation)object;
                DDMFormFieldValidationExpression ddmFormFieldValidationExpression = ddmFormFieldValidation.getDDMFormFieldValidationExpression();
                if (ddmFormFieldValidationExpression == null || Validator.isNull((String)ddmFormFieldValidationExpression.getValue())) {
                    ddmFormField.removeProperty("validation");
                }
            }
        }
        if (!StringUtil.equals((String)ddmFormField.getType(), (String)"fieldset")) {
            this._upgradeDDMFormFieldOptionsReferences(ddmFormField.getDDMFormFieldOptions());
            this._upgradeDDMFormFieldOptionsReferences((DDMFormFieldOptions)ddmFormField.getProperty("columns"));
            this._upgradeDDMFormFieldOptionsReferences((DDMFormFieldOptions)ddmFormField.getProperty("rows"));
        }
        if (Objects.equals(ddmFormField.getType(), "ddm-color")) {
            this._upgradeColorField(ddmFormField);
        } else if (Objects.equals(ddmFormField.getType(), "ddm-date")) {
            this._upgradeDateField(ddmFormField);
        } else if (Objects.equals(ddmFormField.getType(), "ddm-decimal")) {
            this._upgradeDecimalField(ddmFormField);
        } else if (Objects.equals(ddmFormField.getType(), "ddm-documentlibrary")) {
            this._upgradeDocumentLibraryField(ddmFormField);
        } else if (Objects.equals(ddmFormField.getType(), "ddm-geolocation")) {
            this._upgradeGeolocation(ddmFormField);
        } else if (Objects.equals(ddmFormField.getType(), "ddm-image")) {
            this._upgradeImageField(ddmFormField);
        } else if (Objects.equals(ddmFormField.getType(), "ddm-integer")) {
            this._upgradeIntegerField(ddmFormField);
        } else if (Objects.equals(ddmFormField.getType(), "ddm-journal-article")) {
            this._upgradeJournalArticleField(ddmFormField);
        } else if (Objects.equals(ddmFormField.getType(), "ddm-link-to-page")) {
            this._upgradeLinkToPageField(ddmFormField);
        } else if (Objects.equals(ddmFormField.getType(), "ddm-number")) {
            this._upgradeNumberField(ddmFormField);
        } else if (Objects.equals(ddmFormField.getType(), "ddm-separator")) {
            this._upgradeSeparatorField(ddmFormField);
        } else if (Objects.equals(ddmFormField.getType(), "ddm-text-html")) {
            this._upgradeHTMLField(ddmFormField);
        } else if (Objects.equals(ddmFormField.getType(), "select")) {
            this._upgradeSelectField(ddmFormField);
        } else if (Objects.equals(ddmFormField.getType(), "text")) {
            this._upgradeTextField(ddmFormField, defaultLocale);
        } else if (Objects.equals(ddmFormField.getType(), "textarea")) {
            this._upgradeTextArea(ddmFormField, defaultLocale);
        }
        if (!Objects.equals(ddmFormField.getType(), "separator") && Validator.isNull((String)ddmFormField.getIndexType())) {
            ddmFormField.setIndexType("none");
        }
        this._upgradeFields(ddmFormField.getNestedDDMFormFields(), defaultLocale);
    }

    private void _upgradeFields(List<DDMFormField> ddmFormFields, Locale defaultLocale) {
        if (ddmFormFields.isEmpty()) {
            return;
        }
        for (DDMFormField ddmFormField : ddmFormFields) {
            this._upgradeField(ddmFormField, defaultLocale);
        }
    }

    private void _upgradeGeolocation(DDMFormField ddmFormField) {
        ddmFormField.setDataType("geolocation");
        ddmFormField.setFieldNamespace("");
        ddmFormField.setType("geolocation");
    }

    private void _upgradeHTMLField(DDMFormField ddmFormField) {
        ddmFormField.setDataType("string");
        ddmFormField.setFieldNamespace("");
        ddmFormField.setType("rich_text");
        ddmFormField.setVisibilityExpression("");
    }

    private void _upgradeImageField(DDMFormField ddmFormField) {
        ddmFormField.setDataType("image");
        ddmFormField.setFieldNamespace("");
        ddmFormField.setType("image");
        ddmFormField.setVisibilityExpression("");
    }

    private void _upgradeIntegerField(DDMFormField ddmFormField) {
        ddmFormField.setType("numeric");
        ddmFormField.setFieldNamespace("");
        ddmFormField.setVisibilityExpression("");
    }

    private void _upgradeJournalArticleField(DDMFormField ddmFormField) {
        ddmFormField.setDataType("journal-article");
        ddmFormField.setFieldNamespace("");
        ddmFormField.setType("journal_article");
    }

    private void _upgradeLinkToPageField(DDMFormField ddmFormField) {
        ddmFormField.setDataType("link-to-page");
        ddmFormField.setFieldNamespace("");
        ddmFormField.setType("link_to_layout");
    }

    private LocalizedValue _upgradeLocalizedValue(Set<Locale> availableLocales, Locale defaultLocale, String key, LocalizedValue localizedValue) {
        if (localizedValue == null) {
            localizedValue = new LocalizedValue();
            localizedValue.addString(defaultLocale, LanguageUtil.get((Locale)defaultLocale, (String)key));
            for (Locale locale : availableLocales) {
                localizedValue.addString(locale, LanguageUtil.get((Locale)locale, (String)key));
            }
            return localizedValue;
        }
        if (Validator.isNull((String)localizedValue.getString(defaultLocale))) {
            localizedValue.addString(defaultLocale, LanguageUtil.get((Locale)defaultLocale, (String)key));
        }
        return localizedValue;
    }

    private DDMForm _upgradeNestedFields(DDMForm ddmForm) {
        if (!this._hasNestedFields(ddmForm)) {
            return ddmForm;
        }
        DDMForm newDDMForm = new DDMForm();
        newDDMForm.setAvailableLocales(ddmForm.getAvailableLocales());
        newDDMForm.setDefaultLocale(ddmForm.getDefaultLocale());
        newDDMForm.setDefinitionSchemaVersion(ddmForm.getDefinitionSchemaVersion());
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            if (ListUtil.isEmpty((List)ddmFormField.getNestedDDMFormFields())) {
                newDDMForm.addDDMFormField(ddmFormField);
                continue;
            }
            DDMFormField fieldSetDDMFormField = this._createFieldSetDDMFormField(ddmForm.getDefaultLocale(), ddmFormField.getName() + "FieldSet", ListUtil.fromArray((Object[])new DDMFormField[]{ddmFormField}), ddmFormField.isRepeatable());
            this._upgradeNestedFields(ddmFormField.getNestedDDMFormFields(), ddmForm.getDefaultLocale(), fieldSetDDMFormField);
            fieldSetDDMFormField.setProperty("rows", (Object)this._getDDMFormFieldsRows(fieldSetDDMFormField));
            ddmFormField.setNestedDDMFormFields(Collections.emptyList());
            ddmFormField.setRepeatable(false);
            newDDMForm.addDDMFormField(fieldSetDDMFormField);
        }
        return newDDMForm;
    }

    private void _upgradeNestedFields(List<DDMFormField> ddmFormFields, Locale defaultLocale, DDMFormField parentFieldSetDDMFormField) {
        for (DDMFormField ddmFormField : ddmFormFields) {
            if (ListUtil.isEmpty((List)ddmFormField.getNestedDDMFormFields())) {
                parentFieldSetDDMFormField.addNestedDDMFormField(ddmFormField);
                continue;
            }
            DDMFormField fieldSetDDMFormField = this._createFieldSetDDMFormField(defaultLocale, ddmFormField.getName() + "FieldSet", ListUtil.fromArray((Object[])new DDMFormField[]{ddmFormField}), ddmFormField.isRepeatable());
            this._upgradeNestedFields(ddmFormField.getNestedDDMFormFields(), defaultLocale, fieldSetDDMFormField);
            fieldSetDDMFormField.setProperty("rows", (Object)this._getDDMFormFieldsRows(fieldSetDDMFormField));
            ddmFormField.setNestedDDMFormFields(Collections.emptyList());
            ddmFormField.setRepeatable(false);
            parentFieldSetDDMFormField.addNestedDDMFormField(fieldSetDDMFormField);
        }
    }

    private void _upgradeNumberField(DDMFormField ddmFormField) {
        ddmFormField.setDataType("double");
        ddmFormField.setFieldNamespace("");
        ddmFormField.setType("numeric");
        ddmFormField.setVisibilityExpression("");
    }

    private void _upgradeParentStructure(DDMForm ddmForm, long parentStructureId, long parentStructureLayoutId) {
        if (parentStructureId <= 0L) {
            return;
        }
        List ddmFormFields = ddmForm.getDDMFormFields();
        ddmFormFields.add(0, this._createFieldSetDDMFormField(String.valueOf(parentStructureId), String.valueOf(parentStructureLayoutId), ddmForm.getDefaultLocale(), "parentStructureFieldSet" + parentStructureId, Collections.emptyList(), false, true));
        ddmForm.setDDMFormFields(ddmFormFields);
    }

    private void _upgradeSelectField(DDMFormField ddmFormField) {
        ddmFormField.setFieldNamespace("");
        ddmFormField.setProperty("dataSourceType", (Object)"[manual]");
        ddmFormField.setProperty("ddmDataProviderInstanceId", (Object)"[]");
        ddmFormField.setProperty("ddmDataProviderInstanceOutput", (Object)"[]");
        ddmFormField.setVisibilityExpression("");
    }

    private void _upgradeSeparatorField(DDMFormField ddmFormField) {
        ddmFormField.setDataType("");
        ddmFormField.setFieldNamespace("");
        ddmFormField.setType("separator");
    }

    private void _upgradeTextArea(DDMFormField ddmFormField, Locale defaultLocale) {
        ddmFormField.setFieldNamespace("");
        DDMFormFieldOptions ddmFormFieldOptions = new DDMFormFieldOptions();
        ddmFormFieldOptions.addOptionLabel("Option", defaultLocale, "Option");
        ddmFormField.setDDMFormFieldOptions(ddmFormFieldOptions);
        ddmFormField.setProperty("autocomplete", (Object)false);
        ddmFormField.setProperty("dataSourceType", (Object)"manual");
        ddmFormField.setProperty("ddmDataProviderInstanceId", (Object)"[]");
        ddmFormField.setProperty("ddmDataProviderInstanceOutput", (Object)"[]");
        ddmFormField.setProperty("displayStyle", (Object)"multiline");
        ddmFormField.setProperty("placeholder", (Object)this._getEmptyLocalizedValue(defaultLocale));
        ddmFormField.setProperty("tooltip", (Object)this._getEmptyLocalizedValue(defaultLocale));
        ddmFormField.setType("text");
        ddmFormField.setVisibilityExpression("");
    }

    private void _upgradeTextField(DDMFormField ddmFormField, Locale defaultLocale) {
        ddmFormField.setFieldNamespace("");
        DDMFormFieldOptions ddmFormFieldOptions = new DDMFormFieldOptions();
        ddmFormFieldOptions.addOptionLabel("Option", defaultLocale, "Option");
        ddmFormField.setDDMFormFieldOptions(ddmFormFieldOptions);
        ddmFormField.setProperty("autocomplete", (Object)false);
        ddmFormField.setProperty("dataSourceType", (Object)"manual");
        ddmFormField.setProperty("ddmDataProviderInstanceId", (Object)"[]");
        ddmFormField.setProperty("ddmDataProviderInstanceOutput", (Object)"[]");
        ddmFormField.setProperty("displayStyle", (Object)"singleline");
        ddmFormField.setProperty("placeholder", (Object)this._getEmptyLocalizedValue(defaultLocale));
        ddmFormField.setProperty("tooltip", (Object)this._getEmptyLocalizedValue(defaultLocale));
        ddmFormField.setType("text");
        ddmFormField.setVisibilityExpression("");
    }
}

