/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v5_1_2;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Objects;

public class DDMFormInstanceUpgradeProcess
extends UpgradeProcess {
    private final JSONFactory _jsonFactory;

    public DDMFormInstanceUpgradeProcess(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        StringBundler sb = new StringBundler(3);
        sb.append("select formInstanceId, ");
        boolean hasExpirationDate = this.hasColumn("DDMFormInstance", "expirationDate");
        if (hasExpirationDate) {
            sb.append("expirationDate, ");
        }
        sb.append("settings_ from DDMFormInstance");
        try (PreparedStatement selectPreparedStatement1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement selectPreparedStatement2 = this.connection.prepareStatement("select formInstanceVersionId, settings_ from DDMFormInstanceVersion where formInstanceId = ?");
             PreparedStatement updatePreparedStatement1 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMFormInstance set settings_ = ? where formInstanceId = ?");
             PreparedStatement updatePreparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMFormInstanceVersion set settings_ = ? where formInstanceVersionId = ?");){
            this._upgradeDDMFormInstance(hasExpirationDate, selectPreparedStatement1, selectPreparedStatement2, updatePreparedStatement1, updatePreparedStatement2);
            updatePreparedStatement1.executeBatch();
            updatePreparedStatement2.executeBatch();
        }
    }

    private Object _createFieldValue(String name, String value) {
        return HashMapBuilder.put((Object)"fieldReference", (Object)name).put((Object)"instanceId", (Object)StringUtil.randomString()).put((Object)"name", (Object)name).put((Object)"value", (Object)value).build();
    }

    private String _getString(Date expirationDate) {
        if (expirationDate == null) {
            return "";
        }
        return expirationDate.toString();
    }

    private void _upgradeDDMFormInstance(boolean hasExpirationDate, PreparedStatement selectPreparedStatement1, PreparedStatement selectPreparedStatement2, PreparedStatement updatePreparedStatement1, PreparedStatement updatePreparedStatement2) throws Exception {
        try (ResultSet resultSet = selectPreparedStatement1.executeQuery();){
            while (resultSet.next()) {
                Date expirationDate = null;
                if (hasExpirationDate) {
                    expirationDate = resultSet.getDate("expirationDate");
                }
                JSONObject settingsJSONObject = this._jsonFactory.createJSONObject(resultSet.getString("settings_"));
                this._upgradeSettings(expirationDate, settingsJSONObject.getJSONArray("fieldValues"));
                updatePreparedStatement1.setString(1, settingsJSONObject.toString());
                long formInstanceId = resultSet.getLong("formInstanceId");
                updatePreparedStatement1.setLong(2, formInstanceId);
                updatePreparedStatement1.addBatch();
                this._upgradeDDMFormInstanceVersion(expirationDate, formInstanceId, selectPreparedStatement2, updatePreparedStatement2);
            }
        }
    }

    private void _upgradeDDMFormInstanceVersion(Date expirationDate, long formInstanceId, PreparedStatement selectPreparedStatement, PreparedStatement updatePreparedStatement) throws Exception {
        selectPreparedStatement.setLong(1, formInstanceId);
        try (ResultSet resultSet = selectPreparedStatement.executeQuery();){
            while (resultSet.next()) {
                String settings = resultSet.getString("settings_");
                if (!Validator.isNotNull((String)settings)) continue;
                JSONObject settingsJSONObject = this._jsonFactory.createJSONObject(settings);
                this._upgradeSettings(expirationDate, settingsJSONObject.getJSONArray("fieldValues"));
                updatePreparedStatement.setString(1, settingsJSONObject.toString());
                updatePreparedStatement.setLong(2, resultSet.getLong("formInstanceVersionId"));
                updatePreparedStatement.addBatch();
            }
        }
    }

    private void _upgradeSettings(Date expirationDate, JSONArray fieldValuesJSONArray) {
        boolean hasExpirationDate = false;
        boolean hasLimitToOneSubmissionPerUser = false;
        boolean hasNeverExpire = false;
        boolean hasShowPartialResultsToRespondents = false;
        for (int i = 0; i < fieldValuesJSONArray.length(); ++i) {
            JSONObject fieldValueJSONObject = fieldValuesJSONArray.getJSONObject(i);
            if (Objects.equals(fieldValueJSONObject.getString("name"), "expirationDate")) {
                fieldValueJSONObject.put("value", this._getString(expirationDate));
                hasExpirationDate = true;
                continue;
            }
            if (Objects.equals(fieldValueJSONObject.getString("name"), "limitToOneSubmissionPerUser")) {
                fieldValueJSONObject.put("value", String.valueOf(expirationDate != null));
                hasLimitToOneSubmissionPerUser = true;
                continue;
            }
            if (Objects.equals(fieldValueJSONObject.getString("name"), "neverExpire")) {
                fieldValueJSONObject.put("value", String.valueOf(expirationDate == null));
                hasNeverExpire = true;
                continue;
            }
            if (!Objects.equals(fieldValueJSONObject.getString("name"), "showPartialResultsToRespondents")) continue;
            fieldValueJSONObject.put("value", String.valueOf(expirationDate != null));
            hasShowPartialResultsToRespondents = true;
        }
        if (!hasExpirationDate) {
            fieldValuesJSONArray.put(this._createFieldValue("expirationDate", this._getString(expirationDate)));
        }
        if (!hasLimitToOneSubmissionPerUser) {
            fieldValuesJSONArray.put(this._createFieldValue("limitToOneSubmissionPerUser", String.valueOf(expirationDate != null)));
        }
        if (!hasNeverExpire) {
            fieldValuesJSONArray.put(this._createFieldValue("neverExpire", String.valueOf(expirationDate == null)));
        }
        if (!hasShowPartialResultsToRespondents) {
            fieldValuesJSONArray.put(this._createFieldValue("showPartialResultsToRespondents", String.valueOf(expirationDate != null)));
        }
    }
}

