/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v2_0_5;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;

public class DDMFormFieldValidationUpgradeProcess
extends UpgradeProcess {
    private final JSONFactory _jsonFactory;

    public DDMFormFieldValidationUpgradeProcess(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select structureId, definition from DDMStructure where classNameId = ? ");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");
             PreparedStatement preparedStatement3 = this.connection.prepareStatement("select structureVersionId, definition from DDMStructureVersion where structureId = ?");
             PreparedStatement preparedStatement4 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureVersionId = ?");){
            preparedStatement1.setLong(1, this.getClassNameId());
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    ResultSet resultSet2;
                    block71: {
                        String definition = resultSet.getString("definition");
                        preparedStatement2.setString(1, this._makeFieldsLocalizable(definition));
                        long structureId = resultSet.getLong("structureId");
                        preparedStatement2.setLong(2, structureId);
                        preparedStatement2.addBatch();
                        preparedStatement3.setLong(1, structureId);
                        resultSet2 = preparedStatement3.executeQuery();
                        Throwable throwable = null;
                        try {
                            while (resultSet2.next()) {
                                definition = resultSet2.getString("definition");
                                preparedStatement4.setString(1, this._makeFieldsLocalizable(definition));
                                long structureVersionId = resultSet2.getLong("structureVersionId");
                                preparedStatement4.setLong(2, structureVersionId);
                                preparedStatement4.addBatch();
                            }
                            if (resultSet2 == null) continue;
                            if (throwable == null) break block71;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (resultSet2 == null) throw throwable3;
                                if (throwable == null) {
                                    resultSet2.close();
                                    throw throwable3;
                                }
                                try {
                                    resultSet2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            resultSet2.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    resultSet2.close();
                }
            }
            preparedStatement2.executeBatch();
            preparedStatement4.executeBatch();
            return;
        }
    }

    protected long getClassNameId() {
        return PortalUtil.getClassNameId((String)"com.liferay.dynamic.data.mapping.model.DDMFormInstance");
    }

    private boolean _hasValidation(JSONObject fieldJSONObject) {
        JSONObject validationJSONObject = fieldJSONObject.getJSONObject("validation");
        return validationJSONObject != null;
    }

    private void _makeFieldsLocalizable(JSONArray availableLanguageIdsJSONArray, JSONArray fieldsJSONArray) {
        for (int i = 0; i < fieldsJSONArray.length(); ++i) {
            JSONObject validationJSONObject;
            String originalValue;
            JSONObject jsonObject = fieldsJSONArray.getJSONObject(i);
            if (!this._hasValidation(jsonObject) || JSONUtil.isValid((String)(originalValue = (validationJSONObject = jsonObject.getJSONObject("validation")).getString("errorMessage")))) continue;
            HashMap<String, String> localizedValue = new HashMap<String, String>();
            for (int j = 0; j < availableLanguageIdsJSONArray.length(); ++j) {
                localizedValue.put(availableLanguageIdsJSONArray.getString(j), originalValue);
            }
            validationJSONObject.put("errorMessage", localizedValue);
            JSONArray nestedFieldsJSONArray = jsonObject.getJSONArray("nestedFields");
            if (nestedFieldsJSONArray == null) continue;
            this._makeFieldsLocalizable(availableLanguageIdsJSONArray, nestedFieldsJSONArray);
        }
    }

    private String _makeFieldsLocalizable(String definition) throws PortalException {
        JSONObject jsonObject = this._jsonFactory.createJSONObject(definition);
        JSONArray availableLanguageIdsJSONArray = jsonObject.getJSONArray("availableLanguageIds");
        JSONArray fieldsJSONArray = jsonObject.getJSONArray("fields");
        this._makeFieldsLocalizable(availableLanguageIdsJSONArray, fieldsJSONArray);
        return jsonObject.toString();
    }
}

