/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.dynamic.data.mapping.model.impl;

import com.liferay.dynamic.data.mapping.model.DDMField;
import com.liferay.dynamic.data.mapping.model.DDMFieldModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the DDMField service. Represents a row in the &quot;DDMField&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>DDMFieldModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DDMFieldImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DDMFieldImpl
 * @generated
 */
public class DDMFieldModelImpl
	extends BaseModelImpl<DDMField> implements DDMFieldModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a ddm field model instance should use the <code>DDMField</code> interface instead.
	 */
	public static final String TABLE_NAME = "DDMField";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"fieldId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"parentFieldId", Types.BIGINT}, {"storageId", Types.BIGINT},
		{"structureVersionId", Types.BIGINT}, {"fieldName", Types.CLOB},
		{"fieldType", Types.VARCHAR}, {"instanceId", Types.VARCHAR},
		{"localizable", Types.BOOLEAN}, {"priority", Types.INTEGER}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("fieldId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("parentFieldId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("storageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("structureVersionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("fieldName", Types.CLOB);
		TABLE_COLUMNS_MAP.put("fieldType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("instanceId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("localizable", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("priority", Types.INTEGER);
	}

	public static final String TABLE_SQL_CREATE =
		"create table DDMField (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,fieldId LONG not null,companyId LONG,parentFieldId LONG,storageId LONG,structureVersionId LONG,fieldName TEXT null,fieldType VARCHAR(255) null,instanceId VARCHAR(75) null,localizable BOOLEAN,priority INTEGER,primary key (fieldId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table DDMField";

	public static final String ORDER_BY_JPQL =
		" ORDER BY ddmField.priority ASC";

	public static final String ORDER_BY_SQL = " ORDER BY DDMField.priority ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FIELDTYPE_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long INSTANCEID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STORAGEID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STRUCTUREVERSIONID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PRIORITY_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public DDMFieldModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _fieldId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setFieldId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _fieldId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return DDMField.class;
	}

	@Override
	public String getModelClassName() {
		return DDMField.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<DDMField, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<DDMField, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DDMField, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((DDMField)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<DDMField, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<DDMField, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(DDMField)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<DDMField, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<DDMField, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<DDMField, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<DDMField, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<DDMField, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<DDMField, Object>>();
		Map<String, BiConsumer<DDMField, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<DDMField, ?>>();

		attributeGetterFunctions.put("mvccVersion", DDMField::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<DDMField, Long>)DDMField::setMvccVersion);
		attributeGetterFunctions.put(
			"ctCollectionId", DDMField::getCtCollectionId);
		attributeSetterBiConsumers.put(
			"ctCollectionId",
			(BiConsumer<DDMField, Long>)DDMField::setCtCollectionId);
		attributeGetterFunctions.put("fieldId", DDMField::getFieldId);
		attributeSetterBiConsumers.put(
			"fieldId", (BiConsumer<DDMField, Long>)DDMField::setFieldId);
		attributeGetterFunctions.put("companyId", DDMField::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId", (BiConsumer<DDMField, Long>)DDMField::setCompanyId);
		attributeGetterFunctions.put(
			"parentFieldId", DDMField::getParentFieldId);
		attributeSetterBiConsumers.put(
			"parentFieldId",
			(BiConsumer<DDMField, Long>)DDMField::setParentFieldId);
		attributeGetterFunctions.put("storageId", DDMField::getStorageId);
		attributeSetterBiConsumers.put(
			"storageId", (BiConsumer<DDMField, Long>)DDMField::setStorageId);
		attributeGetterFunctions.put(
			"structureVersionId", DDMField::getStructureVersionId);
		attributeSetterBiConsumers.put(
			"structureVersionId",
			(BiConsumer<DDMField, Long>)DDMField::setStructureVersionId);
		attributeGetterFunctions.put("fieldName", DDMField::getFieldName);
		attributeSetterBiConsumers.put(
			"fieldName", (BiConsumer<DDMField, String>)DDMField::setFieldName);
		attributeGetterFunctions.put("fieldType", DDMField::getFieldType);
		attributeSetterBiConsumers.put(
			"fieldType", (BiConsumer<DDMField, String>)DDMField::setFieldType);
		attributeGetterFunctions.put("instanceId", DDMField::getInstanceId);
		attributeSetterBiConsumers.put(
			"instanceId",
			(BiConsumer<DDMField, String>)DDMField::setInstanceId);
		attributeGetterFunctions.put("localizable", DDMField::getLocalizable);
		attributeSetterBiConsumers.put(
			"localizable",
			(BiConsumer<DDMField, Boolean>)DDMField::setLocalizable);
		attributeGetterFunctions.put("priority", DDMField::getPriority);
		attributeSetterBiConsumers.put(
			"priority", (BiConsumer<DDMField, Integer>)DDMField::setPriority);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@Override
	public long getFieldId() {
		return _fieldId;
	}

	@Override
	public void setFieldId(long fieldId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fieldId = fieldId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public long getParentFieldId() {
		return _parentFieldId;
	}

	@Override
	public void setParentFieldId(long parentFieldId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_parentFieldId = parentFieldId;
	}

	@Override
	public long getStorageId() {
		return _storageId;
	}

	@Override
	public void setStorageId(long storageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_storageId = storageId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalStorageId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("storageId"));
	}

	@Override
	public long getStructureVersionId() {
		return _structureVersionId;
	}

	@Override
	public void setStructureVersionId(long structureVersionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_structureVersionId = structureVersionId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalStructureVersionId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("structureVersionId"));
	}

	@Override
	public String getFieldName() {
		if (_fieldName == null) {
			return "";
		}
		else {
			return _fieldName;
		}
	}

	@Override
	public void setFieldName(String fieldName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fieldName = fieldName;
	}

	@Override
	public String getFieldType() {
		if (_fieldType == null) {
			return "";
		}
		else {
			return _fieldType;
		}
	}

	@Override
	public void setFieldType(String fieldType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fieldType = fieldType;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalFieldType() {
		return getColumnOriginalValue("fieldType");
	}

	@Override
	public String getInstanceId() {
		if (_instanceId == null) {
			return "";
		}
		else {
			return _instanceId;
		}
	}

	@Override
	public void setInstanceId(String instanceId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_instanceId = instanceId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalInstanceId() {
		return getColumnOriginalValue("instanceId");
	}

	@Override
	public boolean getLocalizable() {
		return _localizable;
	}

	@Override
	public boolean isLocalizable() {
		return _localizable;
	}

	@Override
	public void setLocalizable(boolean localizable) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_localizable = localizable;
	}

	@Override
	public int getPriority() {
		return _priority;
	}

	@Override
	public void setPriority(int priority) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_priority = priority;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), DDMField.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public DDMField toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, DDMField>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		DDMFieldImpl ddmFieldImpl = new DDMFieldImpl();

		ddmFieldImpl.setMvccVersion(getMvccVersion());
		ddmFieldImpl.setCtCollectionId(getCtCollectionId());
		ddmFieldImpl.setFieldId(getFieldId());
		ddmFieldImpl.setCompanyId(getCompanyId());
		ddmFieldImpl.setParentFieldId(getParentFieldId());
		ddmFieldImpl.setStorageId(getStorageId());
		ddmFieldImpl.setStructureVersionId(getStructureVersionId());
		ddmFieldImpl.setFieldName(getFieldName());
		ddmFieldImpl.setFieldType(getFieldType());
		ddmFieldImpl.setInstanceId(getInstanceId());
		ddmFieldImpl.setLocalizable(isLocalizable());
		ddmFieldImpl.setPriority(getPriority());

		ddmFieldImpl.resetOriginalValues();

		return ddmFieldImpl;
	}

	@Override
	public DDMField cloneWithOriginalValues() {
		DDMFieldImpl ddmFieldImpl = new DDMFieldImpl();

		ddmFieldImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		ddmFieldImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		ddmFieldImpl.setFieldId(this.<Long>getColumnOriginalValue("fieldId"));
		ddmFieldImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		ddmFieldImpl.setParentFieldId(
			this.<Long>getColumnOriginalValue("parentFieldId"));
		ddmFieldImpl.setStorageId(
			this.<Long>getColumnOriginalValue("storageId"));
		ddmFieldImpl.setStructureVersionId(
			this.<Long>getColumnOriginalValue("structureVersionId"));
		ddmFieldImpl.setFieldName(
			this.<String>getColumnOriginalValue("fieldName"));
		ddmFieldImpl.setFieldType(
			this.<String>getColumnOriginalValue("fieldType"));
		ddmFieldImpl.setInstanceId(
			this.<String>getColumnOriginalValue("instanceId"));
		ddmFieldImpl.setLocalizable(
			this.<Boolean>getColumnOriginalValue("localizable"));
		ddmFieldImpl.setPriority(
			this.<Integer>getColumnOriginalValue("priority"));

		return ddmFieldImpl;
	}

	@Override
	public int compareTo(DDMField ddmField) {
		int value = 0;

		if (getPriority() < ddmField.getPriority()) {
			value = -1;
		}
		else if (getPriority() > ddmField.getPriority()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof DDMField)) {
			return false;
		}

		DDMField ddmField = (DDMField)object;

		long primaryKey = ddmField.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<DDMField> toCacheModel() {
		DDMFieldCacheModel ddmFieldCacheModel = new DDMFieldCacheModel();

		ddmFieldCacheModel.mvccVersion = getMvccVersion();

		ddmFieldCacheModel.ctCollectionId = getCtCollectionId();

		ddmFieldCacheModel.fieldId = getFieldId();

		ddmFieldCacheModel.companyId = getCompanyId();

		ddmFieldCacheModel.parentFieldId = getParentFieldId();

		ddmFieldCacheModel.storageId = getStorageId();

		ddmFieldCacheModel.structureVersionId = getStructureVersionId();

		ddmFieldCacheModel.fieldName = getFieldName();

		String fieldName = ddmFieldCacheModel.fieldName;

		if ((fieldName != null) && (fieldName.length() == 0)) {
			ddmFieldCacheModel.fieldName = null;
		}

		ddmFieldCacheModel.fieldType = getFieldType();

		String fieldType = ddmFieldCacheModel.fieldType;

		if ((fieldType != null) && (fieldType.length() == 0)) {
			ddmFieldCacheModel.fieldType = null;
		}

		ddmFieldCacheModel.instanceId = getInstanceId();

		String instanceId = ddmFieldCacheModel.instanceId;

		if ((instanceId != null) && (instanceId.length() == 0)) {
			ddmFieldCacheModel.instanceId = null;
		}

		ddmFieldCacheModel.localizable = isLocalizable();

		ddmFieldCacheModel.priority = getPriority();

		return ddmFieldCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<DDMField, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<DDMField, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DDMField, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((DDMField)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<DDMField, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<DDMField, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DDMField, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((DDMField)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, DDMField>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					DDMField.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private long _fieldId;
	private long _companyId;
	private long _parentFieldId;
	private long _storageId;
	private long _structureVersionId;
	private String _fieldName;
	private String _fieldType;
	private String _instanceId;
	private boolean _localizable;
	private int _priority;

	public <T> T getColumnValue(String columnName) {
		Function<DDMField, Object> function = _attributeGetterFunctions.get(
			columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((DDMField)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("fieldId", _fieldId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("parentFieldId", _parentFieldId);
		_columnOriginalValues.put("storageId", _storageId);
		_columnOriginalValues.put("structureVersionId", _structureVersionId);
		_columnOriginalValues.put("fieldName", _fieldName);
		_columnOriginalValues.put("fieldType", _fieldType);
		_columnOriginalValues.put("instanceId", _instanceId);
		_columnOriginalValues.put("localizable", _localizable);
		_columnOriginalValues.put("priority", _priority);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("fieldId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("parentFieldId", 16L);

		columnBitmasks.put("storageId", 32L);

		columnBitmasks.put("structureVersionId", 64L);

		columnBitmasks.put("fieldName", 128L);

		columnBitmasks.put("fieldType", 256L);

		columnBitmasks.put("instanceId", 512L);

		columnBitmasks.put("localizable", 1024L);

		columnBitmasks.put("priority", 2048L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private DDMField _escapedModel;

}