/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.model.impl;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceLocalServiceUtil;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordVersionLocalServiceUtil;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;

/**
 * @author Brian Wing Shun Chan
 */
public class DDMFormInstanceRecordImpl extends DDMFormInstanceRecordBaseImpl {

	@Override
	public DDMFormValues getDDMFormValues() throws PortalException {
		DDMFormInstanceRecordVersion latestFormInstanceRecordVersion =
			getLatestFormInstanceRecordVersion();

		return latestFormInstanceRecordVersion.getDDMFormValues();
	}

	@Override
	public DDMFormInstance getFormInstance() throws PortalException {
		return DDMFormInstanceLocalServiceUtil.getFormInstance(
			getFormInstanceId());
	}

	@Override
	public DDMFormInstanceRecordVersion getFormInstanceRecordVersion()
		throws PortalException {

		return getFormInstanceRecordVersion(getVersion());
	}

	@Override
	public DDMFormInstanceRecordVersion getFormInstanceRecordVersion(
			String version)
		throws PortalException {

		return DDMFormInstanceRecordVersionLocalServiceUtil.
			getFormInstanceRecordVersion(getFormInstanceRecordId(), version);
	}

	@Override
	public DDMFormInstanceRecordVersion getLatestFormInstanceRecordVersion()
		throws PortalException {

		return DDMFormInstanceRecordVersionLocalServiceUtil.
			getLatestFormInstanceRecordVersion(getFormInstanceRecordId());
	}

	@Override
	public int getStatus() throws PortalException {
		DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion =
			getFormInstanceRecordVersion();

		return ddmFormInstanceRecordVersion.getStatus();
	}

	@Override
	public String getStorageType() throws PortalException {
		DDMFormInstance ddmFormInstance = getFormInstance();

		return ddmFormInstance.getStorageType();
	}

}