/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal.upgrade.v2_0_2;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

import java.sql.PreparedStatement;

/**
 * @author Lino Alves
 */
public class DDMFormInstanceStructureResourceActionUpgradeProcess
	extends UpgradeProcess {

	public DDMFormInstanceStructureResourceActionUpgradeProcess(
		ResourceActions resourceActions) {

		_resourceActions = resourceActions;
	}

	@Override
	protected void doUpgrade() throws Exception {
		try (PreparedStatement preparedStatement1 = connection.prepareStatement(
				"delete from ResourcePermission where name = ?");
			PreparedStatement preparedStatement2 = connection.prepareStatement(
				"delete from ResourceAction where name = ?")) {

			String compositeModelName = _resourceActions.getCompositeModelName(
				DDMFormInstance.class.getName(), DDMStructure.class.getName());

			preparedStatement1.setString(1, compositeModelName);

			preparedStatement1.executeUpdate();

			preparedStatement2.setString(1, compositeModelName);

			preparedStatement2.executeUpdate();
		}
	}

	private final ResourceActions _resourceActions;

}