/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal.report;

import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.report.DDMFormFieldTypeReportProcessor;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;

import java.util.Iterator;
import java.util.Set;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Marcos Martins
 */
@Component(
	immediate = true, property = "ddm.form.field.type.name=grid",
	service = DDMFormFieldTypeReportProcessor.class
)
public class GridDDMFormFieldTypeReportProcessor
	implements DDMFormFieldTypeReportProcessor {

	@Override
	public JSONObject process(
			DDMFormFieldValue ddmFormFieldValue, JSONObject fieldJSONObject,
			long formInstanceRecordId, String ddmFormInstanceReportEvent)
		throws Exception {

		JSONObject valuesJSONObject = fieldJSONObject.getJSONObject("values");

		Value value = ddmFormFieldValue.getValue();

		JSONObject valueJSONObject = JSONFactoryUtil.createJSONObject(
			value.getString(value.getDefaultLocale()));

		Iterator<String> iterator = valueJSONObject.keys();

		while (iterator.hasNext()) {
			String rowName = iterator.next();

			JSONObject rowJSONObject = valuesJSONObject.getJSONObject(rowName);

			if (rowJSONObject == null) {
				rowJSONObject = JSONFactoryUtil.createJSONObject();
			}

			String columnName = valueJSONObject.getString(rowName);

			updateData(ddmFormInstanceReportEvent, rowJSONObject, columnName);

			valuesJSONObject.put(rowName, rowJSONObject);
		}

		DDMFormInstanceRecord ddmFormInstanceRecord =
			ddmFormInstanceRecordLocalService.getDDMFormInstanceRecord(
				formInstanceRecordId);

		DDMFormInstance ddmFormInstance =
			ddmFormInstanceRecord.getFormInstance();

		DDMStructure ddmStructure = ddmFormInstance.getStructure();

		DDMFormField ddmFormField = ddmStructure.getDDMFormField(
			ddmFormFieldValue.getName());

		if (valueJSONObject.length() != 0) {
			updateData(
				ddmFormInstanceReportEvent, fieldJSONObject, "totalEntries");
		}
		else {
			fieldJSONObject.put(
				"totalEntries", fieldJSONObject.getInt("totalEntries"));
		}

		fieldJSONObject.put(
			"structure",
			JSONUtil.put(
				"columns", _getOptionValuesJSONArray(ddmFormField, "columns")
			).put(
				"rows", _getOptionValuesJSONArray(ddmFormField, "rows")
			));

		return fieldJSONObject;
	}

	@Reference
	protected DDMFormInstanceRecordLocalService
		ddmFormInstanceRecordLocalService;

	private JSONArray _getOptionValuesJSONArray(
		DDMFormField ddmFormField, String propertyName) {

		JSONArray jsonArray = JSONFactoryUtil.createJSONArray();

		DDMFormFieldOptions ddmFormFieldOptions =
			(DDMFormFieldOptions)ddmFormField.getProperty(propertyName);

		if (ddmFormFieldOptions != null) {
			Set<String> optionsValues = ddmFormFieldOptions.getOptionsValues();

			optionsValues.forEach(optionValue -> jsonArray.put(optionValue));
		}

		return jsonArray;
	}

}