/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal.model.listener;

import com.liferay.dynamic.data.mapping.constants.DDMFormInstanceReportConstants;
import com.liferay.dynamic.data.mapping.internal.petra.executor.DDMFormInstanceReportPortalExecutor;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceReport;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordVersionLocalService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceReportLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Marcos Martins
 */
@Component(immediate = true, service = ModelListener.class)
public class DDMFormInstanceRecordVersionModelListener
	extends BaseModelListener<DDMFormInstanceRecordVersion> {

	@Override
	public void onAfterUpdate(
			DDMFormInstanceRecordVersion originalDDMFormInstanceRecordVersion,
			DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion)
		throws ModelListenerException {

		try {
			if (ddmFormInstanceRecordVersion.getStatus() !=
					WorkflowConstants.STATUS_APPROVED) {

				return;
			}

			_processFormInstanceReportEvent(
				ddmFormInstanceRecordVersion,
				DDMFormInstanceReportConstants.EVENT_ADD_RECORD_VERSION);
		}
		catch (Exception exception) {
			if (_log.isWarnEnabled()) {
				_log.warn(
					StringBundler.concat(
						"Unable to update dynamic data mapping form instance ",
						"report for dynamic data mapping form instance record ",
						ddmFormInstanceRecordVersion.getFormInstanceRecordId()),
					exception);
			}
		}
	}

	@Override
	public void onBeforeUpdate(
			DDMFormInstanceRecordVersion originalDDMFormInstanceRecordVersion,
			DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion)
		throws ModelListenerException {

		try {
			if (ddmFormInstanceRecordVersion.getStatus() !=
					WorkflowConstants.STATUS_APPROVED) {

				return;
			}

			DDMFormInstanceRecordVersion latestDDMFormInstanceRecordVersion =
				_ddmFormInstanceRecordVersionLocalService.
					getLatestFormInstanceRecordVersion(
						ddmFormInstanceRecordVersion.getFormInstanceRecordId(),
						WorkflowConstants.STATUS_APPROVED);

			_processFormInstanceReportEvent(
				latestDDMFormInstanceRecordVersion,
				DDMFormInstanceReportConstants.EVENT_DELETE_RECORD_VERSION);
		}
		catch (Exception exception) {
			if (_log.isWarnEnabled()) {
				_log.warn(
					StringBundler.concat(
						"Unable to update dynamic data mapping form instance ",
						"report for dynamic data mapping form instance record ",
						ddmFormInstanceRecordVersion.getFormInstanceRecordId()),
					exception);
			}
		}
	}

	@Reference
	protected DDMFormInstanceReportLocalService
		ddmFormInstanceReportLocalService;

	private void _processFormInstanceReportEvent(
			DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion,
			String formInstanceReportEvent)
		throws PortalException {

		DDMFormInstanceReport ddmFormInstanceReport =
			ddmFormInstanceReportLocalService.
				getFormInstanceReportByFormInstanceId(
					ddmFormInstanceRecordVersion.getFormInstanceId());

		TransactionCommitCallbackUtil.registerCallback(
			() -> {
				ddmFormInstanceReportLocalService.
					processFormInstanceReportEvent(
						ddmFormInstanceReport.getFormInstanceReportId(),
						ddmFormInstanceRecordVersion.
							getFormInstanceRecordVersionId(),
						formInstanceReportEvent);

				return null;
			});
	}

	private static final Log _log = LogFactoryUtil.getLog(
		DDMFormInstanceRecordVersionModelListener.class);

	@Reference
	private DDMFormInstanceRecordVersionLocalService
		_ddmFormInstanceRecordVersionLocalService;

	@Reference
	private DDMFormInstanceReportPortalExecutor
		_ddmFormInstanceReportPortalExecutor;

}