/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal.instance.lifecycle;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateVersionLocalService;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.model.Company;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Queue;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Shuyang Zhou
 */
@Component(immediate = true, service = PortalInstanceLifecycleListener.class)
public class DDMCleanUpPortalInstanceLifecycleListener
	extends BasePortalInstanceLifecycleListener {

	@Override
	public void portalInstancePreunregistered(Company company)
		throws Exception {

		for (DDMTemplate ddmTemplate :
				_ddmTemplateLocalService.getTemplatesByGroupId(
					company.getGroupId())) {

			_deleteDDMTemplate(ddmTemplate);
		}

		Queue<DDMStructure> queue = new LinkedList<>(
			_ddmStructureLocalService.getStructures(company.getGroupId()));

		Deque<DDMStructure> deque = new LinkedList<>();

		DDMStructure currentDDMStructure = null;

		while ((currentDDMStructure = queue.poll()) != null) {
			deque.push(currentDDMStructure);

			queue.addAll(
				_ddmStructureLocalService.getChildrenStructures(
					currentDDMStructure.getStructureId()));
		}

		for (DDMStructure ddmStructure : deque) {
			long structureId = ddmStructure.getStructureId();

			_ddmStructureLinkLocalService.deleteStructureStructureLinks(
				structureId);

			for (DDMTemplate ddmTemplate :
					_ddmTemplateLocalService.getTemplates(structureId)) {

				_deleteDDMTemplate(ddmTemplate);
			}

			_storageEngine.deleteByDDMStructure(ddmStructure.getStructureId());

			_ddmStructureLocalService.deleteStructure(ddmStructure);
		}
	}

	private void _deleteDDMTemplate(DDMTemplate ddmTemplate) throws Exception {
		_ddmTemplateVersionLocalService.deleteTemplateVersions(
			ddmTemplate.getTemplateId());

		_ddmTemplateLinkLocalService.deleteTemplateLinks(
			ddmTemplate.getTemplateId());

		_ddmTemplateLocalService.deleteTemplate(ddmTemplate);
	}

	@Reference
	private DDMStructureLinkLocalService _ddmStructureLinkLocalService;

	@Reference
	private DDMStructureLocalService _ddmStructureLocalService;

	@Reference
	private DDMTemplateLinkLocalService _ddmTemplateLinkLocalService;

	@Reference
	private DDMTemplateLocalService _ddmTemplateLocalService;

	@Reference
	private DDMTemplateVersionLocalService _ddmTemplateVersionLocalService;

	@Reference
	private StorageEngine _storageEngine;

}