/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v1_0_3;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;

public class DDMFormParagraphFieldsUpgradeProcess
extends UpgradeProcess {
    private final JSONFactory _jsonFactory;

    public DDMFormParagraphFieldsUpgradeProcess(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doUpgrade() throws Exception {
        try (PreparedStatement ps1 = this.connection.prepareStatement("select structureId, definition from DDMStructure where classNameId = ? ");
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");
             PreparedStatement ps3 = this.connection.prepareStatement("select structureVersionId, definition from DDMStructureVersion where structureId = ?");
             PreparedStatement ps4 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureVersionId = ?");){
            ps1.setLong(1, this.getClassNameId());
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    ResultSet rs2;
                    block71: {
                        String definition = rs.getString("definition");
                        ps2.setString(1, this.makeFieldsLocalizable(definition));
                        long structureId = rs.getLong("structureId");
                        ps2.setLong(2, structureId);
                        ps2.addBatch();
                        ps3.setLong(1, structureId);
                        rs2 = ps3.executeQuery();
                        Throwable throwable = null;
                        try {
                            while (rs2.next()) {
                                definition = rs2.getString("definition");
                                ps4.setString(1, this.makeFieldsLocalizable(definition));
                                long structureVersionId = rs2.getLong("structureVersionId");
                                ps4.setLong(2, structureVersionId);
                                ps4.addBatch();
                            }
                            if (rs2 == null) continue;
                            if (throwable == null) break block71;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (rs2 == null) throw throwable3;
                                if (throwable == null) {
                                    rs2.close();
                                    throw throwable3;
                                }
                                try {
                                    rs2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            rs2.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    rs2.close();
                }
            }
            ps2.executeBatch();
            ps4.executeBatch();
            return;
        }
    }

    protected long getClassNameId() {
        return PortalUtil.getClassNameId((String)"com.liferay.dynamic.data.lists.model.DDLRecordSet");
    }

    protected void makeFieldsLocalizable(JSONArray fieldsJSONArray, JSONArray availableLanguageIdsJSONArray) {
        for (int i = 0; i < fieldsJSONArray.length(); ++i) {
            JSONObject jsonObject = fieldsJSONArray.getJSONObject(i);
            String type = jsonObject.getString("type");
            if (!type.equals("paragraph") || this._isValueLocalizable(jsonObject, availableLanguageIdsJSONArray)) continue;
            String originalValue = jsonObject.getString("text");
            HashMap<String, String> localizedValue = new HashMap<String, String>();
            for (int j = 0; j < availableLanguageIdsJSONArray.length(); ++j) {
                localizedValue.put(availableLanguageIdsJSONArray.getString(j), originalValue);
            }
            jsonObject.put("text", localizedValue);
            JSONArray nestedFieldsJSONArray = jsonObject.getJSONArray("nestedFields");
            if (nestedFieldsJSONArray == null) continue;
            this.makeFieldsLocalizable(nestedFieldsJSONArray, availableLanguageIdsJSONArray);
        }
    }

    protected String makeFieldsLocalizable(String definition) throws PortalException {
        JSONObject jsonObject = this._jsonFactory.createJSONObject(definition);
        JSONArray availableLanguageIdsJSONArray = jsonObject.getJSONArray("availableLanguageIds");
        JSONArray fieldsJSONArray = jsonObject.getJSONArray("fields");
        this.makeFieldsLocalizable(fieldsJSONArray, availableLanguageIdsJSONArray);
        return jsonObject.toJSONString();
    }

    private boolean _isValueLocalizable(JSONObject fieldJSONObject, JSONArray availableLanguageIdsJSONArray) {
        JSONObject jsonObject = fieldJSONObject.getJSONObject("text");
        if (jsonObject == null) {
            return false;
        }
        for (int i = 0; i < availableLanguageIdsJSONArray.length(); ++i) {
            if (jsonObject.has(availableLanguageIdsJSONArray.getString(i))) continue;
            return false;
        }
        return true;
    }
}

