/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v1_0_1;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.PreparedStatement;

public class ResourcePermissionUpgradeProcess
extends UpgradeProcess {
    private static final String _CLASS_NAME = "com.liferay.journal.model.JournalArticle";
    private final ResourceActions _resourceActions;

    public ResourcePermissionUpgradeProcess(ResourceActions resourceActions) {
        this._resourceActions = resourceActions;
    }

    protected void doUpgrade() throws Exception {
        this.updateResourcePermissions(DDMStructure.class.getName());
        this.updateResourcePermissions(DDMTemplate.class.getName());
    }

    protected String getNewCompositeModelName(String ddmModelClassName) {
        return this._resourceActions.getCompositeModelName(new String[]{ddmModelClassName, _CLASS_NAME});
    }

    protected String getOldCompositeModelName(String ddmModelClassName) {
        return "com.liferay.journal.model.JournalArticle-" + ddmModelClassName;
    }

    protected void updateResourcePermissions(String ddmModelClassName) throws Exception {
        String newCompositeModelName = this.getNewCompositeModelName(ddmModelClassName);
        String oldCompositeModelName = this.getOldCompositeModelName(ddmModelClassName);
        try (PreparedStatement ps = this.connection.prepareStatement("update ResourcePermission set name = ? where name = ?");
             PreparedStatement ps1 = this.connection.prepareStatement("update ResourcePermission set primKey = ? where primKey = ?");){
            ps.setString(1, newCompositeModelName);
            ps.setString(2, oldCompositeModelName);
            ps.executeUpdate();
            ps1.setString(1, newCompositeModelName);
            ps1.setString(2, oldCompositeModelName);
            ps1.executeUpdate();
        }
    }
}

