/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_9_1;

import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.util.DDMFormDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormSerializeUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Set;

public class DDMStructureUpgradeProcess
extends UpgradeProcess {
    private final DDMFormDeserializer _ddmFormDeserializer;
    private final DDMFormSerializer _ddmFormSerializer;

    public DDMStructureUpgradeProcess(DDMFormDeserializer ddmFormDeserializer, DDMFormSerializer ddmFormSerializer) {
        this._ddmFormDeserializer = ddmFormDeserializer;
        this._ddmFormSerializer = ddmFormSerializer;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeDDMStructureVersion();
        this._upgradeDDMStructure();
    }

    private void _upgradeDDMFormFieldOptionsReferences(DDMFormFieldOptions ddmFormFieldOptions) {
        if (ddmFormFieldOptions == null) {
            return;
        }
        Set ddmFormFieldOptionsValues = ddmFormFieldOptions.getOptionsValues();
        ddmFormFieldOptionsValues.forEach(ddmFormFieldOptionsValue -> ddmFormFieldOptions.addOptionReference(ddmFormFieldOptionsValue, ddmFormFieldOptionsValue.replaceAll("([\\p{Punct}|\\p{Space}$]|_)+", "")));
    }

    private void _upgradeDDMFormFieldReference(DDMFormField ddmFormField) {
        ddmFormField.setFieldReference(ddmFormField.getName());
        if (!StringUtil.equals((String)ddmFormField.getType(), (String)"fieldset")) {
            this._upgradeDDMFormFieldOptionsReferences(ddmFormField.getDDMFormFieldOptions());
            this._upgradeDDMFormFieldOptionsReferences((DDMFormFieldOptions)ddmFormField.getProperty("columns"));
            this._upgradeDDMFormFieldOptionsReferences((DDMFormFieldOptions)ddmFormField.getProperty("rows"));
        }
        List nestedDDMFormFields = ddmFormField.getNestedDDMFormFields();
        nestedDDMFormFields.forEach(nestedDDMFormField -> this._upgradeDDMFormFieldReference((DDMFormField)nestedDDMFormField));
    }

    private void _upgradeDDMStructure() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMStructure.structureId, ", "DDMStructureVersion.definition from DDMStructure inner ", "join DDMStructureVersion on DDMStructure.structureId = ", "DDMStructureVersion.structureId where ", "DDMStructure.version = DDMStructureVersion.version and ", "DDMStructure.classNameId = ?"}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");){
            preparedStatement1.setLong(1, PortalUtil.getClassNameId((String)DDMFormInstance.class.getName()));
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    String definition = resultSet.getString("definition");
                    preparedStatement2.setString(1, definition);
                    long structureId = resultSet.getLong("structureId");
                    preparedStatement2.setLong(2, structureId);
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
        }
    }

    private void _upgradeDDMStructureVersion() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMStructureVersion.structureVersionId, ", "DDMStructureVersion.definition from DDMStructure inner ", "join DDMStructureVersion on DDMStructure.structureId = ", "DDMStructureVersion.structureId where ", "DDMStructure.classNameId = ?"}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureVersionId = ?");){
            preparedStatement1.setLong(1, PortalUtil.getClassNameId((String)DDMFormInstance.class.getName()));
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    long structureVersionId = resultSet.getLong("structureVersionId");
                    preparedStatement2.setString(1, this._upgradeDDMStructureVersionDefinition(resultSet.getString("definition")));
                    preparedStatement2.setLong(2, structureVersionId);
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
        }
    }

    private String _upgradeDDMStructureVersionDefinition(String definition) throws Exception {
        DDMForm ddmForm = DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._ddmFormDeserializer, (String)definition);
        List ddmFormFields = ddmForm.getDDMFormFields();
        ddmFormFields.forEach(ddmFormField -> this._upgradeDDMFormFieldReference((DDMFormField)ddmFormField));
        return DDMFormSerializeUtil.serialize((DDMForm)ddmForm, (DDMFormSerializer)this._ddmFormSerializer);
    }
}

