/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal;

import com.liferay.dynamic.data.mapping.exception.StorageException;
import com.liferay.dynamic.data.mapping.exception.StorageFieldRequiredException;
import com.liferay.dynamic.data.mapping.kernel.StorageEngineManager;
import com.liferay.dynamic.data.mapping.model.DDMContent;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMStorageLink;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMStorageLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapter;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterDeleteRequest;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterGetRequest;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterGetResponse;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterSaveRequest;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterSaveResponse;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterTracker;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMBeanTranslator;
import com.liferay.dynamic.data.mapping.validator.DDMFormValuesValidator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StorageEngineManager.class})
public class StorageEngineManagerImpl
implements StorageEngineManager {
    @Reference
    private DDM _ddm;
    @Reference
    private DDMBeanTranslator _ddmBeanTranslator;
    @Reference
    private DDMFormValuesValidator _ddmFormValuesValidator;
    @Reference
    private DDMStorageAdapterTracker _ddmStorageAdapterTracker;
    @Reference
    private DDMStorageLinkLocalService _ddmStorageLinkLocalService;
    @Reference
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;
    @Reference
    private Portal _portal;

    public long create(long companyId, long ddmStructureId, com.liferay.dynamic.data.mapping.kernel.DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        try {
            DDMFormValues translatedDDMFormValues = this._ddmBeanTranslator.translate(ddmFormValues);
            this._validate(translatedDDMFormValues, serviceContext);
            DDMStorageAdapter ddmStorageAdapter = this._getDDMStorageAdapter();
            DDMStorageAdapterSaveResponse ddmStorageAdapterSaveResponse = ddmStorageAdapter.save(DDMStorageAdapterSaveRequest.Builder.newBuilder((long)serviceContext.getUserId(), (DDMFormValues)translatedDDMFormValues).withStructureId(ddmStructureId).withUuid(serviceContext.getUuid()).withClassName(DDMStorageLink.class.getName()).build());
            long primaryKey = ddmStorageAdapterSaveResponse.getPrimaryKey();
            DDMStructureVersion ddmStructureVersion = this._ddmStructureVersionLocalService.getLatestStructureVersion(ddmStructureId);
            this._ddmStorageLinkLocalService.addStorageLink(this._portal.getClassNameId(DDMContent.class.getName()), primaryKey, ddmStructureVersion.getStructureVersionId(), serviceContext);
            return primaryKey;
        }
        catch (PortalException portalException) {
            throw this._translate(portalException);
        }
    }

    public void deleteByClass(long classPK) throws PortalException {
        this._deleteStorage(classPK);
        this._ddmStorageLinkLocalService.deleteClassStorageLink(classPK);
    }

    public com.liferay.dynamic.data.mapping.kernel.DDMFormValues getDDMFormValues(long classPK) throws PortalException {
        DDMStorageLink ddmStorageLink = this._ddmStorageLinkLocalService.getClassStorageLink(classPK);
        DDMStructure ddmStructure = ddmStorageLink.getStructure();
        DDMForm ddmForm = ddmStructure.getDDMForm();
        DDMStorageAdapter ddmStorageAdapter = this._getDDMStorageAdapter();
        DDMStorageAdapterGetResponse ddmStorageAdapterGetResponse = ddmStorageAdapter.get(DDMStorageAdapterGetRequest.Builder.newBuilder((long)classPK, (DDMForm)ddmForm).build());
        return this._ddmBeanTranslator.translate(ddmStorageAdapterGetResponse.getDDMFormValues());
    }

    public com.liferay.dynamic.data.mapping.kernel.DDMFormValues getDDMFormValues(long ddmStructureId, String fieldNamespace, ServiceContext serviceContext) throws PortalException {
        return this._ddmBeanTranslator.translate(this._ddm.getDDMFormValues(ddmStructureId, fieldNamespace, serviceContext));
    }

    public void update(long classPK, com.liferay.dynamic.data.mapping.kernel.DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        try {
            DDMFormValues translatedDDMFormValues = this._ddmBeanTranslator.translate(ddmFormValues);
            this._validate(translatedDDMFormValues, serviceContext);
            DDMStorageLink ddmStorageLink = this._ddmStorageLinkLocalService.getClassStorageLink(classPK);
            DDMStorageAdapter ddmStorageAdapter = this._getDDMStorageAdapter();
            ddmStorageAdapter.save(DDMStorageAdapterSaveRequest.Builder.newBuilder((long)serviceContext.getUserId(), (DDMFormValues)translatedDDMFormValues).withStructureId(ddmStorageLink.getStructureId()).withPrimaryKey(classPK).build());
        }
        catch (PortalException portalException) {
            throw this._translate(portalException);
        }
    }

    private void _deleteStorage(long storageId) throws StorageException {
        DDMStorageAdapter ddmStorageAdapter = this._getDDMStorageAdapter();
        ddmStorageAdapter.delete(DDMStorageAdapterDeleteRequest.Builder.newBuilder((long)storageId).build());
    }

    private DDMStorageAdapter _getDDMStorageAdapter() {
        return this._ddmStorageAdapterTracker.getDDMStorageAdapter(StorageType.DEFAULT.toString());
    }

    private PortalException _translate(PortalException portalException) {
        if (portalException instanceof StorageFieldRequiredException) {
            return new com.liferay.dynamic.data.mapping.kernel.StorageFieldRequiredException(portalException.getMessage(), portalException.getCause());
        }
        return portalException;
    }

    private void _validate(DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        boolean validateDDMFormValues = GetterUtil.getBoolean((Object)serviceContext.getAttribute("validateDDMFormValues"), (boolean)true);
        if (!validateDDMFormValues) {
            return;
        }
        this._ddmFormValuesValidator.validate(ddmFormValues);
    }
}

