/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.dynamic.data.mapping.model.impl;

import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersionModel;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersionSoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the DDMFormInstanceRecordVersion service. Represents a row in the &quot;DDMFormInstanceRecordVersion&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>DDMFormInstanceRecordVersionModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DDMFormInstanceRecordVersionImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DDMFormInstanceRecordVersionImpl
 * @generated
 */
@JSON(strict = true)
public class DDMFormInstanceRecordVersionModelImpl
	extends BaseModelImpl<DDMFormInstanceRecordVersion>
	implements DDMFormInstanceRecordVersionModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a ddm form instance record version model instance should use the <code>DDMFormInstanceRecordVersion</code> interface instead.
	 */
	public static final String TABLE_NAME = "DDMFormInstanceRecordVersion";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"formInstanceRecordVersionId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"formInstanceId", Types.BIGINT},
		{"formInstanceVersion", Types.VARCHAR},
		{"formInstanceRecordId", Types.BIGINT}, {"version", Types.VARCHAR},
		{"storageId", Types.BIGINT}, {"status", Types.INTEGER},
		{"statusByUserId", Types.BIGINT}, {"statusByUserName", Types.VARCHAR},
		{"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("formInstanceRecordVersionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("formInstanceId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("formInstanceVersion", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("formInstanceRecordId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("version", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("storageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table DDMFormInstanceRecordVersion (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,formInstanceRecordVersionId LONG not null,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,formInstanceId LONG,formInstanceVersion VARCHAR(75) null,formInstanceRecordId LONG,version VARCHAR(75) null,storageId LONG,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null,primary key (formInstanceRecordVersionId, ctCollectionId))";

	public static final String TABLE_SQL_DROP =
		"drop table DDMFormInstanceRecordVersion";

	public static final String ORDER_BY_JPQL =
		" ORDER BY ddmFormInstanceRecordVersion.formInstanceRecordVersionId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY DDMFormInstanceRecordVersion.formInstanceRecordVersionId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FORMINSTANCEID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FORMINSTANCERECORDID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FORMINSTANCEVERSION_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long USERID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long VERSION_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FORMINSTANCERECORDVERSIONID_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static DDMFormInstanceRecordVersion toModel(
		DDMFormInstanceRecordVersionSoap soapModel) {

		if (soapModel == null) {
			return null;
		}

		DDMFormInstanceRecordVersion model =
			new DDMFormInstanceRecordVersionImpl();

		model.setMvccVersion(soapModel.getMvccVersion());
		model.setCtCollectionId(soapModel.getCtCollectionId());
		model.setFormInstanceRecordVersionId(
			soapModel.getFormInstanceRecordVersionId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setFormInstanceId(soapModel.getFormInstanceId());
		model.setFormInstanceVersion(soapModel.getFormInstanceVersion());
		model.setFormInstanceRecordId(soapModel.getFormInstanceRecordId());
		model.setVersion(soapModel.getVersion());
		model.setStorageId(soapModel.getStorageId());
		model.setStatus(soapModel.getStatus());
		model.setStatusByUserId(soapModel.getStatusByUserId());
		model.setStatusByUserName(soapModel.getStatusByUserName());
		model.setStatusDate(soapModel.getStatusDate());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static List<DDMFormInstanceRecordVersion> toModels(
		DDMFormInstanceRecordVersionSoap[] soapModels) {

		if (soapModels == null) {
			return null;
		}

		List<DDMFormInstanceRecordVersion> models =
			new ArrayList<DDMFormInstanceRecordVersion>(soapModels.length);

		for (DDMFormInstanceRecordVersionSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public DDMFormInstanceRecordVersionModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _formInstanceRecordVersionId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setFormInstanceRecordVersionId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _formInstanceRecordVersionId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return DDMFormInstanceRecordVersion.class;
	}

	@Override
	public String getModelClassName() {
		return DDMFormInstanceRecordVersion.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<DDMFormInstanceRecordVersion, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<DDMFormInstanceRecordVersion, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DDMFormInstanceRecordVersion, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply(
					(DDMFormInstanceRecordVersion)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<DDMFormInstanceRecordVersion, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<DDMFormInstanceRecordVersion, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(DDMFormInstanceRecordVersion)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<DDMFormInstanceRecordVersion, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<DDMFormInstanceRecordVersion, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, DDMFormInstanceRecordVersion>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			DDMFormInstanceRecordVersion.class.getClassLoader(),
			DDMFormInstanceRecordVersion.class, ModelWrapper.class);

		try {
			Constructor<DDMFormInstanceRecordVersion> constructor =
				(Constructor<DDMFormInstanceRecordVersion>)
					proxyClass.getConstructor(InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map
		<String, Function<DDMFormInstanceRecordVersion, Object>>
			_attributeGetterFunctions;
	private static final Map
		<String, BiConsumer<DDMFormInstanceRecordVersion, Object>>
			_attributeSetterBiConsumers;

	static {
		Map<String, Function<DDMFormInstanceRecordVersion, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<DDMFormInstanceRecordVersion, Object>>();
		Map<String, BiConsumer<DDMFormInstanceRecordVersion, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<DDMFormInstanceRecordVersion, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", DDMFormInstanceRecordVersion::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<DDMFormInstanceRecordVersion, Long>)
				DDMFormInstanceRecordVersion::setMvccVersion);
		attributeGetterFunctions.put(
			"ctCollectionId", DDMFormInstanceRecordVersion::getCtCollectionId);
		attributeSetterBiConsumers.put(
			"ctCollectionId",
			(BiConsumer<DDMFormInstanceRecordVersion, Long>)
				DDMFormInstanceRecordVersion::setCtCollectionId);
		attributeGetterFunctions.put(
			"formInstanceRecordVersionId",
			DDMFormInstanceRecordVersion::getFormInstanceRecordVersionId);
		attributeSetterBiConsumers.put(
			"formInstanceRecordVersionId",
			(BiConsumer<DDMFormInstanceRecordVersion, Long>)
				DDMFormInstanceRecordVersion::setFormInstanceRecordVersionId);
		attributeGetterFunctions.put(
			"groupId", DDMFormInstanceRecordVersion::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId",
			(BiConsumer<DDMFormInstanceRecordVersion, Long>)
				DDMFormInstanceRecordVersion::setGroupId);
		attributeGetterFunctions.put(
			"companyId", DDMFormInstanceRecordVersion::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<DDMFormInstanceRecordVersion, Long>)
				DDMFormInstanceRecordVersion::setCompanyId);
		attributeGetterFunctions.put(
			"userId", DDMFormInstanceRecordVersion::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<DDMFormInstanceRecordVersion, Long>)
				DDMFormInstanceRecordVersion::setUserId);
		attributeGetterFunctions.put(
			"userName", DDMFormInstanceRecordVersion::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<DDMFormInstanceRecordVersion, String>)
				DDMFormInstanceRecordVersion::setUserName);
		attributeGetterFunctions.put(
			"createDate", DDMFormInstanceRecordVersion::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<DDMFormInstanceRecordVersion, Date>)
				DDMFormInstanceRecordVersion::setCreateDate);
		attributeGetterFunctions.put(
			"formInstanceId", DDMFormInstanceRecordVersion::getFormInstanceId);
		attributeSetterBiConsumers.put(
			"formInstanceId",
			(BiConsumer<DDMFormInstanceRecordVersion, Long>)
				DDMFormInstanceRecordVersion::setFormInstanceId);
		attributeGetterFunctions.put(
			"formInstanceVersion",
			DDMFormInstanceRecordVersion::getFormInstanceVersion);
		attributeSetterBiConsumers.put(
			"formInstanceVersion",
			(BiConsumer<DDMFormInstanceRecordVersion, String>)
				DDMFormInstanceRecordVersion::setFormInstanceVersion);
		attributeGetterFunctions.put(
			"formInstanceRecordId",
			DDMFormInstanceRecordVersion::getFormInstanceRecordId);
		attributeSetterBiConsumers.put(
			"formInstanceRecordId",
			(BiConsumer<DDMFormInstanceRecordVersion, Long>)
				DDMFormInstanceRecordVersion::setFormInstanceRecordId);
		attributeGetterFunctions.put(
			"version", DDMFormInstanceRecordVersion::getVersion);
		attributeSetterBiConsumers.put(
			"version",
			(BiConsumer<DDMFormInstanceRecordVersion, String>)
				DDMFormInstanceRecordVersion::setVersion);
		attributeGetterFunctions.put(
			"storageId", DDMFormInstanceRecordVersion::getStorageId);
		attributeSetterBiConsumers.put(
			"storageId",
			(BiConsumer<DDMFormInstanceRecordVersion, Long>)
				DDMFormInstanceRecordVersion::setStorageId);
		attributeGetterFunctions.put(
			"status", DDMFormInstanceRecordVersion::getStatus);
		attributeSetterBiConsumers.put(
			"status",
			(BiConsumer<DDMFormInstanceRecordVersion, Integer>)
				DDMFormInstanceRecordVersion::setStatus);
		attributeGetterFunctions.put(
			"statusByUserId", DDMFormInstanceRecordVersion::getStatusByUserId);
		attributeSetterBiConsumers.put(
			"statusByUserId",
			(BiConsumer<DDMFormInstanceRecordVersion, Long>)
				DDMFormInstanceRecordVersion::setStatusByUserId);
		attributeGetterFunctions.put(
			"statusByUserName",
			DDMFormInstanceRecordVersion::getStatusByUserName);
		attributeSetterBiConsumers.put(
			"statusByUserName",
			(BiConsumer<DDMFormInstanceRecordVersion, String>)
				DDMFormInstanceRecordVersion::setStatusByUserName);
		attributeGetterFunctions.put(
			"statusDate", DDMFormInstanceRecordVersion::getStatusDate);
		attributeSetterBiConsumers.put(
			"statusDate",
			(BiConsumer<DDMFormInstanceRecordVersion, Date>)
				DDMFormInstanceRecordVersion::setStatusDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public long getFormInstanceRecordVersionId() {
		return _formInstanceRecordVersionId;
	}

	@Override
	public void setFormInstanceRecordVersionId(
		long formInstanceRecordVersionId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_formInstanceRecordVersionId = formInstanceRecordVersionId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalUserId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("userId"));
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public long getFormInstanceId() {
		return _formInstanceId;
	}

	@Override
	public void setFormInstanceId(long formInstanceId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_formInstanceId = formInstanceId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalFormInstanceId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("formInstanceId"));
	}

	@JSON
	@Override
	public String getFormInstanceVersion() {
		if (_formInstanceVersion == null) {
			return "";
		}
		else {
			return _formInstanceVersion;
		}
	}

	@Override
	public void setFormInstanceVersion(String formInstanceVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_formInstanceVersion = formInstanceVersion;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalFormInstanceVersion() {
		return getColumnOriginalValue("formInstanceVersion");
	}

	@JSON
	@Override
	public long getFormInstanceRecordId() {
		return _formInstanceRecordId;
	}

	@Override
	public void setFormInstanceRecordId(long formInstanceRecordId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_formInstanceRecordId = formInstanceRecordId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalFormInstanceRecordId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("formInstanceRecordId"));
	}

	@JSON
	@Override
	public String getVersion() {
		if (_version == null) {
			return "";
		}
		else {
			return _version;
		}
	}

	@Override
	public void setVersion(String version) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_version = version;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalVersion() {
		return getColumnOriginalValue("version");
	}

	@JSON
	@Override
	public long getStorageId() {
		return _storageId;
	}

	@Override
	public void setStorageId(long storageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_storageId = storageId;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), DDMFormInstanceRecordVersion.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public DDMFormInstanceRecordVersion toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, DDMFormInstanceRecordVersion>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		DDMFormInstanceRecordVersionImpl ddmFormInstanceRecordVersionImpl =
			new DDMFormInstanceRecordVersionImpl();

		ddmFormInstanceRecordVersionImpl.setMvccVersion(getMvccVersion());
		ddmFormInstanceRecordVersionImpl.setCtCollectionId(getCtCollectionId());
		ddmFormInstanceRecordVersionImpl.setFormInstanceRecordVersionId(
			getFormInstanceRecordVersionId());
		ddmFormInstanceRecordVersionImpl.setGroupId(getGroupId());
		ddmFormInstanceRecordVersionImpl.setCompanyId(getCompanyId());
		ddmFormInstanceRecordVersionImpl.setUserId(getUserId());
		ddmFormInstanceRecordVersionImpl.setUserName(getUserName());
		ddmFormInstanceRecordVersionImpl.setCreateDate(getCreateDate());
		ddmFormInstanceRecordVersionImpl.setFormInstanceId(getFormInstanceId());
		ddmFormInstanceRecordVersionImpl.setFormInstanceVersion(
			getFormInstanceVersion());
		ddmFormInstanceRecordVersionImpl.setFormInstanceRecordId(
			getFormInstanceRecordId());
		ddmFormInstanceRecordVersionImpl.setVersion(getVersion());
		ddmFormInstanceRecordVersionImpl.setStorageId(getStorageId());
		ddmFormInstanceRecordVersionImpl.setStatus(getStatus());
		ddmFormInstanceRecordVersionImpl.setStatusByUserId(getStatusByUserId());
		ddmFormInstanceRecordVersionImpl.setStatusByUserName(
			getStatusByUserName());
		ddmFormInstanceRecordVersionImpl.setStatusDate(getStatusDate());

		ddmFormInstanceRecordVersionImpl.resetOriginalValues();

		return ddmFormInstanceRecordVersionImpl;
	}

	@Override
	public DDMFormInstanceRecordVersion cloneWithOriginalValues() {
		DDMFormInstanceRecordVersionImpl ddmFormInstanceRecordVersionImpl =
			new DDMFormInstanceRecordVersionImpl();

		ddmFormInstanceRecordVersionImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		ddmFormInstanceRecordVersionImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		ddmFormInstanceRecordVersionImpl.setFormInstanceRecordVersionId(
			this.<Long>getColumnOriginalValue("formInstanceRecordVersionId"));
		ddmFormInstanceRecordVersionImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		ddmFormInstanceRecordVersionImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		ddmFormInstanceRecordVersionImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		ddmFormInstanceRecordVersionImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		ddmFormInstanceRecordVersionImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		ddmFormInstanceRecordVersionImpl.setFormInstanceId(
			this.<Long>getColumnOriginalValue("formInstanceId"));
		ddmFormInstanceRecordVersionImpl.setFormInstanceVersion(
			this.<String>getColumnOriginalValue("formInstanceVersion"));
		ddmFormInstanceRecordVersionImpl.setFormInstanceRecordId(
			this.<Long>getColumnOriginalValue("formInstanceRecordId"));
		ddmFormInstanceRecordVersionImpl.setVersion(
			this.<String>getColumnOriginalValue("version"));
		ddmFormInstanceRecordVersionImpl.setStorageId(
			this.<Long>getColumnOriginalValue("storageId"));
		ddmFormInstanceRecordVersionImpl.setStatus(
			this.<Integer>getColumnOriginalValue("status"));
		ddmFormInstanceRecordVersionImpl.setStatusByUserId(
			this.<Long>getColumnOriginalValue("statusByUserId"));
		ddmFormInstanceRecordVersionImpl.setStatusByUserName(
			this.<String>getColumnOriginalValue("statusByUserName"));
		ddmFormInstanceRecordVersionImpl.setStatusDate(
			this.<Date>getColumnOriginalValue("statusDate"));

		return ddmFormInstanceRecordVersionImpl;
	}

	@Override
	public int compareTo(
		DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion) {

		long primaryKey = ddmFormInstanceRecordVersion.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof DDMFormInstanceRecordVersion)) {
			return false;
		}

		DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion =
			(DDMFormInstanceRecordVersion)object;

		long primaryKey = ddmFormInstanceRecordVersion.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<DDMFormInstanceRecordVersion> toCacheModel() {
		DDMFormInstanceRecordVersionCacheModel
			ddmFormInstanceRecordVersionCacheModel =
				new DDMFormInstanceRecordVersionCacheModel();

		ddmFormInstanceRecordVersionCacheModel.mvccVersion = getMvccVersion();

		ddmFormInstanceRecordVersionCacheModel.ctCollectionId =
			getCtCollectionId();

		ddmFormInstanceRecordVersionCacheModel.formInstanceRecordVersionId =
			getFormInstanceRecordVersionId();

		ddmFormInstanceRecordVersionCacheModel.groupId = getGroupId();

		ddmFormInstanceRecordVersionCacheModel.companyId = getCompanyId();

		ddmFormInstanceRecordVersionCacheModel.userId = getUserId();

		ddmFormInstanceRecordVersionCacheModel.userName = getUserName();

		String userName = ddmFormInstanceRecordVersionCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			ddmFormInstanceRecordVersionCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			ddmFormInstanceRecordVersionCacheModel.createDate =
				createDate.getTime();
		}
		else {
			ddmFormInstanceRecordVersionCacheModel.createDate = Long.MIN_VALUE;
		}

		ddmFormInstanceRecordVersionCacheModel.formInstanceId =
			getFormInstanceId();

		ddmFormInstanceRecordVersionCacheModel.formInstanceVersion =
			getFormInstanceVersion();

		String formInstanceVersion =
			ddmFormInstanceRecordVersionCacheModel.formInstanceVersion;

		if ((formInstanceVersion != null) &&
			(formInstanceVersion.length() == 0)) {

			ddmFormInstanceRecordVersionCacheModel.formInstanceVersion = null;
		}

		ddmFormInstanceRecordVersionCacheModel.formInstanceRecordId =
			getFormInstanceRecordId();

		ddmFormInstanceRecordVersionCacheModel.version = getVersion();

		String version = ddmFormInstanceRecordVersionCacheModel.version;

		if ((version != null) && (version.length() == 0)) {
			ddmFormInstanceRecordVersionCacheModel.version = null;
		}

		ddmFormInstanceRecordVersionCacheModel.storageId = getStorageId();

		ddmFormInstanceRecordVersionCacheModel.status = getStatus();

		ddmFormInstanceRecordVersionCacheModel.statusByUserId =
			getStatusByUserId();

		ddmFormInstanceRecordVersionCacheModel.statusByUserName =
			getStatusByUserName();

		String statusByUserName =
			ddmFormInstanceRecordVersionCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			ddmFormInstanceRecordVersionCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			ddmFormInstanceRecordVersionCacheModel.statusDate =
				statusDate.getTime();
		}
		else {
			ddmFormInstanceRecordVersionCacheModel.statusDate = Long.MIN_VALUE;
		}

		return ddmFormInstanceRecordVersionCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<DDMFormInstanceRecordVersion, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<DDMFormInstanceRecordVersion, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DDMFormInstanceRecordVersion, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(DDMFormInstanceRecordVersion)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<DDMFormInstanceRecordVersion, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<DDMFormInstanceRecordVersion, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DDMFormInstanceRecordVersion, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply(
					(DDMFormInstanceRecordVersion)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, DDMFormInstanceRecordVersion>
				_escapedModelProxyProviderFunction =
					_getProxyProviderFunction();

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private long _formInstanceRecordVersionId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private long _formInstanceId;
	private String _formInstanceVersion;
	private long _formInstanceRecordId;
	private String _version;
	private long _storageId;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		Function<DDMFormInstanceRecordVersion, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((DDMFormInstanceRecordVersion)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put(
			"formInstanceRecordVersionId", _formInstanceRecordVersionId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("formInstanceId", _formInstanceId);
		_columnOriginalValues.put("formInstanceVersion", _formInstanceVersion);
		_columnOriginalValues.put(
			"formInstanceRecordId", _formInstanceRecordId);
		_columnOriginalValues.put("version", _version);
		_columnOriginalValues.put("storageId", _storageId);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("formInstanceRecordVersionId", 4L);

		columnBitmasks.put("groupId", 8L);

		columnBitmasks.put("companyId", 16L);

		columnBitmasks.put("userId", 32L);

		columnBitmasks.put("userName", 64L);

		columnBitmasks.put("createDate", 128L);

		columnBitmasks.put("formInstanceId", 256L);

		columnBitmasks.put("formInstanceVersion", 512L);

		columnBitmasks.put("formInstanceRecordId", 1024L);

		columnBitmasks.put("version", 2048L);

		columnBitmasks.put("storageId", 4096L);

		columnBitmasks.put("status", 8192L);

		columnBitmasks.put("statusByUserId", 16384L);

		columnBitmasks.put("statusByUserName", 32768L);

		columnBitmasks.put("statusDate", 65536L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private DDMFormInstanceRecordVersion _escapedModel;

}