/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.workflow;

import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordLocalService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordVersionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.workflow.BaseWorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={WorkflowHandler.class})
public class DDMFormInstanceRecordWorkflowHandler
extends BaseWorkflowHandler<DDMFormInstanceRecord> {
    @Reference
    private DDMFormInstanceRecordLocalService _ddmFormInstanceRecordLocalService;
    @Reference
    private DDMFormInstanceRecordVersionLocalService _ddmFormInstanceRecordVersionLocalService;
    @Reference
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;

    public AssetRenderer<DDMFormInstanceRecord> getAssetRenderer(long classPK) throws PortalException {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        if (assetRendererFactory == null) {
            return null;
        }
        DDMFormInstanceRecordVersion formInstanceRecordVersion = this._ddmFormInstanceRecordVersionLocalService.getFormInstanceRecordVersion(classPK);
        return assetRendererFactory.getAssetRenderer(formInstanceRecordVersion.getFormInstanceRecordId(), 0);
    }

    public String getClassName() {
        return DDMFormInstanceRecord.class.getName();
    }

    public String getType(Locale locale) {
        return ResourceActionsUtil.getModelResource((Locale)locale, (String)this.getClassName());
    }

    public WorkflowDefinitionLink getWorkflowDefinitionLink(long companyId, long groupId, long classPK) throws PortalException {
        DDMFormInstanceRecordVersion formInstanceRecordVersion = this._ddmFormInstanceRecordVersionLocalService.getFormInstanceRecordVersion(classPK);
        DDMFormInstanceRecord formInstanceRecord = formInstanceRecordVersion.getFormInstanceRecord();
        return this._workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(companyId, groupId, DDMFormInstance.class.getName(), formInstanceRecord.getFormInstanceId(), 0L);
    }

    public boolean isVisible() {
        return false;
    }

    public DDMFormInstanceRecord updateStatus(int status, Map<String, Serializable> workflowContext) throws PortalException {
        long userId = GetterUtil.getLong((String)((String)((Object)workflowContext.get("userId"))));
        long classPK = GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK"))));
        ServiceContext serviceContext = (ServiceContext)workflowContext.get("serviceContext");
        return this._ddmFormInstanceRecordLocalService.updateStatus(userId, classPK, status, serviceContext);
    }
}

