/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesMerger;
import com.liferay.dynamic.data.mapping.util.NumericDDMFormFieldUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={DDMFormValuesMerger.class})
public class DDMFormValuesMergerImpl
implements DDMFormValuesMerger {
    public DDMFormValues merge(DDMFormValues newDDMFormValues, DDMFormValues existingDDMFormValues) {
        ArrayList<DDMFormFieldValue> newDDMFormFieldValues = new ArrayList<DDMFormFieldValue>(newDDMFormValues.getDDMFormFieldValues());
        for (DDMFormFieldValue ddmFormFieldValue : newDDMFormValues.getDDMFormFieldValues()) {
            newDDMFormFieldValues.addAll(ddmFormFieldValue.getNestedDDMFormFieldValues());
        }
        List<DDMFormFieldValue> mergedDDMFormFieldValues = this.mergeDDMFormFieldValues(newDDMFormFieldValues, existingDDMFormValues.getDDMFormFieldValues());
        existingDDMFormValues.setDDMFormFieldValues(mergedDDMFormFieldValues);
        return existingDDMFormValues;
    }

    protected DDMFormFieldValue getDDMFormFieldValueByName(List<DDMFormFieldValue> ddmFormFieldValues, String name) {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            if (!name.equals(ddmFormFieldValue.getName())) continue;
            return ddmFormFieldValue;
        }
        return null;
    }

    protected List<DDMFormFieldValue> mergeDDMFormFieldValues(List<DDMFormFieldValue> newDDMFormFieldValues, List<DDMFormFieldValue> existingDDMFormFieldValues) {
        ArrayList<DDMFormFieldValue> mergedDDMFormFieldValues = new ArrayList<DDMFormFieldValue>(existingDDMFormFieldValues);
        for (DDMFormFieldValue newDDMFormFieldValue : newDDMFormFieldValues) {
            DDMFormValues ddmFormValues = newDDMFormFieldValue.getDDMFormValues();
            DDMFormFieldValue actualDDMFormFieldValue = this.getDDMFormFieldValueByName(existingDDMFormFieldValues, newDDMFormFieldValue.getName());
            if (actualDDMFormFieldValue != null) {
                DDMForm ddmForm = ddmFormValues.getDDMForm();
                Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
                Collection ddmFormFields = ddmFormFieldsMap.values();
                Stream stream = ddmFormFields.stream();
                DDMFormField ddmFormField = stream.filter(p -> p.getName().equals(newDDMFormFieldValue.getName())).findFirst().orElseGet(() -> null);
                this.mergeValue(newDDMFormFieldValue.getValue(), actualDDMFormFieldValue.getValue(), ddmFormField);
                List<DDMFormFieldValue> mergedNestedDDMFormFieldValues = this.mergeDDMFormFieldValues(newDDMFormFieldValue.getNestedDDMFormFieldValues(), actualDDMFormFieldValue.getNestedDDMFormFieldValues());
                newDDMFormFieldValue.setNestedDDMFormFields(mergedNestedDDMFormFieldValues);
                existingDDMFormFieldValues.remove(actualDDMFormFieldValue);
                mergedDDMFormFieldValues.remove(actualDDMFormFieldValue);
            }
            mergedDDMFormFieldValues.add(newDDMFormFieldValue);
        }
        return mergedDDMFormFieldValues;
    }

    protected void mergeValue(Value newValue, Value existingValue, DDMFormField ddmFormField) {
        if (newValue == null || existingValue == null) {
            return;
        }
        for (Locale locale : existingValue.getAvailableLocales()) {
            String value = newValue.getString(locale);
            if (StringUtil.equals((String)ddmFormField.getDataType(), (String)"double") && !GetterUtil.getBoolean((Object)ddmFormField.getProperty("inputMask"))) {
                DecimalFormat decimalFormat = NumericDDMFormFieldUtil.getDecimalFormat((Locale)locale);
                newValue.addString(locale, decimalFormat.format(GetterUtil.getDouble((String)value, (Locale)newValue.getDefaultLocale())));
            }
            if (value != null) continue;
            newValue.addString(locale, existingValue.getString(locale));
        }
    }
}

