/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v4_3_4;

import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class DDMStructureLinkDLFileEntryTypeUpgradeProcess
extends UpgradeProcess {
    private final DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;

    public DDMStructureLinkDLFileEntryTypeUpgradeProcess(DLFileEntryTypeLocalService dlFileEntryTypeLocalService) {
        this._dlFileEntryTypeLocalService = dlFileEntryTypeLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._fixDataDefinitionIdFields();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _fixDataDefinitionIdFields() throws Exception {
        StringBuilder sb = new StringBuilder(5);
        sb.append("select DLFileEntryType.uuid_, fileEntryTypeId, ");
        sb.append("DLFileEntryType.groupId, DLFileEntryType.companyId, ");
        sb.append("dataDefinitionId, fileEntryTypeKey from DLFileEntryType ");
        sb.append("inner join DDMStructure ON dataDefinitionId = structureId ");
        sb.append("where type_ = 0");
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement preparedStatement2 = this.connection.prepareStatement("select structureId FROM DDMStructure where groupId = ? AND classNameId = ? AND (structureKey = ? OR structureKey = ? OR structureKey = ? ) ");
             PreparedStatement preparedStatement3 = this.connection.prepareStatement("select structureLinkId from DDMStructureLink where companyId = ? and classNameId = ? and classPK = ? and structureId = ?");
             PreparedStatement preparedStatement4 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("insert into DDMStructureLink (structureLinkId, companyId, classNameId, classPK, structureId) values (?, ?, ?, ?, ?)"));
             ResultSet resultSet1 = preparedStatement1.executeQuery();){
            while (resultSet1.next()) {
                long fileEntryTypeId = resultSet1.getLong(2);
                preparedStatement2.setLong(1, resultSet1.getLong(3));
                preparedStatement2.setLong(2, PortalUtil.getClassNameId(DLFileEntryMetadata.class));
                preparedStatement2.setString(3, DLUtil.getDDMStructureKey((String)resultSet1.getString(1)));
                preparedStatement2.setString(4, DLUtil.getDeprecatedDDMStructureKey((long)fileEntryTypeId));
                preparedStatement2.setString(5, resultSet1.getString(4));
                try (ResultSet resultSet2 = preparedStatement2.executeQuery();){
                    if (resultSet2.next()) {
                        long structureId = resultSet2.getLong(1);
                        ActionableDynamicQuery actionableDynamicQuery = this._dlFileEntryTypeLocalService.getActionableDynamicQuery();
                        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"fileEntryTypeId", (Object)fileEntryTypeId)));
                        actionableDynamicQuery.setPerformActionMethod(dlFileEntryType -> {
                            dlFileEntryType.setDataDefinitionId(structureId);
                            this._dlFileEntryTypeLocalService.updateDLFileEntryType(dlFileEntryType);
                        });
                        actionableDynamicQuery.performActions();
                    }
                }
                long companyId = resultSet1.getLong(4);
                preparedStatement3.setLong(1, companyId);
                preparedStatement3.setLong(2, PortalUtil.getClassNameId(DLFileEntryType.class));
                preparedStatement3.setLong(3, fileEntryTypeId);
                long dataDefinitionId = resultSet1.getLong(5);
                preparedStatement3.setLong(4, dataDefinitionId);
                ResultSet resultSet3 = preparedStatement3.executeQuery();
                Throwable throwable = null;
                try {
                    if (resultSet3.next()) continue;
                    preparedStatement4.setLong(1, this.increment());
                    preparedStatement4.setLong(2, companyId);
                    preparedStatement4.setLong(3, PortalUtil.getClassNameId(DLFileEntryType.class));
                    preparedStatement4.setLong(4, fileEntryTypeId);
                    preparedStatement4.setLong(5, dataDefinitionId);
                    preparedStatement4.addBatch();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (resultSet3 == null) continue;
                    if (throwable != null) {
                        try {
                            resultSet3.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    resultSet3.close();
                    continue;
                }
                preparedStatement4.executeBatch();
            }
            return;
        }
    }
}

