/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_10_2;

import com.liferay.dynamic.data.mapping.internal.upgrade.v3_10_2.util.DDMFormFieldUpgradeProcessUtil;
import com.liferay.dynamic.data.mapping.internal.util.ExpressionParameterValueExtractor;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidationExpression;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.util.DDMFormDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormLayoutDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormSerializeUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DDMStructureUpgradeProcess
extends UpgradeProcess {
    private final DDMFormDeserializer _ddmFormDeserializer;
    private final DDMFormLayoutDeserializer _ddmFormLayoutDeserializer;
    private final DDMFormLayoutSerializer _ddmFormLayoutSerializer;
    private final DDMFormSerializer _ddmFormSerializer;
    private final JSONFactory _jsonFactory;

    public DDMStructureUpgradeProcess(DDMFormDeserializer ddmFormDeserializer, DDMFormLayoutDeserializer ddmFormLayoutDeserializer, DDMFormLayoutSerializer ddmFormLayoutSerializer, DDMFormSerializer ddmFormSerializer, JSONFactory jsonFactory) {
        this._ddmFormDeserializer = ddmFormDeserializer;
        this._ddmFormLayoutDeserializer = ddmFormLayoutDeserializer;
        this._ddmFormLayoutSerializer = ddmFormLayoutSerializer;
        this._ddmFormSerializer = ddmFormSerializer;
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeDDMStructureLayout();
        this._upgradeDDMStructureVersion();
        this._upgradeDDMStructure();
    }

    protected String upgradeDDMStructureLayoutDefinition(String definition) throws Exception {
        DDMFormLayout ddmFormLayout = DDMFormLayoutDeserializeUtil.deserialize((DDMFormLayoutDeserializer)this._ddmFormLayoutDeserializer, (String)definition);
        this._normalizeDDMFormLayout(ddmFormLayout);
        DDMFormLayoutSerializerSerializeResponse ddmFormLayoutSerializerSerializeResponse = this._ddmFormLayoutSerializer.serialize(DDMFormLayoutSerializerSerializeRequest.Builder.newBuilder((DDMFormLayout)ddmFormLayout).build());
        return ddmFormLayoutSerializerSerializeResponse.getContent();
    }

    protected String upgradeDDMStructureVersionDefinition(String definition) throws Exception {
        DDMForm ddmForm = DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._ddmFormDeserializer, (String)definition);
        this._normalizeDDMFormRules(ddmForm);
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            this._normalizeDDMFormField(ddmFormField);
        }
        return DDMFormSerializeUtil.serialize((DDMForm)ddmForm, (DDMFormSerializer)this._ddmFormSerializer);
    }

    private List<String> _getNormalizedDDMFormFieldNames(List<String> ddmFormFieldNames) {
        Stream stream = ddmFormFieldNames.stream();
        return stream.map(ddmFormFieldName -> DDMFormFieldUpgradeProcessUtil.getNormalizedName(ddmFormFieldName)).collect(Collectors.toList());
    }

    private String _getNormalizedDDMFormRuleExpression(Map<String, DDMFormField> ddmFormFieldsMap, String ddmFormRuleExpression) {
        StringBundler sb = new StringBundler();
        List<String> parameterValues = ExpressionParameterValueExtractor.extractParameterValues(ddmFormRuleExpression);
        for (int i = 0; i < parameterValues.size(); ++i) {
            String parameterValue = parameterValues.get(i);
            String unquotedParameterValue = StringUtil.unquote((String)parameterValue);
            if (!ddmFormFieldsMap.containsKey(unquotedParameterValue) && (i <= 0 || !this._isDDMFormFieldOptionValue(ddmFormFieldsMap, unquotedParameterValue, StringUtil.unquote((String)parameterValues.get(i - 1))))) continue;
            int index = ddmFormRuleExpression.indexOf(parameterValue);
            sb.append(ddmFormRuleExpression.substring(0, index));
            sb.append(StringUtil.replace((String)parameterValue, (String)unquotedParameterValue, (String)DDMFormFieldUpgradeProcessUtil.getNormalizedName(unquotedParameterValue)));
            ddmFormRuleExpression = ddmFormRuleExpression.substring(index + parameterValue.length());
        }
        sb.append(ddmFormRuleExpression);
        return sb.toString();
    }

    private boolean _isDDMFormFieldOptionValue(Map<String, DDMFormField> ddmFormFieldsMap, String operand, String previousOperand) {
        DDMFormField ddmFormField = ddmFormFieldsMap.get(previousOperand);
        if (ddmFormField == null || !DDMFormFieldUpgradeProcessUtil.isDDMFormFieldWithOptions(ddmFormField.getType())) {
            return false;
        }
        DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
        if (ddmFormFieldOptions == null) {
            return false;
        }
        Set ddmFormFieldOptionsValues = ddmFormFieldOptions.getOptionsValues();
        return ddmFormFieldOptionsValues.contains(operand);
    }

    private void _normalizeDDMFormField(DDMFormField ddmFormField) throws Exception {
        if (StringUtil.equals((String)ddmFormField.getType(), (String)"fieldset")) {
            this._normalizeDDMFormFieldFieldset(ddmFormField);
        }
        this._normalizeDDMFormFieldOptions(ddmFormField);
        this._normalizeDDMFormFieldValidationExpression(ddmFormField.getDDMFormFieldValidation(), ddmFormField.getName());
        if (DDMFormFieldUpgradeProcessUtil.isDDMFormFieldWithOptions(ddmFormField.getType())) {
            this._normalizePredefinedValue(ddmFormField.getPredefinedValue());
        }
        ddmFormField.setFieldReference(DDMFormFieldUpgradeProcessUtil.getNormalizedName(ddmFormField.getFieldReference()));
        ddmFormField.setName(DDMFormFieldUpgradeProcessUtil.getNormalizedName(ddmFormField.getName()));
        for (DDMFormField nestedDDMFormField : ddmFormField.getNestedDDMFormFields()) {
            this._normalizeDDMFormField(nestedDDMFormField);
        }
    }

    private void _normalizeDDMFormFieldFieldset(DDMFormField ddmFormField) throws Exception {
        JSONArray rowsJSONArray = this._jsonFactory.createJSONArray(GetterUtil.getString((Object)ddmFormField.getProperty("rows")));
        for (int i = 0; i < rowsJSONArray.length(); ++i) {
            JSONObject rowJSONObject = rowsJSONArray.getJSONObject(i);
            JSONArray columnsJSONArray = rowJSONObject.getJSONArray("columns");
            for (int j = 0; j < columnsJSONArray.length(); ++j) {
                JSONObject columnJSONObject = columnsJSONArray.getJSONObject(j);
                columnJSONObject.put("fields", DDMFormFieldUpgradeProcessUtil.getNormalizedJSONArray(columnJSONObject.getJSONArray("fields")));
            }
        }
        ddmFormField.setProperty("rows", (Object)rowsJSONArray);
    }

    private void _normalizeDDMFormFieldOptions(DDMFormField ddmFormField) throws Exception {
        DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
        if (ddmFormFieldOptions == null) {
            return;
        }
        DDMFormFieldOptions normalizedDDMFormFieldOptions = new DDMFormFieldOptions(ddmFormFieldOptions.getDefaultLocale());
        Map normalizedOptions = normalizedDDMFormFieldOptions.getOptions();
        Map normalizedOptionsReferences = normalizedDDMFormFieldOptions.getOptionsReferences();
        for (String optionValue : ddmFormFieldOptions.getOptionsValues()) {
            String normalizedOptionValue = DDMFormFieldUpgradeProcessUtil.getNormalizedName(optionValue);
            normalizedOptions.put(normalizedOptionValue, ddmFormFieldOptions.getOptionLabels(optionValue));
            normalizedOptionsReferences.put(normalizedOptionValue, DDMFormFieldUpgradeProcessUtil.getNormalizedName(ddmFormFieldOptions.getOptionReference(optionValue)));
        }
        ddmFormField.setDDMFormFieldOptions(normalizedDDMFormFieldOptions);
    }

    private void _normalizeDDMFormFieldValidationExpression(DDMFormFieldValidation ddmFormFieldValidation, String ddmFormFieldName) throws Exception {
        if (ddmFormFieldValidation == null) {
            return;
        }
        DDMFormFieldValidationExpression ddmFormFieldValidationExpression = ddmFormFieldValidation.getDDMFormFieldValidationExpression();
        String ddmFormFieldValidationExpressionValue = ddmFormFieldValidationExpression.getValue();
        if (!ddmFormFieldValidationExpressionValue.contains(ddmFormFieldName)) {
            return;
        }
        ddmFormFieldValidationExpression.setValue(StringUtil.replace((String)ddmFormFieldValidationExpressionValue, (String)ddmFormFieldName, (String)DDMFormFieldUpgradeProcessUtil.getNormalizedName(ddmFormFieldName)));
    }

    private void _normalizeDDMFormLayout(DDMFormLayout ddmFormLayout) {
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayout.getDDMFormLayoutPages()) {
            for (DDMFormLayoutRow ddmFormLayoutRow : ddmFormLayoutPage.getDDMFormLayoutRows()) {
                for (DDMFormLayoutColumn ddmFormLayoutColumn : ddmFormLayoutRow.getDDMFormLayoutColumns()) {
                    List ddmFormFieldNames = ddmFormLayoutColumn.getDDMFormFieldNames();
                    if (ddmFormFieldNames.isEmpty()) continue;
                    ddmFormLayoutColumn.setDDMFormFieldNames(this._getNormalizedDDMFormFieldNames(ddmFormFieldNames));
                }
            }
        }
    }

    private void _normalizeDDMFormRuleActions(Map<String, DDMFormField> ddmFormFieldsMap, DDMFormRule ddmFormRule) {
        ArrayList<String> normalizedDDMFormRuleActions = new ArrayList<String>();
        for (String ddmFormRuleAction : ddmFormRule.getActions()) {
            normalizedDDMFormRuleActions.add(this._getNormalizedDDMFormRuleExpression(ddmFormFieldsMap, ddmFormRuleAction));
        }
        ddmFormRule.setActions(normalizedDDMFormRuleActions);
    }

    private void _normalizeDDMFormRules(DDMForm ddmForm) throws Exception {
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        for (DDMFormRule ddmFormRule : ddmForm.getDDMFormRules()) {
            this._normalizeDDMFormRuleActions(ddmFormFieldsMap, ddmFormRule);
            ddmFormRule.setCondition(this._getNormalizedDDMFormRuleExpression(ddmFormFieldsMap, ddmFormRule.getCondition()));
        }
    }

    private void _normalizePredefinedValue(LocalizedValue localizedValue) throws Exception {
        if (localizedValue == null) {
            return;
        }
        HashSet availableLocales = new HashSet(localizedValue.getAvailableLocales());
        for (Locale availableLocale : availableLocales) {
            localizedValue.addString(availableLocale, String.valueOf(DDMFormFieldUpgradeProcessUtil.getNormalizedJSONArray(this._jsonFactory.createJSONArray(localizedValue.getString(availableLocale)))));
        }
    }

    private void _upgradeDDMStructure() throws Exception {
        try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMStructure.structureId, ", "DDMStructureVersion.definition from DDMStructure ", "inner join DDMStructureVersion on ", "DDMStructure.structureid = ", "DDMStructureVersion.structureid where ", "DDMStructure.version = DDMStructureVersion.version ", "and DDMStructure.classNameId = ?"}));
             PreparedStatement updatePreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");){
            selectPreparedStatement.setLong(1, PortalUtil.getClassNameId((String)DDMFormInstance.class.getName()));
            try (ResultSet resultSet = selectPreparedStatement.executeQuery();){
                while (resultSet.next()) {
                    updatePreparedStatement.setString(1, resultSet.getString("definition"));
                    updatePreparedStatement.setLong(2, resultSet.getLong("structureId"));
                    updatePreparedStatement.addBatch();
                }
                updatePreparedStatement.executeBatch();
            }
        }
    }

    private void _upgradeDDMStructureLayout() throws Exception {
        try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMStructureLayout.structureLayoutId, ", "DDMStructureLayout.definition from ", "DDMStructureLayout inner join DDMStructureVersion on ", "DDMStructureLayout.structureVersionId = ", "DDMStructureVersion.structureVersionId inner join ", "DDMStructure on DDMStructure.structureId = ", "DDMStructureVersion.structureId where ", "DDMStructure.classNameId = ?"}));
             PreparedStatement updatePreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureLayout set definition = ? where structureLayoutId = ?");){
            selectPreparedStatement.setLong(1, PortalUtil.getClassNameId((String)DDMFormInstance.class.getName()));
            try (ResultSet resultSet = selectPreparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String newDefinition;
                    String definition = resultSet.getString("definition");
                    if (StringUtil.equals((String)definition, (String)(newDefinition = this.upgradeDDMStructureLayoutDefinition(definition)))) continue;
                    updatePreparedStatement.setString(1, newDefinition);
                    updatePreparedStatement.setLong(2, resultSet.getLong("structureLayoutId"));
                    updatePreparedStatement.addBatch();
                }
                updatePreparedStatement.executeBatch();
            }
        }
    }

    private void _upgradeDDMStructureVersion() throws Exception {
        try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMStructureVersion.structureVersionId, ", "DDMStructureVersion.definition from DDMStructure ", "inner join DDMStructureVersion on ", "DDMStructure.structureId = ", "DDMStructureVersion.structureId where ", "DDMStructure.classNameId = ?"}));
             PreparedStatement updatePreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureVersionId = ?");){
            selectPreparedStatement.setLong(1, PortalUtil.getClassNameId((String)DDMFormInstance.class.getName()));
            try (ResultSet resultSet = selectPreparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String newDefinition;
                    String definition = resultSet.getString("definition");
                    if (StringUtil.equals((String)definition, (String)(newDefinition = this.upgradeDDMStructureVersionDefinition(definition)))) continue;
                    updatePreparedStatement.setString(1, newDefinition);
                    updatePreparedStatement.setLong(2, resultSet.getLong("structureVersionId"));
                    updatePreparedStatement.addBatch();
                }
                updatePreparedStatement.executeBatch();
            }
        }
    }
}

