/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v1_1_0;

import com.liferay.dynamic.data.mapping.internal.util.ExpressionParameterValueExtractor;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.util.DDMFormDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormSerializeUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class DDMStructureUpgradeProcess
extends UpgradeProcess {
    private final DDMFormDeserializer _ddmFormDeserializer;
    private final DDMFormSerializer _ddmFormSerializer;

    public DDMStructureUpgradeProcess(DDMFormDeserializer ddmFormDeserializer, DDMFormSerializer ddmFormSerializer) {
        this._ddmFormDeserializer = ddmFormDeserializer;
        this._ddmFormSerializer = ddmFormSerializer;
    }

    protected void doUpgrade() throws Exception {
        this.upgradeDDMStructureDefinition();
        this.upgradeDDMStructureVersionDefinition();
    }

    protected String updateDefinition(String definition) throws Exception {
        DDMForm ddmForm = DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._ddmFormDeserializer, (String)definition);
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        List ddmFormRules = ddmForm.getDDMFormRules();
        for (DDMFormField ddmFormField : ddmFormFieldsMap.values()) {
            String visibilityExpression = ddmFormField.getVisibilityExpression();
            if (Validator.isNull((String)visibilityExpression)) continue;
            visibilityExpression = this._convertExpression(ddmFormFieldsMap, visibilityExpression);
            DDMFormRule ddmFormRule = new DDMFormRule(Arrays.asList("setVisible('" + ddmFormField.getName() + "', true)"), visibilityExpression);
            ddmFormRules.add(ddmFormRule);
            ddmFormField.setVisibilityExpression("");
        }
        ddmForm.setDDMFormRules(ddmFormRules);
        return DDMFormSerializeUtil.serialize((DDMForm)ddmForm, (DDMFormSerializer)this._ddmFormSerializer);
    }

    protected void upgradeDDMStructureDefinition() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select DDMStructure.definition, DDMStructure.structureId from DDMStructure");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                String definition = resultSet.getString(1);
                long structureId = resultSet.getLong(2);
                String newDefinition = this.updateDefinition(definition);
                preparedStatement2.setString(1, newDefinition);
                preparedStatement2.setLong(2, structureId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    protected void upgradeDDMStructureVersionDefinition() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMStructureVersion.definition, ", "DDMStructureVersion.structureVersionId from ", "DDMStructureVersion"}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureVersionId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                String definition = resultSet.getString(1);
                long structureVersionId = resultSet.getLong(2);
                String newDefinition = this.updateDefinition(definition);
                preparedStatement2.setString(1, newDefinition);
                preparedStatement2.setLong(2, structureVersionId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    private String _convertExpression(Map<String, DDMFormField> ddmFormFieldsMap, String visibilityExpression) {
        StringBundler sb1 = new StringBundler();
        List<String> parameterValues = ExpressionParameterValueExtractor.extractParameterValues(visibilityExpression);
        for (String parameterValue : parameterValues) {
            String unquotedParameterValue = StringUtil.unquote((String)parameterValue);
            if (!ddmFormFieldsMap.containsKey(unquotedParameterValue)) continue;
            int index = visibilityExpression.indexOf(parameterValue);
            sb1.append(visibilityExpression.substring(0, index));
            sb1.append(StringBundler.concat((String[])new String[]{"getValue(", StringUtil.quote((String)unquotedParameterValue), ")"}));
            visibilityExpression = visibilityExpression.substring(index + parameterValue.length());
        }
        sb1.append(visibilityExpression);
        return sb1.toString();
    }
}

