/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v1_1_0;

import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldValueTransformer;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesSerializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesTransformer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;

public class CheckboxFieldToCheckboxMultipleFieldUpgradeProcess
extends UpgradeProcess {
    private static final int _SCOPE_FORMS = 2;
    private final DDMFormDeserializer _ddmFormDeserializer;
    private final DDMFormValuesDeserializer _ddmFormValuesDeserializer;
    private final DDMFormValuesSerializer _ddmFormValuesSerializer;
    private final JSONFactory _jsonFactory;

    public CheckboxFieldToCheckboxMultipleFieldUpgradeProcess(DDMFormDeserializer ddmFormDeserializer, DDMFormValuesDeserializer ddmFormValuesDeserializer, DDMFormValuesSerializer ddmFormValuesSerializer, JSONFactory jsonFactory) {
        this._ddmFormDeserializer = ddmFormDeserializer;
        this._ddmFormValuesDeserializer = ddmFormValuesDeserializer;
        this._ddmFormValuesSerializer = ddmFormValuesSerializer;
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMStructure.definition, DDMStructure.version, ", "DDMStructure.structureId, DDLRecordSet.recordSetId from ", "DDLRecordSet inner join DDMStructure on ", "DDLRecordSet.DDMStructureId = DDMStructure.structureId ", "where DDLRecordSet.scope = ? and DDMStructure.definition ", "like ?"}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureId = ? and version = ?");){
            preparedStatement1.setInt(1, 2);
            preparedStatement1.setString(2, "%checkbox%");
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    String definition = resultSet.getString(1);
                    String version = resultSet.getString(2);
                    long structureId = resultSet.getLong(3);
                    long recordSetId = resultSet.getLong(4);
                    String newDefinition = this.upgradeRecordSetStructureDefinition(definition);
                    preparedStatement2.setString(1, newDefinition);
                    preparedStatement2.setLong(2, structureId);
                    preparedStatement2.addBatch();
                    preparedStatement3.setString(1, newDefinition);
                    preparedStatement3.setLong(2, structureId);
                    preparedStatement3.setString(3, version);
                    preparedStatement3.addBatch();
                    this.updateRecords(DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._ddmFormDeserializer, (String)definition), recordSetId);
                }
                preparedStatement2.executeBatch();
                preparedStatement3.executeBatch();
            }
        }
    }

    protected JSONArray getOptionsJSONArray(JSONObject checkboxFieldJSONObject) {
        return JSONUtil.putAll((Object[])new Object[]{JSONUtil.put((String)"label", (Object)checkboxFieldJSONObject.getJSONObject("label")).put("value", checkboxFieldJSONObject.getString("name"))});
    }

    protected JSONObject getPredefinedValueJSONObject(JSONObject checkboxFieldJSONObject) {
        JSONObject oldPredefinedValueJSONObject = checkboxFieldJSONObject.getJSONObject("predefinedValue");
        JSONObject newPredefinedValueJSONObject = this._jsonFactory.createJSONObject();
        Iterator iterator = oldPredefinedValueJSONObject.keys();
        while (iterator.hasNext()) {
            String languageKey = (String)iterator.next();
            String predefinedValue = oldPredefinedValueJSONObject.getString(languageKey);
            predefinedValue = Objects.equals(predefinedValue, "true") ? checkboxFieldJSONObject.getString("name") : "";
            newPredefinedValueJSONObject.put(languageKey, predefinedValue);
        }
        return newPredefinedValueJSONObject;
    }

    protected void transformCheckboxDDMFormField(JSONObject checkboxFieldJSONObject) {
        checkboxFieldJSONObject.put("dataType", "string").put("options", this.getOptionsJSONArray(checkboxFieldJSONObject)).put("predefinedValue", this.getPredefinedValueJSONObject(checkboxFieldJSONObject)).put("type", "checkbox_multiple");
    }

    protected void transformCheckboxDDMFormFieldValues(DDMFormValues ddmFormValues) throws Exception {
        DDMFormValuesTransformer ddmFormValuesTransformer = new DDMFormValuesTransformer(ddmFormValues);
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)new CheckboxDDMFormFieldValueTransformer(this._jsonFactory));
        ddmFormValuesTransformer.transform();
    }

    protected void updateRecords(DDMForm ddmForm, long recordSetId) throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDLRecordVersion.DDMStorageId, DDMContent.data_ ", "from DDLRecordVersion inner join DDLRecordSet on ", "DDLRecordVersion.recordSetId = DDLRecordSet.recordSetId ", "inner join DDMContent on DDLRecordVersion.DDMStorageId = ", "DDMContent.contentId where DDLRecordSet.recordSetId = ?"}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMContent set data_ = ? where contentId = ? ");){
            preparedStatement1.setLong(1, recordSetId);
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    String data_ = resultSet.getString("data_");
                    DDMFormValues ddmFormValues = DDMFormValuesDeserializeUtil.deserialize((String)data_, (DDMForm)ddmForm, (DDMFormValuesDeserializer)this._ddmFormValuesDeserializer);
                    this.transformCheckboxDDMFormFieldValues(ddmFormValues);
                    preparedStatement2.setString(1, DDMFormValuesSerializeUtil.serialize((DDMFormValues)ddmFormValues, (DDMFormValuesSerializer)this._ddmFormValuesSerializer));
                    long contentId = resultSet.getLong("DDMStorageId");
                    preparedStatement2.setLong(2, contentId);
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
        }
    }

    protected String upgradeRecordSetStructureDefinition(String definition) throws JSONException {
        JSONObject definitionJSONObject = this._jsonFactory.createJSONObject(definition);
        JSONArray fieldsJSONArray = definitionJSONObject.getJSONArray("fields");
        this.upgradeRecordSetStructureFields(fieldsJSONArray);
        return definitionJSONObject.toString();
    }

    protected void upgradeRecordSetStructureFields(JSONArray fieldsJSONArray) {
        for (int i = 0; i < fieldsJSONArray.length(); ++i) {
            JSONArray nestedFieldsJSONArray;
            JSONObject fieldJSONObject = fieldsJSONArray.getJSONObject(i);
            String type = fieldJSONObject.getString("type");
            if (type.equals("checkbox")) {
                this.transformCheckboxDDMFormField(fieldJSONObject);
            }
            if ((nestedFieldsJSONArray = fieldJSONObject.getJSONArray("nestedFields")) == null) continue;
            this.upgradeRecordSetStructureFields(nestedFieldsJSONArray);
        }
    }

    private static class CheckboxDDMFormFieldValueTransformer
    implements DDMFormFieldValueTransformer {
        private JSONFactory _jsonFactory;

        public CheckboxDDMFormFieldValueTransformer(JSONFactory jsonFactory) {
            this._jsonFactory = jsonFactory;
        }

        public String getFieldType() {
            return "checkbox";
        }

        public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
            Value value = ddmFormFieldValue.getValue();
            for (Locale locale : value.getAvailableLocales()) {
                String valueString = value.getString(locale);
                JSONArray valueJSONArray = this._jsonFactory.createJSONArray();
                if (Objects.equals(valueString, "true")) {
                    DDMFormField ddmFormField = ddmFormFieldValue.getDDMFormField();
                    valueJSONArray.put(ddmFormField.getName());
                }
                value.addString(locale, valueJSONArray.toString());
            }
        }
    }
}

