/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.persistence.impl;

import com.liferay.dynamic.data.mapping.exception.NoSuchStructureLinkException;
import com.liferay.dynamic.data.mapping.model.DDMStructureLink;
import com.liferay.dynamic.data.mapping.model.DDMStructureLinkTable;
import com.liferay.dynamic.data.mapping.model.impl.DDMStructureLinkImpl;
import com.liferay.dynamic.data.mapping.model.impl.DDMStructureLinkModelImpl;
import com.liferay.dynamic.data.mapping.service.persistence.DDMStructureLinkPersistence;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.helper.CTPersistenceHelper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDMStructureLinkPersistence.class, BasePersistence.class})
public class DDMStructureLinkPersistenceImpl
extends BasePersistenceImpl<DDMStructureLink>
implements DDMStructureLinkPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = DDMStructureLinkImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByStructureId;
    private FinderPath _finderPathWithoutPaginationFindByStructureId;
    private FinderPath _finderPathCountByStructureId;
    private static final String _FINDER_COLUMN_STRUCTUREID_STRUCTUREID_2 = "ddmStructureLink.structureId = ?";
    private FinderPath _finderPathWithPaginationFindByC_C;
    private FinderPath _finderPathWithoutPaginationFindByC_C;
    private FinderPath _finderPathCountByC_C;
    private static final String _FINDER_COLUMN_C_C_CLASSNAMEID_2 = "ddmStructureLink.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_CLASSPK_2 = "ddmStructureLink.classPK = ?";
    private FinderPath _finderPathFetchByC_C_S;
    private FinderPath _finderPathCountByC_C_S;
    private static final String _FINDER_COLUMN_C_C_S_CLASSNAMEID_2 = "ddmStructureLink.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_S_CLASSPK_2 = "ddmStructureLink.classPK = ? AND ";
    private static final String _FINDER_COLUMN_C_C_S_STRUCTUREID_2 = "ddmStructureLink.structureId = ?";
    private static final Map<CTColumnResolutionType, Set<String>> _ctColumnNamesMap = new EnumMap<CTColumnResolutionType, Set<String>>(CTColumnResolutionType.class);
    private static final List<String> _mappingTableNames = new ArrayList<String>();
    private static final List<String[]> _uniqueIndexColumnNames = new ArrayList<String[]>();
    private BundleContext _bundleContext;
    @Reference
    protected CTPersistenceHelper ctPersistenceHelper;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_DDMSTRUCTURELINK = "SELECT ddmStructureLink FROM DDMStructureLink ddmStructureLink";
    private static final String _SQL_SELECT_DDMSTRUCTURELINK_WHERE = "SELECT ddmStructureLink FROM DDMStructureLink ddmStructureLink WHERE ";
    private static final String _SQL_COUNT_DDMSTRUCTURELINK = "SELECT COUNT(ddmStructureLink) FROM DDMStructureLink ddmStructureLink";
    private static final String _SQL_COUNT_DDMSTRUCTURELINK_WHERE = "SELECT COUNT(ddmStructureLink) FROM DDMStructureLink ddmStructureLink WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "ddmStructureLink.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No DDMStructureLink exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No DDMStructureLink exists with the key {";
    private static final Log _log;
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<DDMStructureLink> findByStructureId(long structureId) {
        return this.findByStructureId(structureId, -1, -1, null);
    }

    public List<DDMStructureLink> findByStructureId(long structureId, int start, int end) {
        return this.findByStructureId(structureId, start, end, null);
    }

    public List<DDMStructureLink> findByStructureId(long structureId, int start, int end, OrderByComparator<DDMStructureLink> orderByComparator) {
        return this.findByStructureId(structureId, start, end, orderByComparator, true);
    }

    public List<DDMStructureLink> findByStructureId(long structureId, int start, int end, OrderByComparator<DDMStructureLink> orderByComparator, boolean useFinderCache) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMStructureLink.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindByStructureId;
                finderArgs = new Object[]{structureId};
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindByStructureId;
            finderArgs = new Object[]{structureId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (DDMStructureLink ddmStructureLink : list) {
                if (structureId == ddmStructureLink.getStructureId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_DDMSTRUCTURELINK_WHERE);
            sb.append("ddmStructureLink.structureId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY ddmStructureLink.structureLinkId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(structureId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DDMStructureLink findByStructureId_First(long structureId, OrderByComparator<DDMStructureLink> orderByComparator) throws NoSuchStructureLinkException {
        DDMStructureLink ddmStructureLink = this.fetchByStructureId_First(structureId, orderByComparator);
        if (ddmStructureLink != null) {
            return ddmStructureLink;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("structureId=");
        sb.append(structureId);
        sb.append("}");
        throw new NoSuchStructureLinkException(sb.toString());
    }

    public DDMStructureLink fetchByStructureId_First(long structureId, OrderByComparator<DDMStructureLink> orderByComparator) {
        List<DDMStructureLink> list = this.findByStructureId(structureId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMStructureLink findByStructureId_Last(long structureId, OrderByComparator<DDMStructureLink> orderByComparator) throws NoSuchStructureLinkException {
        DDMStructureLink ddmStructureLink = this.fetchByStructureId_Last(structureId, orderByComparator);
        if (ddmStructureLink != null) {
            return ddmStructureLink;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("structureId=");
        sb.append(structureId);
        sb.append("}");
        throw new NoSuchStructureLinkException(sb.toString());
    }

    public DDMStructureLink fetchByStructureId_Last(long structureId, OrderByComparator<DDMStructureLink> orderByComparator) {
        int count = this.countByStructureId(structureId);
        if (count == 0) {
            return null;
        }
        List<DDMStructureLink> list = this.findByStructureId(structureId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMStructureLink[] findByStructureId_PrevAndNext(long structureLinkId, long structureId, OrderByComparator<DDMStructureLink> orderByComparator) throws NoSuchStructureLinkException {
        DDMStructureLink ddmStructureLink = this.findByPrimaryKey(structureLinkId);
        Session session = null;
        try {
            session = this.openSession();
            DDMStructureLink[] array = new DDMStructureLinkImpl[]{this.getByStructureId_PrevAndNext(session, ddmStructureLink, structureId, orderByComparator, true), ddmStructureLink, this.getByStructureId_PrevAndNext(session, ddmStructureLink, structureId, orderByComparator, false)};
            DDMStructureLink[] dDMStructureLinkArray = array;
            return dDMStructureLinkArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDMStructureLink getByStructureId_PrevAndNext(Session session, DDMStructureLink ddmStructureLink, long structureId, OrderByComparator<DDMStructureLink> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_DDMSTRUCTURELINK_WHERE);
        sb.append("ddmStructureLink.structureId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY ddmStructureLink.structureLinkId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(structureId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ddmStructureLink)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (DDMStructureLink)list.get(1);
        }
        return null;
    }

    public void removeByStructureId(long structureId) {
        for (DDMStructureLink ddmStructureLink : this.findByStructureId(structureId, -1, -1, null)) {
            this.remove((BaseModel)ddmStructureLink);
        }
    }

    public int countByStructureId(long structureId) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMStructureLink.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByStructureId;
            finderArgs = new Object[]{structureId};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_DDMSTRUCTURELINK_WHERE);
            sb.append("ddmStructureLink.structureId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(structureId);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<DDMStructureLink> findByC_C(long classNameId, long classPK) {
        return this.findByC_C(classNameId, classPK, -1, -1, null);
    }

    public List<DDMStructureLink> findByC_C(long classNameId, long classPK, int start, int end) {
        return this.findByC_C(classNameId, classPK, start, end, null);
    }

    public List<DDMStructureLink> findByC_C(long classNameId, long classPK, int start, int end, OrderByComparator<DDMStructureLink> orderByComparator) {
        return this.findByC_C(classNameId, classPK, start, end, orderByComparator, true);
    }

    public List<DDMStructureLink> findByC_C(long classNameId, long classPK, int start, int end, OrderByComparator<DDMStructureLink> orderByComparator, boolean useFinderCache) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMStructureLink.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindByC_C;
                finderArgs = new Object[]{classNameId, classPK};
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindByC_C;
            finderArgs = new Object[]{classNameId, classPK, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (DDMStructureLink ddmStructureLink : list) {
                if (classNameId == ddmStructureLink.getClassNameId() && classPK == ddmStructureLink.getClassPK()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_DDMSTRUCTURELINK_WHERE);
            sb.append("ddmStructureLink.classNameId = ? AND ");
            sb.append(_FINDER_COLUMN_C_C_CLASSPK_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY ddmStructureLink.structureLinkId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(classNameId);
                queryPos.add(classPK);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DDMStructureLink findByC_C_First(long classNameId, long classPK, OrderByComparator<DDMStructureLink> orderByComparator) throws NoSuchStructureLinkException {
        DDMStructureLink ddmStructureLink = this.fetchByC_C_First(classNameId, classPK, orderByComparator);
        if (ddmStructureLink != null) {
            return ddmStructureLink;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("classNameId=");
        sb.append(classNameId);
        sb.append(", classPK=");
        sb.append(classPK);
        sb.append("}");
        throw new NoSuchStructureLinkException(sb.toString());
    }

    public DDMStructureLink fetchByC_C_First(long classNameId, long classPK, OrderByComparator<DDMStructureLink> orderByComparator) {
        List<DDMStructureLink> list = this.findByC_C(classNameId, classPK, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMStructureLink findByC_C_Last(long classNameId, long classPK, OrderByComparator<DDMStructureLink> orderByComparator) throws NoSuchStructureLinkException {
        DDMStructureLink ddmStructureLink = this.fetchByC_C_Last(classNameId, classPK, orderByComparator);
        if (ddmStructureLink != null) {
            return ddmStructureLink;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("classNameId=");
        sb.append(classNameId);
        sb.append(", classPK=");
        sb.append(classPK);
        sb.append("}");
        throw new NoSuchStructureLinkException(sb.toString());
    }

    public DDMStructureLink fetchByC_C_Last(long classNameId, long classPK, OrderByComparator<DDMStructureLink> orderByComparator) {
        int count = this.countByC_C(classNameId, classPK);
        if (count == 0) {
            return null;
        }
        List<DDMStructureLink> list = this.findByC_C(classNameId, classPK, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMStructureLink[] findByC_C_PrevAndNext(long structureLinkId, long classNameId, long classPK, OrderByComparator<DDMStructureLink> orderByComparator) throws NoSuchStructureLinkException {
        DDMStructureLink ddmStructureLink = this.findByPrimaryKey(structureLinkId);
        Session session = null;
        try {
            session = this.openSession();
            DDMStructureLink[] array = new DDMStructureLinkImpl[]{this.getByC_C_PrevAndNext(session, ddmStructureLink, classNameId, classPK, orderByComparator, true), ddmStructureLink, this.getByC_C_PrevAndNext(session, ddmStructureLink, classNameId, classPK, orderByComparator, false)};
            DDMStructureLink[] dDMStructureLinkArray = array;
            return dDMStructureLinkArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDMStructureLink getByC_C_PrevAndNext(Session session, DDMStructureLink ddmStructureLink, long classNameId, long classPK, OrderByComparator<DDMStructureLink> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_DDMSTRUCTURELINK_WHERE);
        sb.append("ddmStructureLink.classNameId = ? AND ");
        sb.append(_FINDER_COLUMN_C_C_CLASSPK_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY ddmStructureLink.structureLinkId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(classNameId);
        queryPos.add(classPK);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ddmStructureLink)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (DDMStructureLink)list.get(1);
        }
        return null;
    }

    public void removeByC_C(long classNameId, long classPK) {
        for (DDMStructureLink ddmStructureLink : this.findByC_C(classNameId, classPK, -1, -1, null)) {
            this.remove((BaseModel)ddmStructureLink);
        }
    }

    public int countByC_C(long classNameId, long classPK) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMStructureLink.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByC_C;
            finderArgs = new Object[]{classNameId, classPK};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_DDMSTRUCTURELINK_WHERE);
            sb.append("ddmStructureLink.classNameId = ? AND ");
            sb.append(_FINDER_COLUMN_C_C_CLASSPK_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(classNameId);
                queryPos.add(classPK);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DDMStructureLink findByC_C_S(long classNameId, long classPK, long structureId) throws NoSuchStructureLinkException {
        DDMStructureLink ddmStructureLink = this.fetchByC_C_S(classNameId, classPK, structureId);
        if (ddmStructureLink == null) {
            StringBundler sb = new StringBundler(8);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("classNameId=");
            sb.append(classNameId);
            sb.append(", classPK=");
            sb.append(classPK);
            sb.append(", structureId=");
            sb.append(structureId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchStructureLinkException(sb.toString());
        }
        return ddmStructureLink;
    }

    public DDMStructureLink fetchByC_C_S(long classNameId, long classPK, long structureId) {
        return this.fetchByC_C_S(classNameId, classPK, structureId, true);
    }

    public DDMStructureLink fetchByC_C_S(long classNameId, long classPK, long structureId, boolean useFinderCache) {
        DDMStructureLink ddmStructureLink;
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMStructureLink.class);
        Object[] finderArgs = null;
        if (useFinderCache && productionMode) {
            finderArgs = new Object[]{classNameId, classPK, structureId};
        }
        Object result = null;
        if (useFinderCache && productionMode) {
            result = this.finderCache.getResult(this._finderPathFetchByC_C_S, finderArgs);
        }
        if (result instanceof DDMStructureLink && (classNameId != (ddmStructureLink = (DDMStructureLink)result).getClassNameId() || classPK != ddmStructureLink.getClassPK() || structureId != ddmStructureLink.getStructureId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(5);
            sb.append(_SQL_SELECT_DDMSTRUCTURELINK_WHERE);
            sb.append("ddmStructureLink.classNameId = ? AND ");
            sb.append(_FINDER_COLUMN_C_C_S_CLASSPK_2);
            sb.append("ddmStructureLink.structureId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(classNameId);
                queryPos.add(classPK);
                queryPos.add(structureId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache && productionMode) {
                        this.finderCache.putResult(this._finderPathFetchByC_C_S, finderArgs, (Object)list);
                    }
                } else {
                    DDMStructureLink ddmStructureLink2 = (DDMStructureLink)list.get(0);
                    result = ddmStructureLink2;
                    this.cacheResult(ddmStructureLink2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (DDMStructureLink)result;
    }

    public DDMStructureLink removeByC_C_S(long classNameId, long classPK, long structureId) throws NoSuchStructureLinkException {
        DDMStructureLink ddmStructureLink = this.findByC_C_S(classNameId, classPK, structureId);
        return (DDMStructureLink)this.remove((BaseModel)ddmStructureLink);
    }

    public int countByC_C_S(long classNameId, long classPK, long structureId) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMStructureLink.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByC_C_S;
            finderArgs = new Object[]{classNameId, classPK, structureId};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_COUNT_DDMSTRUCTURELINK_WHERE);
            sb.append("ddmStructureLink.classNameId = ? AND ");
            sb.append(_FINDER_COLUMN_C_C_S_CLASSPK_2);
            sb.append("ddmStructureLink.structureId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(classNameId);
                queryPos.add(classPK);
                queryPos.add(structureId);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DDMStructureLinkPersistenceImpl() {
        this.setModelClass(DDMStructureLink.class);
        this.setModelImplClass(DDMStructureLinkImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)DDMStructureLinkTable.INSTANCE);
    }

    public void cacheResult(DDMStructureLink ddmStructureLink) {
        if (ddmStructureLink.getCtCollectionId() != 0L) {
            return;
        }
        this.entityCache.putResult(DDMStructureLinkImpl.class, (Serializable)Long.valueOf(ddmStructureLink.getPrimaryKey()), (Serializable)ddmStructureLink);
        this.finderCache.putResult(this._finderPathFetchByC_C_S, new Object[]{ddmStructureLink.getClassNameId(), ddmStructureLink.getClassPK(), ddmStructureLink.getStructureId()}, (Object)ddmStructureLink);
    }

    public void cacheResult(List<DDMStructureLink> ddmStructureLinks) {
        for (DDMStructureLink ddmStructureLink : ddmStructureLinks) {
            if (ddmStructureLink.getCtCollectionId() != 0L || this.entityCache.getResult(DDMStructureLinkImpl.class, (Serializable)Long.valueOf(ddmStructureLink.getPrimaryKey())) != null) continue;
            this.cacheResult(ddmStructureLink);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(DDMStructureLinkImpl.class);
        this.finderCache.clearCache(DDMStructureLinkImpl.class);
    }

    public void clearCache(DDMStructureLink ddmStructureLink) {
        this.entityCache.removeResult(DDMStructureLinkImpl.class, (BaseModel)ddmStructureLink);
    }

    public void clearCache(List<DDMStructureLink> ddmStructureLinks) {
        for (DDMStructureLink ddmStructureLink : ddmStructureLinks) {
            this.entityCache.removeResult(DDMStructureLinkImpl.class, (BaseModel)ddmStructureLink);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(DDMStructureLinkImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(DDMStructureLinkImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(DDMStructureLinkModelImpl ddmStructureLinkModelImpl) {
        Object[] args = new Object[]{ddmStructureLinkModelImpl.getClassNameId(), ddmStructureLinkModelImpl.getClassPK(), ddmStructureLinkModelImpl.getStructureId()};
        this.finderCache.putResult(this._finderPathCountByC_C_S, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchByC_C_S, args, (Object)ddmStructureLinkModelImpl);
    }

    public DDMStructureLink create(long structureLinkId) {
        DDMStructureLinkImpl ddmStructureLink = new DDMStructureLinkImpl();
        ddmStructureLink.setNew(true);
        ddmStructureLink.setPrimaryKey(structureLinkId);
        ddmStructureLink.setCompanyId(CompanyThreadLocal.getCompanyId());
        return ddmStructureLink;
    }

    public DDMStructureLink remove(long structureLinkId) throws NoSuchStructureLinkException {
        return this.remove(Long.valueOf(structureLinkId));
    }

    public DDMStructureLink remove(Serializable primaryKey) throws NoSuchStructureLinkException {
        Session session = null;
        try {
            session = this.openSession();
            DDMStructureLink ddmStructureLink = (DDMStructureLink)session.get(DDMStructureLinkImpl.class, primaryKey);
            if (ddmStructureLink == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchStructureLinkException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            DDMStructureLink dDMStructureLink = (DDMStructureLink)this.remove((BaseModel)ddmStructureLink);
            return dDMStructureLink;
        }
        catch (NoSuchStructureLinkException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDMStructureLink removeImpl(DDMStructureLink ddmStructureLink) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)ddmStructureLink)) {
                ddmStructureLink = (DDMStructureLink)session.get(DDMStructureLinkImpl.class, ddmStructureLink.getPrimaryKeyObj());
            }
            if (ddmStructureLink != null && this.ctPersistenceHelper.isRemove((CTModel)ddmStructureLink)) {
                session.delete((Object)ddmStructureLink);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (ddmStructureLink != null) {
            this.clearCache(ddmStructureLink);
        }
        return ddmStructureLink;
    }

    public DDMStructureLink updateImpl(DDMStructureLink ddmStructureLink) {
        boolean isNew = ddmStructureLink.isNew();
        if (!(ddmStructureLink instanceof DDMStructureLinkModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(ddmStructureLink.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)ddmStructureLink);
                throw new IllegalArgumentException("Implement ModelWrapper in ddmStructureLink proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom DDMStructureLink implementation " + ddmStructureLink.getClass());
        }
        DDMStructureLinkModelImpl ddmStructureLinkModelImpl = (DDMStructureLinkModelImpl)ddmStructureLink;
        Session session = null;
        try {
            session = this.openSession();
            if (this.ctPersistenceHelper.isInsert((CTModel)ddmStructureLink)) {
                if (!isNew) {
                    session.evict(DDMStructureLinkImpl.class, ddmStructureLink.getPrimaryKeyObj());
                }
                session.save((Object)ddmStructureLink);
            } else {
                ddmStructureLink = (DDMStructureLink)session.merge((Object)ddmStructureLink);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (ddmStructureLink.getCtCollectionId() != 0L) {
            if (isNew) {
                ddmStructureLink.setNew(false);
            }
            ddmStructureLink.resetOriginalValues();
            return ddmStructureLink;
        }
        this.entityCache.putResult(DDMStructureLinkImpl.class, (BaseModel)ddmStructureLinkModelImpl, false, true);
        this.cacheUniqueFindersCache(ddmStructureLinkModelImpl);
        if (isNew) {
            ddmStructureLink.setNew(false);
        }
        ddmStructureLink.resetOriginalValues();
        return ddmStructureLink;
    }

    public DDMStructureLink findByPrimaryKey(Serializable primaryKey) throws NoSuchStructureLinkException {
        DDMStructureLink ddmStructureLink = this.fetchByPrimaryKey(primaryKey);
        if (ddmStructureLink == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchStructureLinkException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return ddmStructureLink;
    }

    public DDMStructureLink findByPrimaryKey(long structureLinkId) throws NoSuchStructureLinkException {
        return this.findByPrimaryKey(Long.valueOf(structureLinkId));
    }

    public DDMStructureLink fetchByPrimaryKey(Serializable primaryKey) {
        if (this.ctPersistenceHelper.isProductionMode(DDMStructureLink.class)) {
            return (DDMStructureLink)super.fetchByPrimaryKey(primaryKey);
        }
        DDMStructureLink ddmStructureLink = null;
        Session session = null;
        try {
            session = this.openSession();
            ddmStructureLink = (DDMStructureLink)session.get(DDMStructureLinkImpl.class, primaryKey);
            if (ddmStructureLink != null) {
                this.cacheResult(ddmStructureLink);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return ddmStructureLink;
    }

    public DDMStructureLink fetchByPrimaryKey(long structureLinkId) {
        return this.fetchByPrimaryKey(Long.valueOf(structureLinkId));
    }

    public Map<Serializable, DDMStructureLink> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        if (this.ctPersistenceHelper.isProductionMode(DDMStructureLink.class)) {
            return super.fetchByPrimaryKeys(primaryKeys);
        }
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, DDMStructureLink> map = new HashMap<Serializable, DDMStructureLink>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            DDMStructureLink ddmStructureLink = this.fetchByPrimaryKey(primaryKey);
            if (ddmStructureLink != null) {
                map.put(primaryKey, ddmStructureLink);
            }
            return map;
        }
        StringBundler sb = new StringBundler(primaryKeys.size() * 2 + 1);
        sb.append(this.getSelectSQL());
        sb.append(" WHERE ");
        sb.append(this.getPKDBName());
        sb.append(" IN (");
        for (Serializable primaryKey : primaryKeys) {
            sb.append(((Long)primaryKey).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String sql = sb.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(sql);
            for (DDMStructureLink ddmStructureLink : query.list()) {
                map.put(ddmStructureLink.getPrimaryKeyObj(), ddmStructureLink);
                this.cacheResult(ddmStructureLink);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return map;
    }

    public List<DDMStructureLink> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<DDMStructureLink> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<DDMStructureLink> findAll(int start, int end, OrderByComparator<DDMStructureLink> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<DDMStructureLink> findAll(int start, int end, OrderByComparator<DDMStructureLink> orderByComparator, boolean useFinderCache) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMStructureLink.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_DDMSTRUCTURELINK);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_DDMSTRUCTURELINK;
                sql = sql.concat(" ORDER BY ddmStructureLink.structureLinkId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (DDMStructureLink ddmStructureLink : this.findAll()) {
            this.remove((BaseModel)ddmStructureLink);
        }
    }

    public int countAll() {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DDMStructureLink.class);
        Long count = null;
        if (productionMode) {
            count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
        }
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_DDMSTRUCTURELINK);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "structureLinkId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_DDMSTRUCTURELINK;
    }

    public Set<String> getCTColumnNames(CTColumnResolutionType ctColumnResolutionType) {
        return _ctColumnNamesMap.get(ctColumnResolutionType);
    }

    public List<String> getMappingTableNames() {
        return _mappingTableNames;
    }

    public Map<String, Integer> getTableColumnsMap() {
        return DDMStructureLinkModelImpl.TABLE_COLUMNS_MAP;
    }

    public String getTableName() {
        return "DDMStructureLink";
    }

    public List<String[]> getUniqueIndexColumnNames() {
        return _uniqueIndexColumnNames;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new DDMStructureLinkModelArgumentsResolver(), (Dictionary)new HashMapDictionary());
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByStructureId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByStructureId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"structureId"}, true);
        this._finderPathWithoutPaginationFindByStructureId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByStructureId", new String[]{Long.class.getName()}, new String[]{"structureId"}, true);
        this._finderPathCountByStructureId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByStructureId", new String[]{Long.class.getName()}, new String[]{"structureId"}, false);
        this._finderPathWithPaginationFindByC_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_C", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"classNameId", "classPK"}, true);
        this._finderPathWithoutPaginationFindByC_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_C", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"classNameId", "classPK"}, true);
        this._finderPathCountByC_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"classNameId", "classPK"}, false);
        this._finderPathFetchByC_C_S = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByC_C_S", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName()}, new String[]{"classNameId", "classPK", "structureId"}, true);
        this._finderPathCountByC_C_S = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C_S", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName()}, new String[]{"classNameId", "classPK", "structureId"}, false);
    }

    @Deactivate
    public void deactivate() {
        this.entityCache.removeCache(DDMStructureLinkImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.dynamic.data.mapping.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.dynamic.data.mapping.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.dynamic.data.mapping.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }

    static {
        HashSet<String> ctControlColumnNames = new HashSet<String>();
        HashSet ctIgnoreColumnNames = new HashSet();
        HashSet ctMergeColumnNames = new HashSet();
        HashSet<String> ctStrictColumnNames = new HashSet<String>();
        ctControlColumnNames.add("mvccVersion");
        ctControlColumnNames.add("ctCollectionId");
        ctStrictColumnNames.add("companyId");
        ctStrictColumnNames.add("classNameId");
        ctStrictColumnNames.add("classPK");
        ctStrictColumnNames.add("structureId");
        _ctColumnNamesMap.put(CTColumnResolutionType.CONTROL, ctControlColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.IGNORE, ctIgnoreColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.MERGE, ctMergeColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.PK, Collections.singleton("structureLinkId"));
        _ctColumnNamesMap.put(CTColumnResolutionType.STRICT, ctStrictColumnNames);
        _uniqueIndexColumnNames.add(new String[]{"classNameId", "classPK", "structureId"});
        _log = LogFactoryUtil.getLog(DDMStructureLinkPersistenceImpl.class);
    }

    private static class DDMStructureLinkModelArgumentsResolver
    implements ArgumentsResolver {
        private static Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();

        private DDMStructureLinkModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return FINDER_ARGS_EMPTY;
                }
                return null;
            }
            DDMStructureLinkModelImpl ddmStructureLinkModelImpl = (DDMStructureLinkModelImpl)baseModel;
            long columnBitmask = ddmStructureLinkModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return this._getValue(ddmStructureLinkModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | DDMStructureLinkModelImpl.getColumnBitmask(columnName);
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return this._getValue(ddmStructureLinkModelImpl, columnNames, original);
            }
            return null;
        }

        public String getClassName() {
            return DDMStructureLinkImpl.class.getName();
        }

        public String getTableName() {
            return DDMStructureLinkTable.INSTANCE.getTableName();
        }

        private Object[] _getValue(DDMStructureLinkModelImpl ddmStructureLinkModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? ddmStructureLinkModelImpl.getColumnOriginalValue(columnName) : ddmStructureLinkModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }
    }
}

