/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.DDMTemplateVersion;
import com.liferay.dynamic.data.mapping.service.base.DDMTemplateVersionServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=ddm", "json.web.service.context.path=DDMTemplateVersion"}, service={AopService.class})
public class DDMTemplateVersionServiceImpl
extends DDMTemplateVersionServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.model.DDMTemplate)")
    private ModelResourcePermission<DDMTemplate> _ddmTemplateModelResourcePermission;

    public DDMTemplateVersion getLatestTemplateVersion(long templateId) throws PortalException {
        this._ddmTemplateModelResourcePermission.check(this.getPermissionChecker(), templateId, "VIEW");
        return this.ddmTemplateVersionLocalService.getLatestTemplateVersion(templateId);
    }

    public DDMTemplateVersion getTemplateVersion(long templateVersionId) throws PortalException {
        DDMTemplateVersion templateVersion = this.ddmTemplateVersionLocalService.getTemplateVersion(templateVersionId);
        this._ddmTemplateModelResourcePermission.check(this.getPermissionChecker(), templateVersion.getTemplateId(), "VIEW");
        return templateVersion;
    }

    public List<DDMTemplateVersion> getTemplateVersions(long templateId, int start, int end, OrderByComparator<DDMTemplateVersion> orderByComparator) throws PortalException {
        this._ddmTemplateModelResourcePermission.check(this.getPermissionChecker(), templateId, "VIEW");
        return this.ddmTemplateVersionLocalService.getTemplateVersions(templateId, start, end, orderByComparator);
    }

    public int getTemplateVersionsCount(long templateId) throws PortalException {
        this._ddmTemplateModelResourcePermission.check(this.getPermissionChecker(), templateId, "VIEW");
        return this.ddmTemplateVersionLocalService.getTemplateVersionsCount(templateId);
    }
}

