/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v4_3_2;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class DDMTemplateUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this._upgradeDDMTemplate();
        this._upgradeDDMTemplateVersion();
    }

    private void _upgradeDDMTemplate() throws Exception {
        try (PreparedStatement ps1 = this.connection.prepareStatement("select templateId, script FROM DDMTemplate where classNameId = ?");
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMTemplate set script = ? where templateId = ?");){
            ps1.setLong(1, PortalUtil.getClassNameId(DDMStructure.class));
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    ps2.setString(1, StringUtil.replace((String)rs.getString("script"), (String)"randomizer.", (String)"random."));
                    ps2.setLong(2, rs.getLong("templateId"));
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }

    private void _upgradeDDMTemplateVersion() throws Exception {
        try (PreparedStatement ps1 = this.connection.prepareStatement("select templateVersionId, script FROM DDMTemplateVersion where classNameId = ?");
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMTemplateVersion set script = ? where templateVersionId = ?");){
            ps1.setLong(1, PortalUtil.getClassNameId(DDMStructure.class));
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    ps2.setString(1, StringUtil.replace((String)rs.getString("script"), (String)"randomizer.", (String)"random."));
                    ps2.setLong(2, rs.getLong("templateVersionId"));
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }
}

