/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v4_3_0;

import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.sql.Date;
import java.sql.PreparedStatement;

public class DLFileEntryTypeDataDefinitionIdUpgradeProcess
extends UpgradeProcess {
    private static final String _DEFINITION_DDM_STRUCTURE = JSONUtil.put((String)"availableLanguageIds", (Object)JSONUtil.putAll((Object[])new Object[]{"en_US"})).put("defaultLanguageId", "en_US").put("definitionSchemaVersion", "2.0").put("fields", JSONFactoryUtil.createJSONArray()).put("successPage", JSONUtil.put((String)"body", (Object)JSONFactoryUtil.createJSONObject()).put("enabled", false).put("title", JSONFactoryUtil.createJSONObject())).toString();
    private static final String _DEFINITION_DDM_STRUCTURE_LAYOUT = JSONUtil.put((String)"defaultLanguageId", (Object)"en_US").put("definitionSchemaVersion", "2.0").put("fields", JSONFactoryUtil.createJSONArray()).put("pages", JSONUtil.putAll((Object[])new Object[]{JSONUtil.put((String)"description", (Object)JSONUtil.put((String)"en_US", (Object)"")).put("enabled", false).put("rows", JSONFactoryUtil.createJSONArray()).put("title", JSONUtil.put((String)"en_US", (Object)""))})).put("paginationMode", "single-page").toString();
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryTypeDataDefinitionIdUpgradeProcess.class);
    private final DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;

    public DLFileEntryTypeDataDefinitionIdUpgradeProcess(DLFileEntryTypeLocalService dlFileEntryTypeLocalService) {
        this._dlFileEntryTypeLocalService = dlFileEntryTypeLocalService;
    }

    protected void doUpgrade() throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._dlFileEntryTypeLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            dynamicQuery.add(RestrictionsFactoryUtil.or((Criterion)RestrictionsFactoryUtil.eq((String)"dataDefinitionId", (Object)0L), (Criterion)RestrictionsFactoryUtil.isNull((String)"dataDefinitionId")));
            dynamicQuery.add(RestrictionsFactoryUtil.ne((String)"fileEntryTypeKey", (Object)"BASIC-DOCUMENT"));
        });
        actionableDynamicQuery.setPerformActionMethod(dlFileEntryType -> {
            try {
                long ddmStructureId = this._addDDMStructure(dlFileEntryType.getGroupId(), dlFileEntryType.getCompanyId(), dlFileEntryType.getUserId(), dlFileEntryType.getUserName(), dlFileEntryType.getName());
                long ddmStructureVersionId = this._addDDMStructureVersion(dlFileEntryType.getUserId(), dlFileEntryType.getUserName(), dlFileEntryType.getCompanyId(), dlFileEntryType.getGroupId(), ddmStructureId, dlFileEntryType.getName());
                this._addDDMStructureLayout(dlFileEntryType.getUserId(), dlFileEntryType.getUserName(), dlFileEntryType.getGroupId(), dlFileEntryType.getCompanyId(), ddmStructureId, dlFileEntryType.getName(), ddmStructureVersionId);
                ResourceLocalServiceUtil.addResources((long)dlFileEntryType.getCompanyId(), (long)dlFileEntryType.getGroupId(), (long)dlFileEntryType.getUserId(), (String)ResourceActionsUtil.getCompositeModelName((String[])new String[]{DLFileEntryMetadata.class.getName(), DDMStructure.class.getName()}), (long)ddmStructureId, (boolean)false, (boolean)false, (boolean)false);
                dlFileEntryType.setDataDefinitionId(ddmStructureId);
                this._dlFileEntryTypeLocalService.updateDLFileEntryType(dlFileEntryType);
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
            }
        });
        actionableDynamicQuery.performActions();
        if (!this.hasIndex("DLFileEntryType", "IX_B6F21286")) {
            this.runSQLTemplateString("create unique index IX_B6F21286 on DLFileEntryType (groupId, dataDefinitionId, ctCollectionId);", false);
        }
    }

    private long _addDDMStructure(long groupId, long companyId, long userId, String userName, String name) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"insert into DDMStructure (mvccVersion, ctCollectionId, ", "uuid_, structureId, groupId, companyId, userId, ", "userName, versionUserId, versionUserName, createDate, ", "modifiedDate, parentStructureId, classNameId, ", "structureKey, version, name, description, definition, ", "storageType, type_, lastPublishDate) values (0, 0, ?, ?, ", "?, ?, ?, ?, ?, ?, ?, ?, 0, ?, ?, '1.0', ?, '', ?, ", "'default', 1, null)"}));){
            long classNameId = PortalUtil.getClassNameId(DLFileEntryMetadata.class);
            ps.setString(1, PortalUUIDUtil.generate());
            long ddmStructureId = this.increment();
            ps.setLong(2, ddmStructureId);
            ps.setLong(3, groupId);
            ps.setLong(4, companyId);
            ps.setLong(5, userId);
            ps.setString(6, userName);
            ps.setLong(7, userId);
            ps.setString(8, userName);
            Date now = new Date(System.currentTimeMillis());
            ps.setDate(9, now);
            ps.setDate(10, now);
            ps.setLong(11, classNameId);
            ps.setString(12, String.valueOf(ddmStructureId));
            ps.setString(13, name);
            ps.setString(14, _DEFINITION_DDM_STRUCTURE);
            ps.executeUpdate();
            long l = ddmStructureId;
            return l;
        }
    }

    private void _addDDMStructureLayout(long userId, String userName, long groupId, long companyId, long ddmStructureId, String name, long ddmStructureVersionId) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"insert into DDMStructureLayout (mvccVersion, ", "ctCollectionId, uuid_, structureLayoutId, groupId, ", "companyId, userId, userName, createDate, modifiedDate, ", "classNameId, structureLayoutKey, structureVersionId, ", "name, description, definition) values (0, 0, ?, ?, ?, ?, ", "?, ?, ?, ?, ?, ?, ?, ?, '', ?)"}));){
            long classNameId = PortalUtil.getClassNameId(DLFileEntryMetadata.class);
            ps.setString(1, PortalUUIDUtil.generate());
            ps.setLong(2, this.increment());
            ps.setLong(3, groupId);
            ps.setLong(4, companyId);
            ps.setLong(5, userId);
            ps.setString(6, userName);
            Date now = new Date(System.currentTimeMillis());
            ps.setDate(7, now);
            ps.setDate(8, now);
            ps.setLong(9, classNameId);
            ps.setString(10, String.valueOf(ddmStructureId));
            ps.setLong(11, ddmStructureVersionId);
            ps.setString(12, name);
            ps.setString(13, _DEFINITION_DDM_STRUCTURE_LAYOUT);
            ps.executeUpdate();
        }
    }

    private long _addDDMStructureVersion(long userId, String userName, long companyId, long groupId, long ddmStructureId, String name) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"insert into DDMStructureVersion (mvccVersion, ", "ctCollectionId, structureVersionId, groupId, companyId, ", "userId, userName, createDate, structureId, version, ", "parentStructureId, name, description, definition, ", "storageType, type_, status, statusByUserId, ", "statusByUserName, statusDate) values (0, 0, ?, ?, ?, ?, ", "?, ?, ?, '1.0', 0, ?, '', ? , 'default', 0, 0, ?, ?, ", "?)"}));){
            long structureVersionId = this.increment();
            ps.setLong(1, structureVersionId);
            ps.setLong(2, groupId);
            ps.setLong(3, companyId);
            ps.setLong(4, userId);
            ps.setString(5, userName);
            Date now = new Date(System.currentTimeMillis());
            ps.setDate(6, now);
            ps.setLong(7, ddmStructureId);
            ps.setString(8, name);
            ps.setString(9, _DEFINITION_DDM_STRUCTURE);
            ps.setLong(10, userId);
            ps.setString(11, userName);
            ps.setDate(12, now);
            ps.executeUpdate();
            long l = structureVersionId;
            return l;
        }
    }
}

