/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v4_0_0;

import com.liferay.dynamic.data.mapping.util.DDMDataDefinitionConverter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class DDMStructureUpgradeProcess
extends UpgradeProcess {
    private static final String _CLASS_NAME_DL_FILE_ENTRY_METADATA = "com.liferay.document.library.kernel.model.DLFileEntryMetadata";
    private static final String _CLASS_NAME_JOURNAL_ARTICLE = "com.liferay.journal.model.JournalArticle";
    private final DDMDataDefinitionConverter _ddmDataDefinitionConverter;

    public DDMStructureUpgradeProcess(DDMDataDefinitionConverter ddmDataDefinitionConverter) {
        this._ddmDataDefinitionConverter = ddmDataDefinitionConverter;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeStructureDefinition();
        this._upgradeStructureVersionDefinition();
        this._upgradeStructureLayoutDefinition();
    }

    private long _getParentStructureLayoutId(long parentStructureId) throws Exception {
        StringBundler sb1 = new StringBundler(8);
        sb1.append("select DDMStructureLayout.structureLayoutId  from ");
        sb1.append("DDMStructureLayout inner join DDMStructureVersion on ");
        sb1.append("DDMStructureVersion.structureVersionId = ");
        sb1.append("DDMStructureLayout.structureVersionId inner join ");
        sb1.append("DDMStructure on DDMStructure.structureId = ");
        sb1.append("DDMStructureVersion.structureId and DDMStructure.version ");
        sb1.append("= DDMStructureVersion.version where ");
        sb1.append("DDMStructure.structureId = ?");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb1.toString());){
            ps1.setLong(1, parentStructureId);
            try (ResultSet rs = ps1.executeQuery();){
                if (rs.next()) {
                    long l = rs.getLong("structureLayoutId");
                    return l;
                }
            }
        }
        return 0L;
    }

    private void _upgradeStructureDefinition() throws Exception {
        try (PreparedStatement ps1 = this.connection.prepareStatement("select * from DDMStructure where classNameId = ? or classNameId = ? order by createDate");
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set parentStructureId = 0, definition = ? where structureId = ?");){
            ps1.setLong(1, PortalUtil.getClassNameId((String)_CLASS_NAME_DL_FILE_ENTRY_METADATA));
            ps1.setLong(2, PortalUtil.getClassNameId((String)_CLASS_NAME_JOURNAL_ARTICLE));
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    long parentStructureId = rs.getLong("parentStructureId");
                    long parentStructureLayoutId = 0L;
                    if (parentStructureId > 0L) {
                        parentStructureLayoutId = this._getParentStructureLayoutId(parentStructureId);
                    }
                    ps2.setString(1, this._ddmDataDefinitionConverter.convertDDMFormDataDefinition(rs.getString("definition"), rs.getLong("groupId"), parentStructureId, parentStructureLayoutId, rs.getLong("structureId")));
                    ps2.setLong(2, rs.getLong("structureId"));
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }

    private void _upgradeStructureLayoutDefinition() throws Exception {
        StringBundler sb1 = new StringBundler(16);
        sb1.append("select DDMStructure.structureId, ");
        sb1.append("DDMStructure.parentStructureId, DDMStructure.classNameId ");
        sb1.append(", DDMStructure.structureKey, DDMStructureLayout.groupId, ");
        sb1.append("DDMStructureLayout.structureLayoutId, ");
        sb1.append("DDMStructureLayout.definition as ");
        sb1.append("structureLayoutDefinition, ");
        sb1.append("DDMStructureVersion.definition as ");
        sb1.append("structureVersionDefinition from DDMStructureLayout inner ");
        sb1.append("join DDMStructureVersion on ");
        sb1.append("DDMStructureVersion.structureVersionId = ");
        sb1.append("DDMStructureLayout.structureVersionId inner join ");
        sb1.append("DDMStructure on DDMStructure.structureId = ");
        sb1.append("DDMStructureVersion.structureId and DDMStructure.version ");
        sb1.append("= DDMStructureVersion.version where ");
        sb1.append("DDMStructure.classNameId = ? or DDMStructure.classNameId ");
        sb1.append("= ?");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb1.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureLayout set definition = ?, classNameId = ?, structureLayoutKey = ? where structureLayoutId = ?");){
            ps1.setLong(1, PortalUtil.getClassNameId((String)_CLASS_NAME_DL_FILE_ENTRY_METADATA));
            ps1.setLong(2, PortalUtil.getClassNameId((String)_CLASS_NAME_JOURNAL_ARTICLE));
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    String structureLayoutDefinition = rs.getString("structureLayoutDefinition");
                    String structureVersionDefinition = rs.getString("structureVersionDefinition");
                    ps2.setString(1, this._ddmDataDefinitionConverter.convertDDMFormLayoutDataDefinition(rs.getLong("groupId"), rs.getLong("structureId"), structureLayoutDefinition, rs.getLong("structureLayoutId"), structureVersionDefinition));
                    ps2.setLong(2, rs.getLong("classNameId"));
                    ps2.setString(3, rs.getString("structureKey"));
                    ps2.setLong(4, rs.getLong("structureLayoutId"));
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }

    private void _upgradeStructureVersionDefinition() throws Exception {
        StringBundler sb1 = new StringBundler(6);
        sb1.append("select DDMStructure.structureKey, DDMStructureVersion.* ");
        sb1.append("from DDMStructureVersion inner join DDMStructure on ");
        sb1.append("DDMStructure.structureId = ");
        sb1.append("DDMStructureVersion.structureId where ");
        sb1.append("DDMStructure.classNameId = ? or DDMStructure.classNameId ");
        sb1.append("= ?");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb1.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set parentStructureId = 0, definition = ? where structureVersionId = ?");){
            ps1.setLong(1, PortalUtil.getClassNameId((String)_CLASS_NAME_DL_FILE_ENTRY_METADATA));
            ps1.setLong(2, PortalUtil.getClassNameId((String)_CLASS_NAME_JOURNAL_ARTICLE));
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    long parentStructureId = rs.getLong("parentStructureId");
                    long parentStructureLayoutId = 0L;
                    if (parentStructureId > 0L) {
                        parentStructureLayoutId = this._getParentStructureLayoutId(parentStructureId);
                    }
                    ps2.setString(1, this._ddmDataDefinitionConverter.convertDDMFormDataDefinition(rs.getString("definition"), parentStructureId, parentStructureLayoutId));
                    ps2.setLong(2, rs.getLong("structureVersionId"));
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }
}

