/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_8_0;

import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.util.DDMFormDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormLayoutDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormSerializeUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Tuple;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;

public class DDMStructureUpgradeProcess
extends UpgradeProcess {
    private static final int _DDM_FORM_FIELD_NAME_RANDOM_NUMBERS_LENGTH = 8;
    private static final int _DDM_FORM_FIELD_TUPLE_COLUMN_SIZE = 2;
    private static final int _DDM_FORM_FIELD_TUPLE_LABEL = 1;
    private static final int _DDM_FORM_FIELD_TUPLE_NAME = 0;
    private static final int _DDM_FORM_FIELD_TUPLE_NESTED_FIELD_NAMES = 3;
    private final DDMFormDeserializer _ddmFormDeserializer;
    private final DDMFormLayoutDeserializer _ddmFormLayoutDeserializer;
    private final DDMFormLayoutSerializer _ddmFormLayoutSerializer;
    private final DDMFormSerializer _ddmFormSerializer;
    private final JSONFactory _jsonFactory;
    private final Map<Long, List<Tuple>> _nestedFieldsMap = new HashMap<Long, List<Tuple>>();
    private final List<Long> _structureIds = new ArrayList<Long>();

    public DDMStructureUpgradeProcess(DDMFormDeserializer ddmFormDeserializer, DDMFormLayoutDeserializer ddmFormLayoutDeserializer, DDMFormLayoutSerializer ddmFormLayoutSerializer, DDMFormSerializer ddmFormSerializer, JSONFactory jsonFactory) {
        this._ddmFormDeserializer = ddmFormDeserializer;
        this._ddmFormLayoutDeserializer = ddmFormLayoutDeserializer;
        this._ddmFormLayoutSerializer = ddmFormLayoutSerializer;
        this._ddmFormSerializer = ddmFormSerializer;
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeDDMStructureLayout();
        this._upgradeDDMStructureVersion();
        this._upgradeDDMStructure();
    }

    private String _generateDDMFormFieldName() {
        String ddmFormFieldName = "Field";
        Random random = new Random();
        for (int i = 0; i < 8; ++i) {
            ddmFormFieldName = ddmFormFieldName.concat(String.valueOf(random.nextInt(10)));
        }
        return ddmFormFieldName;
    }

    private boolean _hasMoreThanOneDDMFormFieldPerColumn(DDMFormLayout ddmFormLayout) throws Exception {
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayout.getDDMFormLayoutPages()) {
            for (DDMFormLayoutRow ddmFormLayoutRow : ddmFormLayoutPage.getDDMFormLayoutRows()) {
                for (DDMFormLayoutColumn ddmFormLayoutColumn : ddmFormLayoutRow.getDDMFormLayoutColumns()) {
                    List ddmFormFieldNames = ddmFormLayoutColumn.getDDMFormFieldNames();
                    if (ddmFormFieldNames.size() <= 1) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void _upgradeDDMStructure() throws Exception {
        if (this._structureIds.isEmpty()) {
            return;
        }
        StringBundler sb = new StringBundler(7 + 2 * this._structureIds.size());
        sb.append("select DDMStructure.structureId, ");
        sb.append("DDMStructureVersion.definition from DDMStructure inner ");
        sb.append("join DDMStructureVersion on DDMStructure.structureid = ");
        sb.append("DDMStructureVersion.structureid where ");
        sb.append("DDMStructure.version = DDMStructureVersion.version and ");
        sb.append("DDMStructure.classNameId = ? and DDMStructure.structureId ");
        sb.append("in (");
        Iterator<Long> iterator = this._structureIds.iterator();
        while (iterator.hasNext()) {
            sb.append("?");
            iterator.next();
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append(")");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");){
            int parameterIndex = 1;
            ps1.setLong(parameterIndex, PortalUtil.getClassNameId((String)DDMFormInstance.class.getName()));
            for (long structureId : this._structureIds) {
                ps1.setLong(++parameterIndex, structureId);
            }
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    String definition = rs.getString("definition");
                    ps2.setString(1, definition);
                    long structureId = rs.getLong("structureId");
                    ps2.setLong(2, structureId);
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }

    private void _upgradeDDMStructureLayout() throws Exception {
        StringBundler sb = new StringBundler(10);
        sb.append("select DDMStructure.structureId, ");
        sb.append("DDMStructureLayout.structureLayoutId, ");
        sb.append("DDMStructureLayout.structureVersionId, ");
        sb.append("DDMStructureLayout.definition from DDMStructureLayout ");
        sb.append("inner join DDMStructureVersion on ");
        sb.append("DDMStructureLayout.structureVersionId = ");
        sb.append("DDMStructureVersion.structureVersionId inner join ");
        sb.append("DDMStructure on DDMStructure.structureId = ");
        sb.append("DDMStructureVersion.structureId where ");
        sb.append("DDMStructure.classNameId = ?");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureLayout set definition = ? where structureLayoutId = ?");){
            ps1.setLong(1, PortalUtil.getClassNameId((String)DDMFormInstance.class.getName()));
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    boolean hasMoreThanOneDDMFormFieldPerColumn;
                    DDMFormLayout ddmFormLayout = DDMFormLayoutDeserializeUtil.deserialize((DDMFormLayoutDeserializer)this._ddmFormLayoutDeserializer, (String)rs.getString("definition"));
                    boolean pagination = Objects.equals(ddmFormLayout.getPaginationMode(), "pagination");
                    if (pagination) {
                        ddmFormLayout.setPaginationMode("wizard");
                    }
                    if (hasMoreThanOneDDMFormFieldPerColumn = this._hasMoreThanOneDDMFormFieldPerColumn(ddmFormLayout)) {
                        long structureVersionId = rs.getLong("structureVersionId");
                        ddmFormLayout = this._upgradeDDMStructureLayoutDefinition(ddmFormLayout, structureVersionId);
                        this._structureIds.add(rs.getLong("structureId"));
                    }
                    if (!pagination && !hasMoreThanOneDDMFormFieldPerColumn) continue;
                    DDMFormLayoutSerializerSerializeResponse ddmFormLayoutSerializerSerializeResponse = this._ddmFormLayoutSerializer.serialize(DDMFormLayoutSerializerSerializeRequest.Builder.newBuilder((DDMFormLayout)ddmFormLayout).build());
                    ps2.setString(1, ddmFormLayoutSerializerSerializeResponse.getContent());
                    long structureLayoutId = rs.getLong("structureLayoutId");
                    ps2.setLong(2, structureLayoutId);
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }

    private DDMFormLayout _upgradeDDMStructureLayoutDefinition(DDMFormLayout ddmFormLayout, long structureVersionId) throws Exception {
        ArrayList<Tuple> ddmFormFieldTuples = new ArrayList<Tuple>();
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayout.getDDMFormLayoutPages()) {
            for (DDMFormLayoutRow ddmFormLayoutRow : ddmFormLayoutPage.getDDMFormLayoutRows()) {
                for (DDMFormLayoutColumn ddmFormLayoutColumn : ddmFormLayoutRow.getDDMFormLayoutColumns()) {
                    List ddmFormFieldNames = ddmFormLayoutColumn.getDDMFormFieldNames();
                    if (ddmFormFieldNames.size() <= 1) continue;
                    String ddmFormFieldName = this._generateDDMFormFieldName();
                    ddmFormFieldTuples.add(new Tuple(new Object[]{ddmFormFieldName, "Fields Group", ddmFormLayoutColumn.getSize(), ddmFormFieldNames}));
                    ddmFormLayoutColumn.setDDMFormFieldNames(Arrays.asList(ddmFormFieldName));
                }
            }
        }
        if (!ddmFormFieldTuples.isEmpty()) {
            this._nestedFieldsMap.put(structureVersionId, ddmFormFieldTuples);
        }
        return ddmFormLayout;
    }

    private void _upgradeDDMStructureVersion() throws Exception {
        if (this._nestedFieldsMap.isEmpty()) {
            return;
        }
        StringBundler sb = new StringBundler(5);
        sb.append("select DDMStructureVersion.structureVersionId, ");
        sb.append("DDMStructureVersion.definition from DDMStructure inner ");
        sb.append("join DDMStructureVersion on DDMStructure.structureId = ");
        sb.append("DDMStructureVersion.structureId where ");
        sb.append("DDMStructure.classNameId = ?");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureVersionId = ?");){
            ps1.setLong(1, PortalUtil.getClassNameId((String)DDMFormInstance.class.getName()));
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    long structureVersionId = rs.getLong("structureVersionId");
                    if (this._nestedFieldsMap.get(structureVersionId) == null) continue;
                    ps2.setString(1, this._upgradeDDMStructureVersionDefinition(rs.getString("definition"), structureVersionId));
                    ps2.setLong(2, structureVersionId);
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }

    private String _upgradeDDMStructureVersionDefinition(String definition, long structureVersionId) throws Exception {
        DDMForm ddmForm = DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._ddmFormDeserializer, (String)definition);
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(false);
        List<Tuple> ddmFormFieldTuples = this._nestedFieldsMap.get(structureVersionId);
        for (Tuple ddmFormFieldTuple : ddmFormFieldTuples) {
            String fieldSetDDMFormFieldName = (String)ddmFormFieldTuple.getObject(0);
            DDMFormField fieldSetDDMFormField = new DDMFormField(fieldSetDDMFormFieldName, "fieldset");
            LocalizedValue localizedValue = new LocalizedValue();
            Set locales = ddmForm.getAvailableLocales();
            locales.forEach(locale -> localizedValue.addString(locale, (String)ddmFormFieldTuple.getObject(1)));
            fieldSetDDMFormField.setLabel(localizedValue);
            fieldSetDDMFormField.setProperty("ddmStructureId", (Object)"");
            fieldSetDDMFormField.setProperty("ddmStructureLayoutId", (Object)"");
            JSONArray rowsJSONArray = this._jsonFactory.createJSONArray();
            List nestedNames = (List)ddmFormFieldTuple.getObject(3);
            nestedNames.forEach(ddmFormFieldName -> {
                fieldSetDDMFormField.addNestedDDMFormField((DDMFormField)ddmFormFieldsMap.get(ddmFormFieldName));
                rowsJSONArray.put(JSONUtil.put((String)"columns", (Object)JSONUtil.put((Object)JSONUtil.put((String)"fields", (Object)JSONUtil.put((Object)ddmFormFieldName)).put("size", ddmFormFieldTuple.getObject(2)))));
                ddmFormFieldsMap.remove(ddmFormFieldName);
            });
            fieldSetDDMFormField.setProperty("rows", (Object)rowsJSONArray);
            fieldSetDDMFormField.setShowLabel(false);
            ddmFormFieldsMap.put(fieldSetDDMFormFieldName, fieldSetDDMFormField);
        }
        ArrayList ddmFormFields = new ArrayList(ddmFormFieldsMap.values());
        ddmForm.setDDMFormFields(ddmFormFields);
        return DDMFormSerializeUtil.serialize((DDMForm)ddmForm, (DDMFormSerializer)this._ddmFormSerializer);
    }
}

