/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_1_1;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class DDMStructureLayoutUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.upgradeSchema();
        this.populateFields();
    }

    protected void populateFields() throws Exception {
        long classNameId = PortalUtil.getClassNameId(DDMStructure.class);
        try (PreparedStatement ps1 = this.connection.prepareStatement("select structureLayoutId from DDMStructureLayout where structureLayoutKey is null or structureLayoutKey = ''");
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"update DDMStructureLayout set classNameId = ?, ", "structureLayoutKey = ? where structureLayoutId = ", "?"}));
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                ps2.setLong(1, classNameId);
                ps2.setString(2, String.valueOf(this.increment()));
                ps2.setLong(3, rs.getLong(1));
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    protected void upgradeSchema() throws Exception {
        if (!this.hasColumn("DDMStructureLayout", "classNameId") && !this.hasColumn("DDMStructureLayout", "structureLayoutKey")) {
            this.runSQL("alter table DDMStructureLayout add classNameId LONG");
            this.runSQL("alter table DDMStructureLayout add structureLayoutKey VARCHAR(75) null");
        }
    }
}

