/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.render;

import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.render.BaseDDMFormFieldValueRenderer;
import com.liferay.dynamic.data.mapping.render.ValueAccessor;
import com.liferay.dynamic.data.mapping.render.ValueAccessorException;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.LayoutServiceUtil;
import java.util.Locale;

public class LinkToPageDDMFormFieldValueRenderer
extends BaseDDMFormFieldValueRenderer {
    private static final Log _log = LogFactoryUtil.getLog(LinkToPageDDMFormFieldValueRenderer.class);

    public String getSupportedDDMFormFieldType() {
        return "ddm-link-to-page";
    }

    protected ValueAccessor getValueAccessor(Locale locale) {
        return new ValueAccessor(locale){

            public String get(DDMFormFieldValue ddmFormFieldValue) {
                Value value = ddmFormFieldValue.getValue();
                JSONObject jsonObject = this.createJSONObject(value.getString(this.locale));
                long groupId = jsonObject.getLong("groupId");
                long layoutId = jsonObject.getLong("layoutId");
                if (groupId == 0L && layoutId == 0L) {
                    return "";
                }
                boolean privateLayout = jsonObject.getBoolean("privateLayout");
                try {
                    return LayoutServiceUtil.getLayoutName((long)groupId, (boolean)privateLayout, (long)layoutId, (String)LanguageUtil.getLanguageId((Locale)this.locale));
                }
                catch (PortalException portalException) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)portalException, (Throwable)portalException);
                    }
                    return LanguageUtil.format((Locale)this.locale, (String)"is-temporarily-unavailable", (Object)"content");
                }
            }

            protected JSONObject createJSONObject(String json) {
                try {
                    return JSONFactoryUtil.createJSONObject((String)json);
                }
                catch (JSONException jsonException) {
                    throw new ValueAccessorException((Throwable)jsonException);
                }
            }
        };
    }
}

